/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementRuleIndexControl;
import com.intellij.application.options.codeStyle.arrangement.util.InsetsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementListRowDecorator
extends JPanel
implements ArrangementUiComponent {
    @NotNull
    private final JLabel mySortLabel;
    @NotNull
    private final ArrangementRuleIndexControl myRowIndexControl;
    @NotNull
    private final ArrangementUiComponent myDelegate;
    @NotNull
    private final ArrangementMatchingRulesControl myControl;
    @NotNull
    private final MyActionButton myEditButton;
    @Nullable
    private Rectangle myScreenBounds;
    private boolean myBeingEdited;
    private boolean myUnderMouse;

    public ArrangementListRowDecorator(@NotNull ArrangementUiComponent delegate, @NotNull ArrangementMatchingRulesControl control) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "<init>"));
        }
        this.mySortLabel = new JLabel(AllIcons.ObjectBrowser.Sorted);
        this.myDelegate = delegate;
        this.myControl = control;
        this.mySortLabel.setVisible(false);
        AnAction action = ActionManager.getInstance().getAction("Arrangement.Rule.Edit");
        Presentation presentation = action.getTemplatePresentation().clone();
        Icon editIcon = presentation.getIcon();
        Dimension buttonSize = new Dimension(editIcon.getIconWidth(), editIcon.getIconHeight());
        this.myEditButton = new MyActionButton(action, presentation, "Arrangement.Rule.Match.Control.Place", buttonSize);
        this.myEditButton.setVisible(false);
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = 0;
        for (int i2 = 0; i2 <= 99; ++i2) {
            maxWidth = Math.max(metrics.stringWidth(String.valueOf(i2)), maxWidth);
        }
        int height = metrics.getHeight() - metrics.getDescent() - metrics.getLeading();
        int diameter = Math.max(maxWidth, height) * 5 / 3;
        this.myRowIndexControl = new ArrangementRuleIndexControl(diameter, height);
        this.setOpaque(true);
        this.init();
    }

    public void setError(@Nullable String message2) {
        this.myRowIndexControl.setError(StringUtil.isNotEmpty((String)message2));
        this.setToolTipText(message2);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBag constraints = new GridBag().anchor(10).insets(0, 8, 0, 10);
        this.add((Component)this.myRowIndexControl, constraints);
        this.add((Component)new InsetsPanel(this.mySortLabel), new GridBag().anchor(10).insets(0, 0, 0, 5));
        this.add((Component)this.myDelegate.getUiComponent(), new GridBag().weightx(1.0).anchor(17));
        this.add((Component)this.myEditButton, new GridBag().anchor(13));
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)3));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Point point = UIUtil.getLocationOnScreen((JComponent)this);
        if (point != null) {
            Rectangle bounds = this.getBounds();
            this.myScreenBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
        }
        FontMetrics metrics = g.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)metrics, (int)metrics.getHeight());
        this.myRowIndexControl.setBaseLine(baseLine + 3 + this.myDelegate.getUiComponent().getBounds().y - this.myRowIndexControl.getBounds().y);
        super.paintComponent(g);
    }

    public void setRowIndex(int row) {
        this.myRowIndexControl.setIndex(row);
    }

    public void setUnderMouse(boolean underMouse) {
        this.myUnderMouse = underMouse;
        if (this.myUnderMouse) {
            this.setBackground(UIUtil.getDecoratedRowColor());
        } else {
            this.setBackground(UIUtil.getListBackground());
        }
    }

    public void setBeingEdited(boolean beingEdited) {
        if (this.myBeingEdited && !beingEdited) {
            this.myEditButton.getPresentation().putClientProperty("selected", (Object)false);
        }
        if (!beingEdited && !this.myUnderMouse) {
            this.myEditButton.setVisible(false);
        }
        if (beingEdited && !this.myBeingEdited) {
            this.myEditButton.setVisible(true);
            this.myEditButton.getPresentation().putClientProperty("selected", (Object)true);
        }
        this.myBeingEdited = beingEdited;
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        ArrangementMatchCondition arrangementMatchCondition = this.myDelegate.getMatchCondition();
        if (arrangementMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "getMatchCondition"));
        }
        return arrangementMatchCondition;
    }

    @NotNull
    public JComponent getUiComponent() {
        ArrangementListRowDecorator arrangementListRowDecorator = this;
        if (arrangementListRowDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "getUiComponent"));
        }
        return arrangementListRowDecorator;
    }

    @Nullable
    public Rectangle getScreenBounds() {
        return this.myScreenBounds;
    }

    public void setSelected(boolean selected) {
        this.myDelegate.setSelected(selected);
    }

    public void setData(@NotNull Object data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "setData"));
        }
        this.myDelegate.setData(data);
    }

    public void setShowSortIcon(boolean show) {
        this.mySortLabel.setVisible(show);
    }

    public Rectangle onMouseEntered(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "onMouseEntered"));
        }
        this.setBackground(UIUtil.getDecoratedRowColor());
        this.myEditButton.setVisible(this.myControl.getSelectedModelRows().size() <= 1);
        return this.myDelegate.onMouseEntered(e);
    }

    @Nullable
    public Rectangle onMouseMove(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "onMouseMove"));
        }
        this.myEditButton.setVisible(this.myControl.getSelectedModelRows().size() <= 1);
        Rectangle bounds = this.getButtonScreenBounds();
        if (!this.myBeingEdited && bounds != null) {
            boolean selected = bounds.contains(event.getLocationOnScreen());
            boolean wasSelected = this.myEditButton.getPresentation().getClientProperty("selected") == Boolean.TRUE;
            this.myEditButton.getPresentation().putClientProperty("selected", (Object)selected);
            if (selected ^ wasSelected) {
                return this.myScreenBounds;
            }
        }
        return this.myDelegate.onMouseMove(event);
    }

    public void onMouseRelease(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "onMouseRelease"));
        }
        this.myEditButton.setVisible(this.myControl.getSelectedModelRows().size() <= 1);
        Rectangle bounds = this.getButtonScreenBounds();
        if (bounds != null && bounds.contains(event.getLocationOnScreen())) {
            if (this.myBeingEdited) {
                this.myControl.hideEditor();
                this.myBeingEdited = false;
            } else {
                int row = this.myControl.getRowByRenderer(this);
                if (row >= 0) {
                    this.myControl.showEditor(row);
                    this.myControl.scrollRowToVisible(row);
                    this.myBeingEdited = true;
                }
            }
            event.consume();
            return;
        }
        this.myDelegate.onMouseRelease(event);
    }

    @Nullable
    public Rectangle onMouseExited() {
        this.setBackground(UIUtil.getListBackground());
        if (!this.myBeingEdited) {
            this.myEditButton.setVisible(false);
        }
        return this.myDelegate.onMouseExited();
    }

    @Nullable
    private Rectangle getButtonScreenBounds() {
        if (this.myScreenBounds == null) {
            return null;
        }
        Rectangle bounds = this.myEditButton.getBounds();
        return new Rectangle(bounds.x + this.myScreenBounds.x, bounds.y + this.myScreenBounds.y, bounds.width, bounds.height);
    }

    @Nullable
    public ArrangementSettingsToken getToken() {
        return this.myDelegate.getToken();
    }

    @NotNull
    public Set<ArrangementSettingsToken> getAvailableTokens() {
        Set set2 = this.myDelegate.getAvailableTokens();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "getAvailableTokens"));
        }
        return set2;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException, UnsupportedOperationException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "chooseToken"));
        }
        this.myDelegate.chooseToken(data);
    }

    public boolean isSelected() {
        return this.myDelegate.isSelected();
    }

    public void reset() {
        this.myDelegate.reset();
    }

    public int getBaselineToUse(int width, int height) {
        return this.myDelegate.getBaselineToUse(width, height);
    }

    public void setListener(@NotNull ArrangementUiComponent.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator", "setListener"));
        }
        this.myDelegate.setListener(listener2);
    }

    public void handleMouseClickOnSelected() {
        this.myDelegate.handleMouseClickOnSelected();
    }

    public boolean alwaysCanBeActive() {
        return false;
    }

    @Override
    public String toString() {
        return "list row decorator for " + this.myDelegate.toString();
    }

    private static class MyActionButton
    extends ActionButton {
        MyActionButton(AnAction action, Presentation presentation, String place, @NotNull Dimension minimumSize) {
            if (minimumSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator$MyActionButton", "<init>"));
            }
            super(action, presentation, place, minimumSize);
        }

        @NotNull
        public Presentation getPresentation() {
            Presentation presentation = this.myPresentation;
            if (presentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/util/ArrangementListRowDecorator$MyActionButton", "getPresentation"));
            }
            return presentation;
        }
    }
}

