/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.FileStatusColorsPageFactory;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowColorsInSchemeState;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.application.options.colors.ScopeColorsPageFactory;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ColorUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider,
SchemesModel<EditorColorsScheme> {
    public static final String ID = "reference.settingsdialog.IDE.editor.colors";
    public static final String FONT_CONFIGURABLE_NAME = "Color Scheme Font";
    private Map<String, MyColorScheme> mySchemes;
    private MyColorScheme mySelectedScheme;
    public static final String FILE_STATUS_GROUP = ApplicationBundle.message((String)"title.file.status", (Object[])new Object[0]);
    public static final String SCOPES_GROUP = ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myIsReset = false;

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/application/options/colors/ColorAndFontOptions", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void stateChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        if (!this.mySelectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "selectScheme"));
        }
        this.mySelectedScheme = this.getScheme(name2);
        return this.mySelectedScheme;
    }

    MyColorScheme getScheme(String name2) {
        return this.mySchemes.get(name2);
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        return this.mySelectedScheme.getDescriptors();
    }

    @Override
    public boolean canDuplicateScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "canDuplicateScheme"));
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "canResetScheme"));
        }
        AbstractColorsScheme originalScheme = scheme2 instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme2).getOriginal() : null;
        return !ColorAndFontOptions.isReadOnly(scheme2) && scheme2.getName().startsWith("_@user_") && originalScheme instanceof ReadOnlyColorsScheme;
    }

    @Override
    public boolean canDeleteScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "canDeleteScheme"));
        }
        return !ColorAndFontOptions.isReadOnly(scheme2) && ColorAndFontOptions.canBeDeleted(scheme2);
    }

    @Override
    public boolean isProjectScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "isProjectScheme"));
        }
        return false;
    }

    @Override
    public boolean canRenameScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "canRenameScheme"));
        }
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name2, boolean projectScheme) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "containsScheme"));
        }
        assert (!projectScheme);
        return this.mySchemes.get(name2) != null || this.mySchemes.get("_@user_" + name2) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "differsFromDefault"));
        }
        if (scheme2.getName().startsWith("_@user_")) {
            String displayName = SchemeManager.getDisplayName((Scheme)scheme2);
            EditorColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getScheme(displayName);
            if (defaultScheme == null) {
                defaultScheme = EditorColorsManager.getInstance().getScheme(displayName);
            }
            if (defaultScheme != null && scheme2 instanceof AbstractColorsScheme) {
                return !((AbstractColorsScheme)scheme2).settingsEqual(defaultScheme);
            }
        }
        return false;
    }

    public static boolean isReadOnly(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "isReadOnly"));
        }
        return ((MyColorScheme)scheme2).isReadOnly();
    }

    public static boolean canBeDeleted(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "canBeDeleted"));
        }
        return scheme2 instanceof MyColorScheme && ((MyColorScheme)scheme2).canBeDeleted();
    }

    @NotNull
    public Collection<EditorColorsScheme> getOrderedSchemes() {
        ArrayList<EditorColorsScheme> schemes = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        Collections.sort(schemes, EditorColorSchemesComparator.INSTANCE);
        ArrayList<EditorColorsScheme> arrayList = schemes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getOrderedSchemes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<EditorColorsScheme> getSchemes() {
        ArrayList<EditorColorsScheme> arrayList = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getSchemes"));
        }
        return arrayList;
    }

    public boolean saveSchemeAs(@NotNull EditorColorsScheme editorScheme, @NotNull String name2) {
        if (editorScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorScheme", "com/intellij/application/options/colors/ColorAndFontOptions", "saveSchemeAs"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "saveSchemeAs"));
        }
        if (editorScheme instanceof MyColorScheme) {
            MyColorScheme scheme2 = (MyColorScheme)editorScheme;
            EditorColorsScheme clone = (EditorColorsScheme)scheme2.getParentScheme().clone();
            scheme2.apply(clone);
            if (clone instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)clone).setSaveNeeded(true);
            }
            clone.setName(name2);
            MyColorScheme newScheme = new MyColorScheme(clone);
            ColorAndFontOptions.initScheme(newScheme);
            newScheme.setIsNew();
            this.mySchemes.put(name2, newScheme);
            this.selectScheme(newScheme.getName());
            this.resetSchemesCombo(null);
            return true;
        }
        return false;
    }

    public void addImportedScheme(@NotNull EditorColorsScheme imported) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "com/intellij/application/options/colors/ColorAndFontOptions", "addImportedScheme"));
        }
        if (imported instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)imported).setSaveNeeded(true);
        }
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.mySchemes.put(imported.getName(), newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    @Override
    public void removeScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "removeScheme"));
        }
        String schemeName = scheme2.getName();
        if (this.mySelectedScheme.getName().equals(schemeName)) {
            this.selectDefaultScheme();
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = this.mySchemes.get(schemeName);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.mySchemes.remove(schemeName);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    private void selectDefaultScheme() {
        DefaultColorsScheme defaultScheme = (DefaultColorsScheme)EditorColorsManager.getInstance().getScheme("Default");
        this.selectScheme(defaultScheme.getEditableCopyName());
    }

    void resetSchemeToOriginal(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "resetSchemeToOriginal"));
        }
        MyColorScheme schemeToReset = this.mySchemes.get(name2);
        schemeToReset.resetToOriginal();
        this.resetImpl();
        this.selectScheme(name2);
        this.resetSchemesCombo(null);
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myApplyCompleted) {
            return;
        }
        try {
            EditorColorsManager myColorsManager = EditorColorsManager.getInstance();
            SchemeManager<EditorColorsScheme> schemeManager2 = ((EditorColorsManagerImpl)myColorsManager).getSchemeManager();
            ArrayList<EditorColorsScheme> result2 = new ArrayList<EditorColorsScheme>(this.mySchemes.values().size());
            boolean activeSchemeModified = false;
            EditorColorsScheme activeOriginalScheme = this.mySelectedScheme.getParentScheme();
            for (MyColorScheme scheme2 : this.mySchemes.values()) {
                boolean isModified = scheme2.apply();
                if (isModified && !activeSchemeModified && activeOriginalScheme == scheme2.getParentScheme()) {
                    activeSchemeModified = true;
                }
                result2.add(scheme2.getParentScheme());
            }
            boolean refreshEditors = activeSchemeModified && schemeManager2.getCurrentScheme() == activeOriginalScheme;
            schemeManager2.setSchemes(ColorAndFontOptions.includingInvisible(result2, schemeManager2), activeOriginalScheme);
            if (refreshEditors) {
                ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
            }
            boolean isEditorThemeDark = ColorUtil.isDark((Color)activeOriginalScheme.getDefaultBackground());
            ColorAndFontOptions.changeLafIfNecessary(isEditorThemeDark);
            this.reset();
        }
        finally {
            this.myApplyCompleted = true;
        }
    }

    private static List<EditorColorsScheme> includingInvisible(@NotNull List<EditorColorsScheme> schemeList, @NotNull SchemeManager<EditorColorsScheme> schemeManager2) {
        if (schemeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeList", "com/intellij/application/options/colors/ColorAndFontOptions", "includingInvisible"));
        }
        if (schemeManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManager", "com/intellij/application/options/colors/ColorAndFontOptions", "includingInvisible"));
        }
        for (EditorColorsScheme scheme2 : schemeManager2.getAllSchemes()) {
            if (AbstractColorsScheme.isVisible(scheme2)) continue;
            schemeList.add(scheme2);
        }
        return schemeList;
    }

    private static void changeLafIfNecessary(boolean isDarkEditorTheme) {
        final String propKey = "change.laf.on.editor.theme.change";
        String value2 = PropertiesComponent.getInstance().getValue(propKey);
        if ("false".equals(value2)) {
            return;
        }
        boolean applyAlways = "true".equals(value2);
        DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    PropertiesComponent.getInstance().setValue(propKey, Boolean.toString(exitCode == 0));
                }
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }
        };
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        LafManager lafManager = LafManager.getInstance();
        if (isDarkEditorTheme && !UIUtil.isUnderDarcula()) {
            if (applyAlways || Messages.showYesNoDialog((String)("Looks like you have set a dark editor theme. Would you like to set dark theme for entire " + productName), (String)("Change " + productName + " theme"), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) == 0) {
                lafManager.setCurrentLookAndFeel((UIManager.LookAndFeelInfo)new DarculaLookAndFeelInfo());
                lafManager.updateUI();
                SwingUtilities.invokeLater(DarculaInstaller::install);
            }
        } else if (!isDarkEditorTheme && UIUtil.isUnderDarcula() && lafManager instanceof LafManagerImpl && (applyAlways || Messages.showYesNoDialog((String)("Looks like you have set a bright editor theme. Would you like to set bright theme for entire " + productName), (String)("Change " + productName + " theme"), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) == 0)) {
            lafManager.setCurrentLookAndFeel(((LafManagerImpl)lafManager).getDefaultLaf());
            lafManager.updateUI();
            SwingUtilities.invokeLater(DarculaInstaller::uninstall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        return this.myRootSchemesPanel;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public Configurable[] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        ArrayList<InnerSearchableConfigurable> result2 = new ArrayList<InnerSearchableConfigurable>();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        result2.addAll(new ArrayList<InnerSearchableConfigurable>(this.mySubPanelFactories.values()));
        Configurable[] configurableArray = result2.toArray(new Configurable[result2.size()]);
        if (configurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "buildConfigurables"));
        }
        return configurableArray;
    }

    @NotNull
    private Set<NewColorAndFontPanel> getPanels() {
        HashSet<NewColorAndFontPanel> result2 = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel2 = configurable.getSubPanelIfInitialized();
            if (panel2 == null) continue;
            result2.add(panel2);
        }
        HashSet<NewColorAndFontPanel> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getPanels"));
        }
        return hashSet;
    }

    protected List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactory> result2 = new ArrayList<ColorAndFontPanelFactory>();
        ArrayList<ColorAndFontPanelFactoryEx> extensions = new ArrayList<ColorAndFontPanelFactoryEx>();
        extensions.add(new FontConfigurableFactory());
        extensions.add(new ConsoleFontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            extensions.add(new ColorAndFontPanelFactoryEx(){

                @Override
                @NotNull
                public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$2", "createPanel"));
                    }
                    SimpleEditorPreview preview = new SimpleEditorPreview(options, page);
                    NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create(preview, page.getDisplayName(), options, null, page);
                    if (newColorAndFontPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$2", "createPanel"));
                    }
                    return newColorAndFontPanel;
                }

                @Override
                @NotNull
                public String getPanelDisplayName() {
                    String string = page.getDisplayName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$2", "getPanelDisplayName"));
                    }
                    return string;
                }

                public DisplayPriority getPriority() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getPriority();
                    }
                    return DisplayPriority.LANGUAGE_SETTINGS;
                }
            });
        }
        Collections.addAll(extensions, Extensions.getExtensions(ColorAndFontPanelFactory.EP_NAME));
        Collections.sort(extensions, (f1, f2) -> {
            if (f1 instanceof DisplayPrioritySortable) {
                if (!(f2 instanceof DisplayPrioritySortable)) return 1;
                int result1 = ((DisplayPrioritySortable)f1).getPriority().compareTo((Enum)((DisplayPrioritySortable)f2).getPriority());
                if (result1 == 0) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
                return result1;
            }
            if (!(f2 instanceof DisplayPrioritySortable)) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
            return -1;
        });
        result2.addAll(extensions);
        result2.add(new FileStatusColorsPageFactory());
        result2.add(new ScopeColorsPageFactory());
        return result2;
    }

    private void initAll() {
        this.mySchemes = new THashMap();
        for (EditorColorsScheme allScheme : EditorColorsManager.getInstance().getAllSchemes()) {
            MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put(schemeDelegate.getName(), schemeDelegate);
        }
        this.mySelectedScheme = this.mySchemes.get(EditorColorsManager.getInstance().getGlobalScheme().getName());
        assert (this.mySelectedScheme != null) : EditorColorsManager.getInstance().getGlobalScheme().getName() + "; myschemes=" + this.mySchemes;
    }

    private static void initScheme(@NotNull MyColorScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initScheme"));
        }
        ArrayList<EditorSchemeAttributeDescriptor> descriptions = new ArrayList<EditorSchemeAttributeDescriptor>();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme2);
        AbstractColorsScheme original = scheme2.getOriginal();
        if (original != null && original instanceof DefaultColorsScheme) {
            ColorAndFontOptions.initFileStatusDescriptors(descriptions, scheme2);
        }
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme2);
        scheme2.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[descriptions.size()]));
    }

    private static void initPluggedDescriptions(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        ColorSettingsPage[] pages;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initPluggedDescriptions"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initPluggedDescriptions"));
        }
        for (ColorSettingsPage colorSettingsPage : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme2);
        }
        for (ColorSettingsPage colorSettingsPage : (ColorAndFontDescriptorsProvider[])Extensions.getExtensions((ExtensionPointName)ColorAndFontDescriptorsProvider.EP_NAME)) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme2);
        }
    }

    private static void initDescriptions(@NotNull ColorAndFontDescriptorsProvider provider, @NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        ColorDescriptor[] colorDescriptors;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        String group = provider.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(provider);
        if (provider instanceof RainbowColorSettingsPage) {
            descriptions.add((EditorSchemeAttributeDescriptor)new RainbowAttributeDescriptor(((RainbowColorSettingsPage)provider).getLanguage(), group, ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]), scheme2, scheme2.myRainbowState));
        }
        for (AttributesDescriptor descriptor : attributeDescriptors) {
            ColorAndFontOptions.addSchemedDescription(descriptions, descriptor.getDisplayName(), group, descriptor.getKey(), scheme2, null, null);
        }
        for (ColorDescriptor descriptor : colorDescriptors = provider.getColorDescriptors()) {
            ColorKey back = descriptor.getKind() == ColorDescriptor.Kind.BACKGROUND ? descriptor.getKey() : null;
            ColorKey fore = descriptor.getKind() == ColorDescriptor.Kind.FOREGROUND ? descriptor.getKey() : null;
            ColorAndFontOptions.addEditorSettingDescription(descriptions, descriptor.getDisplayName(), group, back, fore, scheme2);
        }
    }

    private static void initFileStatusDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme2) {
        FileStatus[] statuses;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initFileStatusDescriptors"));
        }
        for (FileStatus fileStatus : statuses = FileStatusFactory.getInstance().getAllFileStatuses()) {
            ColorAndFontOptions.addEditorSettingDescription(descriptions, fileStatus.getText(), FILE_STATUS_GROUP, null, fileStatus.getColorKey(), scheme2);
        }
    }

    private static void initScopesDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        Project[] projects;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initScopesDescriptors"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initScopesDescriptors"));
        }
        THashSet namedScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int computeHashCode(@NotNull Pair<NamedScope, NamedScopesHolder> object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/application/options/colors/ColorAndFontOptions$3", "computeHashCode"));
                }
                return ((NamedScope)object.getFirst()).getName().hashCode();
            }

            public boolean equals(@NotNull Pair<NamedScope, NamedScopesHolder> o1, @NotNull Pair<NamedScope, NamedScopesHolder> o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/application/options/colors/ColorAndFontOptions$3", "equals"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/application/options/colors/ColorAndFontOptions$3", "equals"));
                }
                return ((NamedScope)o1.getFirst()).getName().equals(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)project2);
            List<Pair<NamedScope, NamedScopesHolder>> cachedScopes = validationManager.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list2 = new ArrayList(namedScopes);
        Collections.sort(list2, (o1, o2) -> ((NamedScope)o1.getFirst()).getName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getName()));
        for (Pair pair2 : list2) {
            NamedScope namedScope = (NamedScope)pair2.getFirst();
            String name2 = namedScope.getName();
            TextAttributesKey textAttributesKey = ScopeAttributesUtil.getScopeTextAttributeKey(name2);
            if (scheme2.getAttributes(textAttributesKey) == null) {
                scheme2.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair2.getSecond();
            PackageSet value2 = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (value2 == null ? "" : ": " + value2.getText());
            ColorAndFontOptions.addSchemedDescription(descriptions, name2, SCOPES_GROUP, textAttributesKey, scheme2, holder.getIcon(), toolTip);
        }
    }

    @Nullable
    private static String calcType(@Nullable ColorKey backgroundKey, @Nullable ColorKey foregroundKey) {
        if (foregroundKey != null) {
            return foregroundKey.getExternalName();
        }
        if (backgroundKey != null) {
            return backgroundKey.getExternalName();
        }
        return null;
    }

    private static void addEditorSettingDescription(@NotNull List<EditorSchemeAttributeDescriptor> list2, String name2, String group, @Nullable ColorKey backgroundKey, @Nullable ColorKey foregroundKey, @NotNull EditorColorsScheme scheme2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/ColorAndFontOptions", "addEditorSettingDescription"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "addEditorSettingDescription"));
        }
        list2.add((EditorSchemeAttributeDescriptor)new EditorSettingColorDescription(name2, group, backgroundKey, foregroundKey, ColorAndFontOptions.calcType(backgroundKey, foregroundKey), scheme2));
    }

    private static void addSchemedDescription(@NotNull List<EditorSchemeAttributeDescriptor> list2, String name2, String group, @NotNull TextAttributesKey key2, @NotNull MyColorScheme scheme2, Icon icon, String toolTip) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        list2.add((EditorSchemeAttributeDescriptor)new SchemeTextAttributesDescription(name2, group, key2, scheme2, icon, toolTip));
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = new SchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(Object source) {
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }
            });
        }
    }

    public void disposeUIResources() {
        block6: {
            try {
                if (this.myDisposeCompleted) break block6;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
            }
        }
    }

    @NotNull
    public String getHelpTopic() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getHelpTopic"));
        }
        return ID;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getId"));
        }
        return string;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(@NotNull Class pageClass) {
        if (pageClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageClass", "com/intellij/application/options/colors/ColorAndFontOptions", "findSubConfigurable"));
        }
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.buildConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable;
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        InnerSearchableConfigurable child = (InnerSearchableConfigurable)this.findSubConfigurable(pageName);
        return child == null ? null : child.createPanel();
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search, @NotNull String name2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/application/options/colors/ColorAndFontOptions", "selectOrEditColor"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "selectOrEditColor"));
        }
        return ColorAndFontOptions.selectOrEdit(context, search, options -> {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "lambda$selectOrEditColor$2"));
            }
            return options.findSubConfigurable(name2);
        });
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search, @NotNull Class<?> type2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/application/options/colors/ColorAndFontOptions", "selectOrEditColor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/application/options/colors/ColorAndFontOptions", "selectOrEditColor"));
        }
        return ColorAndFontOptions.selectOrEdit(context, search, options -> {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/application/options/colors/ColorAndFontOptions", "lambda$selectOrEditColor$3"));
            }
            return options.findSubConfigurable(type2);
        });
    }

    private static boolean selectOrEdit(DataContext context, String search, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        return ColorAndFontOptions.select(context, search, function) || ColorAndFontOptions.edit(context, search, function);
    }

    private static boolean select(DataContext context, String search, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        Settings settings = (Settings)Settings.KEY.getData(context);
        if (settings == null) {
            return false;
        }
        ColorAndFontOptions options = settings.find(ColorAndFontOptions.class);
        if (options == null) {
            return false;
        }
        SearchableConfigurable page = function.apply(options);
        if (page == null) {
            return false;
        }
        settings.select((Configurable)page, search);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean edit(DataContext context, String search, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        ColorAndFontOptions options = new ColorAndFontOptions();
        SearchableConfigurable page = function.apply(options);
        Configurable[] configurables = options.getConfigurables();
        try {
            if (page != null) {
                Runnable runnable2 = search == null ? null : page.enableSearch(search);
                Window window = UIUtil.getWindow((Component)((Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context)));
                if (window != null) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)window, (Configurable)page, runnable2);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Project)CommonDataKeys.PROJECT.getData(context), (Configurable)page, runnable2);
                }
            }
        }
        finally {
            for (Configurable configurable : configurables) {
                configurable.disposeUIResources();
            }
            options.disposeUIResources();
        }
        return page != null;
    }

    private class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked;
        @NotNull
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "<init>"));
            }
            this.mySubInitInvoked = false;
            this.myFactory = factory;
        }

        @NotNull
        @Nls
        public String getDisplayName() {
            String string = this.myFactory.getPanelDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "getDisplayName"));
            }
            return string;
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(Object source) {
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel2 : ColorAndFontOptions.this.getPanels()) {
                            panel2.updatePreview();
                            panel2.updateSchemesPanel();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme2 : ColorAndFontOptions.this.mySchemes.values()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme2.isFontModified() && !scheme2.isConsoleFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor : scheme2.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor) || !descriptor.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        @NotNull
        public String getId() {
            String string = ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "getId"));
            }
            return string;
        }

        public Runnable enableSearch(String option) {
            return this.createPanel().showOption(option);
        }

        @Override
        @NotNull
        public Set<String> processListOptions() {
            Set<String> set2 = this.createPanel().processListOptions();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "processListOptions"));
            }
            return set2;
        }

        @NotNull
        @NonNls
        public String toString() {
            String string = "Color And Fonts for " + this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "toString"));
            }
            return string;
        }
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew;
        private RainbowColorsInSchemeState myRainbowState;

        private MyColorScheme(@NotNull EditorColorsScheme parentScheme) {
            if (parentScheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScheme", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "<init>"));
            }
            super(parentScheme);
            this.myIsNew = false;
            if (parentScheme.isUseEditorFontPreferencesInConsole()) {
                this.setUseEditorFontPreferencesInConsole();
            } else {
                this.setConsoleFontPreferences(parentScheme.getConsoleFontPreferences());
            }
            if (parentScheme.isUseAppFontPreferencesInEditor()) {
                this.setUseAppFontPreferencesInEditor();
            } else {
                this.setFontPreferences(parentScheme.getFontPreferences());
            }
            this.setQuickDocFontSize(parentScheme.getQuickDocFontSize());
            this.myName = parentScheme.getName();
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)this, (SchemeMetaInfo)parentScheme);
            this.myRainbowState = new RainbowColorsInSchemeState(this, parentScheme);
            this.initFonts();
        }

        @Override
        @Nullable
        public AbstractColorsScheme getOriginal() {
            return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getOriginal() : null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "setName"));
            }
            this.myName = name2;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors) {
            this.myDescriptors = descriptors;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        @Override
        public boolean isReadOnly() {
            return this.myParentScheme instanceof ReadOnlyColorsScheme;
        }

        public boolean isModified() {
            if (this.isFontModified() || this.isConsoleFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeDeleted() {
            return this.myParentScheme instanceof AbstractColorsScheme && ((AbstractColorsScheme)this.myParentScheme).canBeDeleted();
        }

        private boolean isFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getFontPreferences(), this.myParentScheme.getFontPreferences());
        }

        private boolean isConsoleFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getConsoleFontPreferences(), this.myParentScheme.getConsoleFontPreferences());
        }

        private boolean apply() {
            if (!(this.myParentScheme instanceof ReadOnlyColorsScheme)) {
                return this.apply(this.myParentScheme);
            }
            return false;
        }

        private boolean apply(@NotNull EditorColorsScheme scheme2) {
            boolean isModified;
            if (scheme2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "apply"));
            }
            boolean bl = isModified = this.isFontModified() || this.isConsoleFontModified();
            if (this.isUseAppFontPreferencesInEditor()) {
                scheme2.setUseAppFontPreferencesInEditor();
            } else {
                scheme2.setFontPreferences(this.getFontPreferences());
            }
            if (this.isUseEditorFontPreferencesInConsole()) {
                scheme2.setUseEditorFontPreferencesInConsole();
            } else {
                scheme2.setConsoleFontPreferences(this.getConsoleFontPreferences());
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                isModified = true;
                descriptor.apply(scheme2);
            }
            if (isModified && scheme2 instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)scheme2).setSaveNeeded(true);
            }
            return isModified;
        }

        @Override
        public Object clone() {
            return null;
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }

        @Override
        @NotNull
        public String toString() {
            String string = "temporary scheme for " + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "toString"));
            }
            return string;
        }

        public boolean isInherited(TextAttributesKey key2) {
            TextAttributesKey fallbackKey = key2.getFallbackAttributeKey();
            if (fallbackKey != null) {
                TextAttributes ownAttrs;
                if (this.myParentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key2)) != null) {
                    return ownAttrs == TextAttributes.USE_INHERITED_MARKER;
                }
                TextAttributes attributes = this.getAttributes(key2);
                if (attributes != null) {
                    TextAttributes fallbackAttributes = this.getAttributes(fallbackKey);
                    return attributes == fallbackAttributes;
                }
            }
            return false;
        }

        public void resetToOriginal() {
            AbstractColorsScheme originalScheme;
            if (this.myParentScheme instanceof AbstractColorsScheme && (originalScheme = ((AbstractColorsScheme)this.myParentScheme).getOriginal()) != null) {
                originalScheme.copyTo((AbstractColorsScheme)this.myParentScheme);
                ((AbstractColorsScheme)this.myParentScheme).setSaveNeeded(true);
            }
        }
    }

    private static class EditorSettingColorDescription
    extends ColorAndFontDescription {
        private GetSetColor myGetSetForeground;
        private GetSetColor myGetSetBackground;

        private EditorSettingColorDescription(String name2, String group, ColorKey backgroundKey, ColorKey foregroundKey, String type2, EditorColorsScheme scheme2) {
            super(name2, group, type2, scheme2, null, null);
            if (backgroundKey != null) {
                this.myGetSetBackground = new GetSetColor(backgroundKey, scheme2);
            }
            if (foregroundKey != null) {
                this.myGetSetForeground = new GetSetColor(foregroundKey, scheme2);
            }
            this.initCheckedStatus();
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type2) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type2) {
        }

        @Override
        @NotNull
        public EffectType getExternalEffectType() {
            EffectType effectType = EffectType.LINE_UNDERSCORE;
            if (effectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription", "getExternalEffectType"));
            }
            return effectType;
        }

        @Override
        public Color getExternalForeground() {
            if (this.myGetSetForeground == null) {
                return null;
            }
            return this.myGetSetForeground.getColor();
        }

        @Override
        public void setExternalForeground(Color col) {
            if (this.myGetSetForeground == null) {
                return;
            }
            this.myGetSetForeground.setColor(col);
        }

        @Override
        public Color getExternalBackground() {
            if (this.myGetSetBackground == null) {
                return null;
            }
            return this.myGetSetBackground.getColor();
        }

        @Override
        public void setExternalBackground(Color col) {
            if (this.myGetSetBackground == null) {
                return;
            }
            this.myGetSetBackground.setColor(col);
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myGetSetForeground != null;
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myGetSetBackground != null;
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            return this.myGetSetBackground != null && this.myGetSetBackground.isModified() || this.myGetSetForeground != null && this.myGetSetForeground.isModified();
        }

        public void apply(EditorColorsScheme scheme2) {
            if (this.myGetSetBackground != null) {
                this.myGetSetBackground.apply(scheme2);
            }
            if (this.myGetSetForeground != null) {
                this.myGetSetForeground.apply(scheme2);
            }
        }
    }

    private static class GetSetColor {
        private final ColorKey myKey;
        private final EditorColorsScheme myScheme;
        private final Color myInitialColor;
        private Color myColor;

        private GetSetColor(ColorKey key2, EditorColorsScheme scheme2) {
            this.myKey = key2;
            this.myScheme = scheme2;
            this.myInitialColor = this.myColor = this.myScheme.getColor(this.myKey);
        }

        public Color getColor() {
            return this.myColor;
        }

        public void setColor(Color col) {
            if (this.getColor() == null || !this.getColor().equals(col)) {
                this.myColor = col;
            }
        }

        public void apply(EditorColorsScheme scheme2) {
            if (scheme2 == null) {
                scheme2 = this.myScheme;
            }
            scheme2.setColor(this.myKey, this.myColor);
        }

        public boolean isModified() {
            return !Comparing.equal((Object)this.myColor, (Object)this.myInitialColor);
        }
    }

    private static class SchemeTextAttributesDescription
    extends TextAttributesDescription {
        @NotNull
        private final TextAttributes myInitialAttributes;
        @NotNull
        private final TextAttributesKey key;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorSettingsPage, AttributesDescriptor> myBaseAttributeDescriptor;
        private boolean myIsInheritedInitial;

        private SchemeTextAttributesDescription(String name2, String group, @NotNull TextAttributesKey key2, @NotNull MyColorScheme scheme2, Icon icon, String toolTip) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "<init>"));
            }
            if (scheme2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "<init>"));
            }
            super(name2, group, SchemeTextAttributesDescription.getInitialAttributes(scheme2, key2).clone(), key2, scheme2, icon, toolTip);
            this.myIsInheritedInitial = false;
            this.key = key2;
            this.myInitialAttributes = SchemeTextAttributesDescription.getInitialAttributes(scheme2, key2);
            TextAttributesKey fallbackKey = key2.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.myFallbackAttributes = scheme2.getAttributes(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getAttributeDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = new Pair(null, (Object)new AttributesDescriptor(fallbackKey.getExternalName(), fallbackKey));
                }
            }
            this.myIsInheritedInitial = scheme2.isInherited(key2);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial) {
                this.setInheritedAttributes(this.getTextAttributes());
            }
            this.initCheckedStatus();
        }

        private void setInheritedAttributes(@NotNull TextAttributes attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "setInheritedAttributes"));
            }
            attributes.setFontType(this.myFallbackAttributes.getFontType());
            attributes.setForegroundColor(this.myFallbackAttributes.getForegroundColor());
            attributes.setBackgroundColor(this.myFallbackAttributes.getBackgroundColor());
            attributes.setErrorStripeColor(this.myFallbackAttributes.getErrorStripeColor());
            attributes.setEffectColor(this.myFallbackAttributes.getEffectColor());
            attributes.setEffectType(this.myFallbackAttributes.getEffectType());
        }

        @NotNull
        private static TextAttributes getInitialAttributes(@NotNull MyColorScheme scheme2, @NotNull TextAttributesKey key2) {
            if (scheme2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            TextAttributes attributes = scheme2.getAttributes(key2);
            TextAttributes textAttributes = attributes != null ? attributes : new TextAttributes();
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            return textAttributes;
        }

        public void apply(EditorColorsScheme scheme2) {
            if (scheme2 == null) {
                scheme2 = this.getScheme();
            }
            if (scheme2 instanceof EditorColorsSchemeImpl) {
                if (!this.isInherited()) {
                    scheme2.setAttributes(this.key, this.getTextAttributes());
                } else if (!this.myIsInheritedInitial) {
                    scheme2.setAttributes(this.key, USE_INHERITED_MARKER);
                }
            } else {
                scheme2.setAttributes(this.key, this.isInherited() ? USE_INHERITED_MARKER : this.getTextAttributes());
            }
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialAttributes, (Object)this.getTextAttributes()) || this.myIsInheritedInitial;
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        @Override
        @Nullable
        public Pair<ColorSettingsPage, AttributesDescriptor> getBaseAttributeDescriptor() {
            return this.myBaseAttributeDescriptor;
        }
    }

    private static class ConsoleFontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private ConsoleFontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "createPanel"));
            }
            FontEditorPreview previewPanel = new FontEditorPreview(() -> {
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "lambda$createPanel$0"));
                }
                return options.getSelectedScheme();
            }, false){

                @Override
                protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
                    return ConsoleViewUtil.updateConsoleColorScheme(selectedScheme);
                }
            };
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options, 0), new ConsoleFontOptions(options), previewPanel, "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "createPanel"));
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if ("Console Font" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "getPanelDisplayName"));
            }
            return "Console Font";
        }

        @NotNull
        public DisplayPriority getPriority() {
            DisplayPriority displayPriority = DisplayPriority.FONT_SETTINGS;
            if (displayPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "getPriority"));
            }
            return displayPriority;
        }
    }

    private static class FontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private FontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "createPanel"));
            }
            FontEditorPreview previewPanel = new FontEditorPreview(() -> {
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "lambda$createPanel$0"));
                }
                return options.getSelectedScheme();
            }, true);
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options, 0), new FontOptions(options), previewPanel, ColorAndFontOptions.FONT_CONFIGURABLE_NAME, null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "createPanel"));
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if (ColorAndFontOptions.FONT_CONFIGURABLE_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "getPanelDisplayName"));
            }
            return ColorAndFontOptions.FONT_CONFIGURABLE_NAME;
        }

        public DisplayPriority getPriority() {
            return DisplayPriority.FONT_SETTINGS;
        }
    }
}

