/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSchemeImporter
implements SchemeImporter<EditorColorsScheme> {
    private static final String[] FILE_EXTENSIONS = new String[]{".icls".substring(1), "jar"};

    @NotNull
    public String[] getSourceExtensions() {
        if (FILE_EXTENSIONS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorSchemeImporter", "getSourceExtensions"));
        }
        return FILE_EXTENSIONS;
    }

    @Nullable
    public EditorColorsScheme importScheme(@NotNull Project project2, @NotNull VirtualFile selectedFile, @NotNull EditorColorsScheme currentScheme, @NotNull SchemeFactory<EditorColorsScheme> schemeFactory) throws SchemeImportException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/application/options/colors/ColorSchemeImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/application/options/colors/ColorSchemeImporter", "importScheme"));
        }
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/application/options/colors/ColorSchemeImporter", "importScheme"));
        }
        if (schemeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeFactory", "com/intellij/application/options/colors/ColorSchemeImporter", "importScheme"));
        }
        Element root = SchemeImportUtil.loadSchemeDom(selectedFile);
        String name2 = ColorSchemeImporter.getSchemeName(root);
        EditorColorsScheme scheme2 = (EditorColorsScheme)schemeFactory.createNewScheme(name2);
        String preferredName = scheme2.getName();
        scheme2.readExternal(root);
        scheme2.setName(preferredName);
        return scheme2;
    }

    static String getSchemeName(@NotNull Element root) throws SchemeImportException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/application/options/colors/ColorSchemeImporter", "getSchemeName"));
        }
        String name2 = root.getAttributeValue("name");
        if (name2 == null) {
            throw new SchemeImportException("Scheme 'name' attribute is missing.");
        }
        return name2;
    }
}

