/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowColorsInSchemeState {
    private final EditorColorsScheme myEditedScheme;
    private final EditorColorsScheme myOriginalScheme;

    public RainbowColorsInSchemeState(@NotNull EditorColorsScheme editedScheme, @NotNull EditorColorsScheme originalScheme) {
        if (editedScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedScheme", "com/intellij/application/options/colors/RainbowColorsInSchemeState", "<init>"));
        }
        if (originalScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalScheme", "com/intellij/application/options/colors/RainbowColorsInSchemeState", "<init>"));
        }
        this.myEditedScheme = editedScheme;
        this.myOriginalScheme = originalScheme;
    }

    public void apply(@Nullable EditorColorsScheme scheme2) {
        if (scheme2 != null && scheme2 != this.myEditedScheme) {
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)scheme2, (SchemeMetaInfo)this.myEditedScheme);
            for (TextAttributesKey key2 : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
                Color color = this.myEditedScheme.getAttributes(key2).getForegroundColor();
                if (color.equals(scheme2.getAttributes(key2).getForegroundColor())) continue;
                scheme2.setAttributes(key2, RainbowHighlighter.createRainbowAttribute(color));
            }
            RainbowColorsInSchemeState.updateRainbowMarkup();
        }
    }

    private static void updateRainbowMarkup() {
        Editor[] allEditors;
        for (Editor editor : allEditors = EditorFactory.getInstance().getAllEditors()) {
            PsiFile file2;
            Project project2 = editor.getProject();
            if (project2 == null || (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) == null) continue;
            DaemonCodeAnalyzer.getInstance((Project)project2).restart(file2);
        }
    }

    public boolean isModified(@Nullable Language language) {
        return language == null && this.isRainbowColorsModified() || RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myEditedScheme, language) != RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myOriginalScheme, language);
    }

    private boolean isRainbowColorsModified() {
        for (TextAttributesKey key2 : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
            if (this.myEditedScheme.getAttributes(key2).equals((Object)this.myOriginalScheme.getAttributes(key2))) continue;
            return true;
        }
        return false;
    }
}

