/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableSchemesCombo<T extends Scheme> {
    public static final String EMPTY_NAME_MESSAGE = "The name must not be empty";
    public static final String NAME_ALREADY_EXISTS_MESSAGE = "Name is already in use. Please change to unique name.";
    public static final String EDITING_HINT = "Enter to save, Esc to cancel";
    public static final int COMBO_WIDTH = 200;
    private SchemesCombo<T> myComboBox;
    private JPanel myRootPanel;
    private AbstractSchemesPanel<T, ?> mySchemesPanel;
    private final CardLayout myLayout;
    private final JTextField myNameEditorField;
    @Nullable
    private NameEditData myNameEditData;
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);

    public EditableSchemesCombo(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/schemes/EditableSchemesCombo", "<init>"));
        }
        this.mySchemesPanel = schemesPanel;
        this.myLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myLayout);
        this.createCombo();
        this.myRootPanel.add((Component)((Object)this.myComboBox));
        this.myNameEditorField = this.createNameEditorField();
        this.myRootPanel.add(this.myNameEditorField);
        this.myRootPanel.setPreferredSize(new Dimension(JBUI.scale((int)200), this.myNameEditorField.getPreferredSize().height));
        this.myRootPanel.setMaximumSize(new Dimension(JBUI.scale((int)200), Short.MAX_VALUE));
    }

    private JTextField createNameEditorField() {
        JTextField nameEditorField = new JTextField();
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.revertSchemeName();
                EditableSchemesCombo.this.cancelEdit();
            }
        }, ESC_KEY_STROKE, 0);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        }, ENTER_KEY_STROKE, 0);
        nameEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        });
        nameEditorField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditableSchemesCombo.this.validateOnTyping();
            }
        });
        return nameEditorField;
    }

    private void validateOnTyping() {
        String validationMessage;
        if (this.myNameEditData == null) {
            return;
        }
        String currName = this.myNameEditorField.getText();
        if (!currName.equals(this.myNameEditData.initialName) && (validationMessage = this.validateSchemeName(currName, this.myNameEditData.isProjectScheme)) != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            return;
        }
        this.showHint();
    }

    private void showHint() {
        this.mySchemesPanel.showInfo(EDITING_HINT, MessageType.INFO);
    }

    private void revertSchemeName() {
        if (this.myNameEditData != null) {
            this.myNameEditorField.setText(this.myNameEditData.initialName);
        }
    }

    public void updateSelected() {
        this.myComboBox.repaint();
    }

    private void stopEdit() {
        if (this.myNameEditData == null) {
            this.cancelEdit();
            return;
        }
        String newName = this.myNameEditorField.getText();
        String validationMessage = this.validateSchemeName(newName, this.myNameEditData.isProjectScheme);
        if (validationMessage != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
        } else {
            this.myNameEditData.nameConsumer.accept(newName);
            this.cancelEdit();
        }
    }

    public void cancelEdit() {
        this.mySchemesPanel.clearInfo();
        this.myLayout.first(this.myRootPanel);
        this.myNameEditData = null;
        IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
        focusManager.doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myRootPanel, true));
    }

    private void createCombo() {
        this.myComboBox = new SchemesCombo<T>(){

            @Override
            protected boolean supportsProjectSchemes() {
                return EditableSchemesCombo.this.mySchemesPanel.supportsProjectSchemes();
            }

            @Override
            protected boolean isProjectScheme(@NotNull T scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/schemes/EditableSchemesCombo$5", "isProjectScheme"));
                }
                return EditableSchemesCombo.this.mySchemesPanel.getModel().isProjectScheme(scheme2);
            }

            @Override
            protected int getIndent(@NotNull T scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/schemes/EditableSchemesCombo$5", "getIndent"));
                }
                return EditableSchemesCombo.this.mySchemesPanel.getIndent(scheme2);
            }

            @Override
            @NotNull
            protected SimpleTextAttributes getSchemeAttributes(T scheme2) {
                SimpleTextAttributes baseAttributes;
                SchemesModel model = EditableSchemesCombo.this.mySchemesPanel.getModel();
                SimpleTextAttributes simpleTextAttributes = baseAttributes = !EditableSchemesCombo.this.useBoldForNonRemovableSchemes() || model.canDeleteScheme(scheme2) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (EditableSchemesCombo.this.mySchemesPanel.highlightNonDefaultSchemes() && model.canResetScheme(scheme2) && model.differsFromDefault(scheme2)) {
                    SimpleTextAttributes simpleTextAttributes2 = baseAttributes.derive(-1, (Color)JBColor.BLUE, null, null);
                    if (simpleTextAttributes2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/EditableSchemesCombo$5", "getSchemeAttributes"));
                    }
                    return simpleTextAttributes2;
                }
                SimpleTextAttributes simpleTextAttributes3 = baseAttributes;
                if (simpleTextAttributes3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/EditableSchemesCombo$5", "getSchemeAttributes"));
                }
                return simpleTextAttributes3;
            }
        };
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.mySchemesPanel.getActions().onSchemeChanged(EditableSchemesCombo.this.getSelectedScheme());
            }
        });
    }

    public void startEdit(@NotNull String initialName, boolean isProjectScheme, @NotNull Consumer<String> nameConsumer) {
        if (initialName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialName", "com/intellij/application/options/schemes/EditableSchemesCombo", "startEdit"));
        }
        if (nameConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameConsumer", "com/intellij/application/options/schemes/EditableSchemesCombo", "startEdit"));
        }
        this.showHint();
        this.myNameEditData = new NameEditData(initialName, nameConsumer, isProjectScheme);
        this.myNameEditorField.setText(initialName);
        this.myLayout.last(this.myRootPanel);
        IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
        focusManager.doWhenFocusSettlesDown(() -> focusManager.requestFocus((Component)this.myNameEditorField, true));
    }

    public void resetSchemes(@NotNull Collection<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/EditableSchemesCombo", "resetSchemes"));
        }
        this.myComboBox.resetSchemes(schemes);
    }

    @Nullable
    public T getSelectedScheme() {
        return this.myComboBox.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme2) {
        this.myComboBox.selectScheme(scheme2);
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    private boolean useBoldForNonRemovableSchemes() {
        return this.mySchemesPanel.useBoldForNonRemovableSchemes();
    }

    @Nullable
    private String validateSchemeName(@NotNull String name2, boolean isProjectScheme) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/schemes/EditableSchemesCombo", "validateSchemeName"));
        }
        if (this.myNameEditData != null && name2.equals(this.myNameEditData.initialName)) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            return EMPTY_NAME_MESSAGE;
        }
        if (this.mySchemesPanel.getModel().containsScheme(name2, isProjectScheme)) {
            return NAME_ALREADY_EXISTS_MESSAGE;
        }
        return null;
    }

    private static class NameEditData {
        @NotNull
        private String initialName;
        @NotNull
        private Consumer<String> nameConsumer;
        private boolean isProjectScheme;

        private NameEditData(@NotNull String name2, @NotNull Consumer<String> nameConsumer, boolean isProjectScheme) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/schemes/EditableSchemesCombo$NameEditData", "<init>"));
            }
            if (nameConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameConsumer", "com/intellij/application/options/schemes/EditableSchemesCombo$NameEditData", "<init>"));
            }
            this.initialName = name2;
            this.nameConsumer = nameConsumer;
            this.isProjectScheme = isProjectScheme;
        }
    }
}

