/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.util.containers.IntArrayList;

public class LineWrapper {
    public static IntArrayList calcBreakOffsets(char[] text2, int startOffset, int endOffset, boolean lineStart, double x, double clipX, WidthProvider widthProvider) {
        IntArrayList breakOffsets = new IntArrayList();
        int nextOffset = startOffset;
        while (true) {
            int prevOffset = nextOffset;
            if ((nextOffset = LineWrapper.calcWordBreakOffset(text2, nextOffset, endOffset, x, clipX, widthProvider)) == prevOffset && lineStart && (nextOffset = LineWrapper.calcCharBreakOffset(text2, nextOffset, endOffset, x, clipX, widthProvider)) == prevOffset) {
                ++nextOffset;
            }
            if (nextOffset >= endOffset) break;
            breakOffsets.add(nextOffset);
            lineStart = true;
            x = 0.0;
        }
        return breakOffsets;
    }

    private static int calcCharBreakOffset(char[] text2, int offset, int endOffset, double x, double clipX, WidthProvider widthProvider) {
        double newX = x;
        int breakOffset = offset;
        while (breakOffset < endOffset) {
            int nextOffset = breakOffset + 1;
            if ((newX += widthProvider.getWidth(text2, breakOffset, nextOffset - breakOffset, newX)) > clipX) {
                return breakOffset;
            }
            breakOffset = nextOffset;
        }
        return breakOffset;
    }

    private static int calcWordBreakOffset(char[] text2, int offset, int endOffset, double x, double clipX, WidthProvider widthProvider) {
        double newX = x;
        int breakOffset = offset;
        while (breakOffset < endOffset) {
            int nextOffset = LineWrapper.getNextWordBreak(text2, breakOffset, endOffset);
            if ((newX += widthProvider.getWidth(text2, breakOffset, nextOffset - breakOffset, newX)) > clipX) {
                return breakOffset;
            }
            breakOffset = nextOffset;
        }
        return breakOffset;
    }

    private static int getNextWordBreak(char[] text2, int offset, int endOffset) {
        boolean isId = Character.isJavaIdentifierPart(text2[offset]);
        for (int i2 = offset + 1; i2 < endOffset; ++i2) {
            if (isId == Character.isJavaIdentifierPart(text2[i2])) continue;
            return i2;
        }
        return endOffset;
    }

    static interface WidthProvider {
        public double getWidth(char[] var1, int var2, int var3, double var4);
    }
}

