/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeInfoImpl
implements ExpectedTypeInfo {
    public static final NullableComputable<String> NULL = () -> null;
    @NotNull
    private final PsiType type;
    @NotNull
    private final PsiType defaultType;
    private final int kind;
    @NotNull
    private final TailType myTailType;
    private final PsiMethod myCalledMethod;
    @NotNull
    private final NullableComputable<String> expectedNameComputable;
    @NotNull
    private final NullableLazyValue<String> expectedNameLazyValue;

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public TailType getTailType() {
        TailType tailType = this.myTailType;
        if (tailType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "getTailType"));
        }
        return tailType;
    }

    public ExpectedTypeInfoImpl(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, @NotNull PsiType defaultType, @NotNull TailType myTailType, PsiMethod calledMethod, @NotNull NullableComputable<String> expectedName) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "<init>"));
        }
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultType", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "<init>"));
        }
        if (myTailType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myTailType", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "<init>"));
        }
        if (expectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "<init>"));
        }
        this.type = type2;
        this.kind = kind2;
        this.myTailType = myTailType;
        this.defaultType = defaultType;
        this.myCalledMethod = calledMethod;
        this.expectedNameComputable = expectedName;
        this.expectedNameLazyValue = new VolatileNullableLazyValue<String>(){

            @Nullable
            protected String compute() {
                return (String)ExpectedTypeInfoImpl.this.expectedNameComputable.compute();
            }
        };
        PsiUtil.ensureValidType((PsiType)type2);
        PsiUtil.ensureValidType((PsiType)defaultType);
    }

    @Nullable
    public String getExpectedName() {
        return (String)this.expectedNameLazyValue.getValue();
    }

    @Override
    public PsiMethod getCalledMethod() {
        return this.myCalledMethod;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "getType"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        PsiType psiType = this.defaultType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "getDefaultType"));
        }
        return psiType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpectedTypeInfoImpl)) {
            return false;
        }
        ExpectedTypeInfoImpl that = (ExpectedTypeInfoImpl)o;
        if (this.kind != that.kind) {
            return false;
        }
        if (!this.defaultType.equals(that.defaultType)) {
            return false;
        }
        if (!this.myTailType.equals(that.myTailType)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.defaultType.hashCode();
        result2 = 31 * result2 + this.kind;
        result2 = 31 * result2 + this.myTailType.hashCode();
        return result2;
    }

    @Override
    public boolean equals(ExpectedTypeInfo obj) {
        return this.equals((Object)obj);
    }

    @Override
    public String toString() {
        return "ExpectedTypeInfo[type='" + this.type + "' kind='" + this.kind + "']";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ExpectedTypeInfo[] intersect(@NotNull ExpectedTypeInfo info) {
        block35: {
            ExpectedTypeInfoImpl info1;
            block36: {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                }
                info1 = (ExpectedTypeInfoImpl)info;
                if (this.kind == 0) {
                    if (info1.kind == 0) {
                        if (info1.type.equals(this.type)) {
                            ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{this};
                            if (expectedTypeInfoArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                            }
                            return expectedTypeInfoArray;
                        }
                        break block35;
                    } else {
                        ExpectedTypeInfo[] expectedTypeInfoArray = info1.intersect(this);
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                }
                if (this.kind != 1) break block36;
                if (info1.kind == 0) {
                    if (this.type.isAssignableFrom(info1.type)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{info1};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                    break block35;
                } else if (info1.kind == 1) {
                    PsiType otherType = info1.type;
                    if (this.type.isAssignableFrom(otherType)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{info1};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                    if (otherType.isAssignableFrom(this.type)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{this};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                    break block35;
                } else {
                    ExpectedTypeInfo[] expectedTypeInfoArray = info1.intersect(this);
                    if (expectedTypeInfoArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                    }
                    return expectedTypeInfoArray;
                }
            }
            if (this.kind == 2) {
                if (info1.kind == 0) {
                    if (info1.type.isAssignableFrom(this.type)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{info1};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                } else if (info1.kind == 1) {
                    PsiType otherType = info1.type;
                    if (otherType.isAssignableFrom(this.type)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{this};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                } else if (info1.kind == 2) {
                    PsiType otherType = info1.type;
                    if (this.type.isAssignableFrom(otherType)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{this};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                    if (otherType.isAssignableFrom(this.type)) {
                        ExpectedTypeInfo[] expectedTypeInfoArray = new ExpectedTypeInfoImpl[]{info1};
                        if (expectedTypeInfoArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                        }
                        return expectedTypeInfoArray;
                    }
                } else {
                    ExpectedTypeInfo[] expectedTypeInfoArray = info1.intersect(this);
                    if (expectedTypeInfoArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
                    }
                    return expectedTypeInfoArray;
                }
            }
        }
        if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeInfoImpl", "intersect"));
        }
        return ExpectedTypeInfo.EMPTY_ARRAY;
    }
}

