/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element instanceof PsiModifierListOwner) {
            Project project2 = element.getProject();
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
            final ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
            PsiAnnotation[] annotations2 = externalAnnotationsManager.findExternalAnnotations(modifierListOwner);
            if (annotations2 != null) {
                final String oldExternalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)modifierListOwner, (boolean)false, (int)Integer.MAX_VALUE);
                if (oldExternalName == null) {
                    return null;
                }
                return new RefactoringElementListener(){

                    private void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/codeInsight/ExternalAnnotationsRefactoringListenerProvider$1", "elementRenamedOrMoved"));
                        }
                        if (newElement instanceof PsiModifierListOwner) {
                            externalAnnotationsManager.elementRenamedOrMoved((PsiModifierListOwner)newElement, oldExternalName);
                        }
                    }

                    public void elementMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/codeInsight/ExternalAnnotationsRefactoringListenerProvider$1", "elementMoved"));
                        }
                        this.elementRenamedOrMoved(newElement);
                    }

                    public void elementRenamed(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/codeInsight/ExternalAnnotationsRefactoringListenerProvider$1", "elementRenamed"));
                        }
                        this.elementRenamedOrMoved(newElement);
                    }
                };
            }
        }
        return null;
    }
}

