/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.java15api.Java15APIUsageInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceSuggester {
    public static final String[] FUNCTIONAL_INTERFACES = new String[]{"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.Comparator", "com.intellij.util.Function", "com.intellij.util.Consumer", "com.intellij.openapi.util.Computable", "com.intellij.openapi.util.Condition", "com.intellij.util.Processor", "com.intellij.util.Producer", "com.google.common.base.Function", "com.google.common.base.Predicate", "com.google.common.base.Supplier", "org.apache.commons.collections.Closure", "org.apache.commons.collections.Factory", "org.apache.commons.collections.Predicate", "org.apache.commons.collections.Transformer", "gnu.trove.TObjectFunction", "gnu.trove.TObjectProcedure", "gnu.trove.TObjectObjectProcedure"};

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiFunctionalExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "suggestFunctionalInterfaces"));
        }
        PsiType qualifierType = expression2 instanceof PsiMethodReferenceExpression ? PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression2)) : null;
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(expression2, (NullableFunction<PsiClass, PsiType>)((NullableFunction)aClass -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "lambda$suggestFunctionalInterfaces$0"));
            }
            return FunctionalInterfaceSuggester.composeAcceptableType(aClass, expression2, qualifierType);
        }));
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "suggestFunctionalInterfaces"));
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, false);
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method, boolean suggestUnhandledThrowables) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "suggestFunctionalInterfaces"));
        }
        if (method.isConstructor()) {
            return Collections.emptyList();
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, (NullableFunction<PsiClass, PsiType>)((NullableFunction)aClass -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "lambda$suggestFunctionalInterfaces$1"));
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
            if (interfaceMethod != null) {
                PsiClassType[] thrownTypes;
                PsiParameter[] interfaceMethodParameters;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length != (interfaceMethodParameters = interfaceMethod.getParameterList().getParameters()).length) {
                    return null;
                }
                PsiType[] left = new PsiType[parameters2.length + 1];
                PsiType[] right = new PsiType[parameters2.length + 1];
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    left[i2] = interfaceMethodParameters[i2].getType();
                    right[i2] = parameters2[i2].getType();
                }
                left[parameters2.length] = method.getReturnType();
                right[parameters2.length] = interfaceMethod.getReturnType();
                PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
                PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)aClass.getProject()).inferTypeArguments(typeParameters, left, right, PsiUtil.getLanguageLevel((PsiElement)method));
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
                    return null;
                }
                for (int i3 = 0; i3 < interfaceMethodParameters.length; ++i3) {
                    PsiType paramType = parameters2[i3].getType();
                    PsiType interfaceParamType = substitutor.substitute(interfaceMethodParameters[i3].getType());
                    if (!(interfaceParamType instanceof PsiPrimitiveType) ? TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)interfaceParamType) : paramType.equals(interfaceParamType)) continue;
                    return null;
                }
                PsiType returnType = method.getReturnType();
                PsiType interfaceMethodReturnType = substitutor.substitute(interfaceMethod.getReturnType());
                if (returnType != null && !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)interfaceMethodReturnType)) {
                    return null;
                }
                if (interfaceMethodReturnType instanceof PsiPrimitiveType && !interfaceMethodReturnType.equals(returnType)) {
                    return null;
                }
                PsiClassType[] interfaceThrownTypes = interfaceMethod.getThrowsList().getReferencedTypes();
                for (PsiClassType thrownType : thrownTypes = method.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isHandledBy(thrownType, interfaceThrownTypes, substitutor)) continue;
                    return null;
                }
                if (!suggestUnhandledThrowables) {
                    for (PsiClassType thrownType : interfaceThrownTypes) {
                        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{PsiCodeBlock.class});
                        PsiType substitutedThrowable = substitutor.substitute((PsiType)thrownType);
                        if (codeBlock != null && substitutedThrowable instanceof PsiClassType && ExceptionUtil.isHandled((PsiClassType)substitutedThrowable, (PsiElement)codeBlock)) continue;
                        return null;
                    }
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                return elementFactory.createType(aClass, substitutor);
            }
            return null;
        }));
    }

    private static <T extends PsiElement> Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull T element, NullableFunction<PsiClass, PsiType> acceptanceChecker) {
        GlobalSearchScope allScope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "suggestFunctionalInterfaces"));
        }
        Project project2 = element.getProject();
        HashSet types = new HashSet();
        Processor consumer = member -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "lambda$suggestFunctionalInterfaces$2"));
            }
            if (member instanceof PsiClass && Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel(member, PsiUtil.getLanguageLevel((PsiElement)element)) == null) {
                if (!JavaPsiFacade.getInstance((Project)project2).getResolveHelper().isAccessible(member, element, null)) {
                    return true;
                }
                ContainerUtil.addIfNotNull((Collection)types, (Object)acceptanceChecker.fun((Object)((PsiClass)member)));
            }
            return true;
        };
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass functionalInterfaceClass = psiFacade.findClass("java.lang.FunctionalInterface", allScope = GlobalSearchScope.allScope((Project)project2));
        if (functionalInterfaceClass != null) {
            AnnotatedMembersSearch.search((PsiClass)functionalInterfaceClass, (SearchScope)element.getResolveScope()).forEach(consumer);
        }
        for (String functionalInterface : FUNCTIONAL_INTERFACES) {
            PsiClass aClass = psiFacade.findClass(functionalInterface, element.getResolveScope());
            if (aClass == null) continue;
            consumer.process((Object)aClass);
        }
        ArrayList typesToSuggest = new ArrayList(types);
        Collections.sort(typesToSuggest, Comparator.comparing(PsiType::getCanonicalText));
        return typesToSuggest;
    }

    private static PsiType composeAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression2, PsiType qualifierType) {
        if (interface2Consider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interface2Consider", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "composeAcceptableType"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "composeAcceptableType"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)interface2Consider.getProject());
        PsiClassType type2 = elementFactory.createType(interface2Consider, PsiSubstitutor.EMPTY);
        if (expression2.isAcceptable((PsiType)type2)) {
            return type2;
        }
        return FunctionalInterfaceSuggester.composeAcceptableType(interface2Consider, expression2, qualifierType, elementFactory);
    }

    private static PsiType composeAcceptableType(PsiClass interface2Consider, PsiFunctionalExpression expression2, PsiType qualifierType, PsiElementFactory elementFactory) {
        PsiMethod interfaceMethod;
        if (interface2Consider.hasTypeParameters() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)interface2Consider)) != null) {
            PsiParameter[] functionalExprParameters;
            PsiType[] right;
            PsiType[] left;
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            int offset = 0;
            if (expression2 instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression2).hasFormalParameterTypes()) {
                left = new PsiType[parameters2.length];
                right = new PsiType[parameters2.length];
                functionalExprParameters = ((PsiLambdaExpression)expression2).getParameterList().getParameters();
                if (parameters2.length != functionalExprParameters.length) {
                    return null;
                }
            } else if (expression2 instanceof PsiMethodReferenceExpression) {
                left = new PsiType[parameters2.length + 1];
                right = new PsiType[parameters2.length + 1];
                PsiMethod method = FunctionalInterfaceSuggester.getTargetMethod((PsiMethodReferenceExpression)expression2, qualifierType, parameters2, left, right);
                if (method == null) {
                    return null;
                }
                functionalExprParameters = method.getParameterList().getParameters();
                if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression2)) && !method.hasModifierProperty("static")) {
                    offset = 1;
                }
                left[parameters2.length] = method.getReturnType();
                right[parameters2.length] = interfaceMethod.getReturnType();
            } else {
                return null;
            }
            for (int i2 = 0; i2 < functionalExprParameters.length; ++i2) {
                left[i2 + offset] = parameters2[i2 + offset].getType();
                right[i2 + offset] = functionalExprParameters[i2].getType();
            }
            PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)interface2Consider.getProject()).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression2));
            PsiClassType type2 = elementFactory.createType(interface2Consider, substitutor);
            if (expression2.isAcceptable((PsiType)type2)) {
                return type2;
            }
        }
        return null;
    }

    @Nullable
    private static PsiMethod getTargetMethod(PsiMethodReferenceExpression expression2, PsiType qualifierType, PsiParameter[] parameters2, PsiType[] left, PsiType[] right) {
        JavaResolveResult[] results;
        boolean staticallyReferenced = PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2);
        for (JavaResolveResult result2 : results = expression2.multiResolve(true)) {
            PsiElement element = result2.getElement();
            if (!(element instanceof PsiMethod)) continue;
            int offset = staticallyReferenced && !((PsiMethod)element).hasModifierProperty("static") ? 1 : 0;
            PsiParameter[] functionalExprParameters = ((PsiMethod)element).getParameterList().getParameters();
            if (functionalExprParameters.length + offset != parameters2.length) continue;
            if (offset > 0) {
                if (qualifierType == null) continue;
                left[0] = parameters2[0].getType();
                right[0] = qualifierType;
            }
            return (PsiMethod)element;
        }
        return null;
    }
}

