/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.MakeExternalAnnotationExplicit;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeAnnotationExternal
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Annotate Externally" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MakeAnnotationExternal", "getFamilyName"));
        }
        return "Annotate Externally";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiModifierListOwner modifierListOwner;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/MakeAnnotationExternal", "isAvailable"));
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiAnnotation.class);
        if (annotation != null && annotation.getQualifiedName() != null && annotation.getManager().isInProject((PsiElement)annotation) && (modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)modifierListOwner);
            if (CodeStyleSettingsManager.getSettings((Project)project2).USE_EXTERNAL_ANNOTATIONS || virtualFile != null && ExternalAnnotationsManager.getInstance((Project)project2).hasAnnotationRootsForFile(virtualFile)) {
                this.setText("Annotate externally");
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/MakeAnnotationExternal", "invoke"));
        }
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiAnnotation.class);
        assert (annotation != null);
        PsiModifierListOwner owner2 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        assert (owner2 != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file2, owner2, externalAnnotationsManager))) {
            return;
        }
        String qualifiedName = annotation.getQualifiedName();
        assert (qualifiedName != null);
        externalAnnotationsManager.annotateExternally(owner2, qualifiedName, file2, annotation.getParameterList().getAttributes());
        WriteAction.run(() -> annotation.delete());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

