/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.DirectoryFormattingOptions;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutDirectoryDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.ReformatFilesDialog;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeAction");
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";
    protected static ReformatFilesOptions myTestOptions;

    public ReformatCodeAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file2 = null;
        PsiDirectory dir = null;
        boolean hasSelection = false;
        if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            dir = file2.getContainingDirectory();
            hasSelection = editor.getSelectionModel().hasSelection();
        } else {
            if (ReformatCodeAction.containsAtLeastOneFile(files)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(files);
                if (!operationStatus.hasReadonlyFiles()) {
                    ReformatFilesOptions selectedFlags = ReformatCodeAction.getReformatFilesOptions(project2, files);
                    if (selectedFlags == null) {
                        return;
                    }
                    boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
                    boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project2).isDumb();
                    AbstractLayoutCodeProcessor processor2 = new ReformatCodeProcessor(project2, ReformatCodeAction.convertToPsiFiles(files, project2), null, processOnlyChangedText);
                    if (shouldOptimizeImports) {
                        processor2 = new OptimizeImportsProcessor(processor2);
                    }
                    if (selectedFlags.isRearrangeCode()) {
                        processor2 = new RearrangeCodeProcessor(processor2);
                    }
                    processor2.run();
                }
                return;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) != null || LangDataKeys.MODULE_CONTEXT.getData(dataContext) != null) {
                Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
                ReformatFilesOptions selectedFlags = ReformatCodeAction.getLayoutProjectOptions(project2, moduleContext);
                if (selectedFlags != null) {
                    ReformatCodeAction.reformatModule(project2, moduleContext, selectedFlags);
                }
                return;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ((PsiDirectoryContainer)element).getDirectories()[0];
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file2 = element.getContainingFile();
                if (file2 == null) {
                    return;
                }
                dir = file2.getContainingDirectory();
            }
        }
        if (file2 == null && dir != null) {
            DirectoryFormattingOptions options = ReformatCodeAction.getDirectoryFormattingOptions(project2, dir);
            if (options != null) {
                ReformatCodeAction.reformatDirectory(project2, dir, options);
            }
            return;
        }
        if (file2 == null || editor == null) {
            return;
        }
        LastRunReformatCodeOptionsProvider provider = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        ReformatCodeRunOptions currentRunOptions = provider.getLastRunOptions(file2);
        TextRangeType processingScope = currentRunOptions.getTextRangeType();
        if (hasSelection) {
            processingScope = TextRangeType.SELECTED_TEXT;
        } else if (processingScope == TextRangeType.VCS_CHANGED_TEXT) {
            if (FormatChangedTextUtil.getInstance().isChangeNotTrackedForFile(project2, file2)) {
                processingScope = TextRangeType.WHOLE_FILE;
            }
        } else {
            processingScope = TextRangeType.WHOLE_FILE;
        }
        currentRunOptions.setProcessingScope(processingScope);
        new FileInEditorProcessor(file2, editor, currentRunOptions).processCode();
    }

    @Nullable
    private static DirectoryFormattingOptions getDirectoryFormattingOptions(@NotNull Project project2, @NotNull PsiDirectory dir) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatCodeAction", "getDirectoryFormattingOptions"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/codeInsight/actions/ReformatCodeAction", "getDirectoryFormattingOptions"));
        }
        LayoutDirectoryDialog dialog2 = new LayoutDirectoryDialog(project2, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{dir.getVirtualFile().getPath()}), FormatChangedTextUtil.hasChanges(dir));
        boolean enableIncludeDirectoriesCb = dir.getSubdirectories().length > 0;
        dialog2.setEnabledIncludeSubdirsCb(enableIncludeDirectoriesCb);
        dialog2.setSelectedIncludeSubdirsCb(enableIncludeDirectoriesCb);
        if (dialog2.showAndGet()) {
            return dialog2;
        }
        return null;
    }

    private static void reformatDirectory(@NotNull Project project2, @NotNull PsiDirectory dir, @NotNull DirectoryFormattingOptions options) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        AbstractLayoutCodeProcessor processor2 = new ReformatCodeProcessor(project2, dir, options.isIncludeSubdirectories(), options.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        ReformatCodeAction.registerScopeFilter(processor2, options.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor2, options.getFileTypeMask());
        if (options.isOptimizeImports()) {
            processor2 = new OptimizeImportsProcessor(processor2);
        }
        if (options.isRearrangeCode()) {
            processor2 = new RearrangeCodeProcessor(processor2);
        }
        processor2.run();
    }

    private static void reformatModule(@NotNull Project project2, @Nullable Module moduleContext, @NotNull ReformatFilesOptions selectedFlags) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatModule"));
        }
        if (selectedFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFlags", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatModule"));
        }
        boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project2).isDumb();
        boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
        AbstractLayoutCodeProcessor processor2 = moduleContext != null ? new ReformatCodeProcessor(project2, moduleContext, processOnlyChangedText) : new ReformatCodeProcessor(project2, processOnlyChangedText);
        ReformatCodeAction.registerScopeFilter(processor2, selectedFlags.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor2, selectedFlags.getFileTypeMask());
        if (shouldOptimizeImports) {
            processor2 = new OptimizeImportsProcessor(processor2);
        }
        if (selectedFlags.isRearrangeCode()) {
            processor2 = new RearrangeCodeProcessor(processor2);
        }
        processor2.run();
    }

    public static void registerScopeFilter(@NotNull AbstractLayoutCodeProcessor processor2, @Nullable SearchScope scope) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/actions/ReformatCodeAction", "registerScopeFilter"));
        }
        if (scope == null) {
            return;
        }
        processor2.addFileFilter(arg_0 -> ((SearchScope)scope).contains(arg_0));
    }

    public static void registerFileMaskFilter(@NotNull AbstractLayoutCodeProcessor processor2, @Nullable String fileTypeMask) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/actions/ReformatCodeAction", "registerFileMaskFilter"));
        }
        if (fileTypeMask == null) {
            return;
        }
        final Condition<CharSequence> patternCondition = ReformatCodeAction.getFileTypeMaskPattern(fileTypeMask);
        processor2.addFileFilter(new VirtualFileFilter(){

            public boolean accept(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeAction$1", "accept"));
                }
                return patternCondition.value((Object)file2.getNameSequence());
            }
        });
    }

    private static Condition<CharSequence> getFileTypeMaskPattern(@Nullable String mask) {
        try {
            return FindInProjectUtil.createFileMaskCondition(mask);
        }
        catch (PatternSyntaxException e) {
            LOG.info("Error while processing file mask: ", (Throwable)e);
            return Conditions.alwaysTrue();
        }
    }

    public static PsiFile[] convertToPsiFiles(VirtualFile[] files, Project project2) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        List list2 = PsiUtilCore.toPsiFiles((PsiManager)psiManager, Arrays.asList(files));
        return PsiUtilCore.toPsiFileArray((Collection)list2);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 == null || file2.getVirtualFile() == null) {
                presentation.setEnabled(false);
                return;
            }
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
                presentation.setEnabled(true);
                return;
            }
        } else if (files != null && ReformatCodeAction.containsAtLeastOneFile(files)) {
            boolean anyFormatters = false;
            for (VirtualFile virtualFile : files) {
                if (virtualFile.isDirectory()) {
                    presentation.setEnabled(false);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (psiFile == null) {
                    presentation.setEnabled(false);
                    return;
                }
                FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                if (builder == null) continue;
                anyFormatters = true;
            }
            if (!anyFormatters) {
                presentation.setEnabled(false);
                return;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file3;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                presentation.setEnabled(false);
                return;
            }
            if (!(element instanceof PsiDirectory || (file3 = element.getContainingFile()) != null && LanguageFormatting.INSTANCE.forContext((PsiElement)file3) != null)) {
                presentation.setEnabled(false);
                return;
            }
        }
        presentation.setEnabled(true);
    }

    @Nullable
    private static ReformatFilesOptions getReformatFilesOptions(@NotNull Project project2, @NotNull VirtualFile[] files) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatCodeAction", "getReformatFilesOptions"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/ReformatCodeAction", "getReformatFilesOptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        ReformatFilesDialog dialog2 = new ReformatFilesDialog(project2, files);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2;
    }

    @Nullable
    private static ReformatFilesOptions getLayoutProjectOptions(@NotNull Project project2, @Nullable Module module2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatCodeAction", "getLayoutProjectOptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        String text2 = module2 != null ? CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{module2.getModuleFilePath()}) : CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{project2.getPresentableUrl()});
        boolean enableOnlyVCSChangedRegions = module2 != null ? FormatChangedTextUtil.hasChanges(module2) : FormatChangedTextUtil.hasChanges(project2);
        LayoutProjectCodeDialog dialog2 = new LayoutProjectCodeDialog(project2, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), text2, enableOnlyVCSChangedRegions);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2;
    }

    public static void setTestOptions(ReformatFilesOptions options) {
        myTestOptions = options;
    }

    public static boolean containsAtLeastOneFile(VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        if (files.length < 1) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            if (!virtualFile.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

