/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCompletionHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CodeCompletionHandlerBase");
    private static final Key<Boolean> CARET_PROCESSED = Key.create((String)"CodeCompletionHandlerBase.caretProcessed");
    @NotNull
    private final CompletionType myCompletionType;
    final boolean invokedExplicitly;
    final boolean synchronous;
    final boolean autopopup;
    private static int ourAutoInsertItemTimeout = 2000;
    private static final Key<SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType) {
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "createHandler"));
        }
        return CodeCompletionHandlerBase.createHandler(completionType, true, false, true);
    }

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "createHandler"));
        }
        AnAction codeCompletionAction = ActionManager.getInstance().getAction("CodeCompletion");
        assert (codeCompletionAction instanceof BaseCodeCompletionAction);
        BaseCodeCompletionAction baseCodeCompletionAction = (BaseCodeCompletionAction)codeCompletionAction;
        return baseCodeCompletionAction.createHandler(completionType, invokedExplicitly, autopopup, synchronous);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType) {
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "<init>"));
        }
        this(completionType, true, false, true);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "<init>"));
        }
        this.myCompletionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
        if (invokedExplicitly) assert (synchronous);
        if (autopopup) assert (!invokedExplicitly);
    }

    public final void invokeCompletion(Project project2, Editor editor) {
        try {
            this.invokeCompletion(project2, editor, 1);
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project2).showDumbModeNotification("Code completion is not available here while indices are being built");
        }
    }

    public final void invokeCompletion(@NotNull Project project2, @NotNull Editor editor, int time) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        this.invokeCompletion(project2, editor, time, false, false);
    }

    public final void invokeCompletion(@NotNull Project project2, @NotNull Editor editor, int time, boolean hasModifiers, boolean restarted) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        CodeCompletionHandlerBase.clearCaretMarkers(editor);
        this.invokeCompletion(project2, editor, time, hasModifiers, restarted, editor.getCaretModel().getPrimaryCaret());
    }

    public final void invokeCompletion(@NotNull Project project2, @NotNull Editor editor, int time, boolean hasModifiers, boolean restarted, @NotNull Caret caret) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "invokeCompletion"));
        }
        CodeCompletionHandlerBase.markCaretAsProcessed(caret);
        if (this.invokedExplicitly) {
            StatisticsUpdate.applyLastCompletionStatisticsUpdate();
        }
        CodeCompletionHandlerBase.checkNoWriteAccess();
        CompletionAssertions.checkEditorValid(editor);
        int offset = editor.getCaretModel().getOffset();
        if (editor.isViewer() || editor.getDocument().getRangeGuard(offset, offset) != null) {
            editor.getDocument().fireReadOnlyModificationAttempt();
            EditorModificationUtil.checkModificationAllowed((Editor)editor);
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project2)) {
            return;
        }
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        boolean repeated = phase.indicator != null && phase.indicator.isRepeatedInvocation(this.myCompletionType, editor);
        int newTime = phase.newCompletionStarted(time, repeated);
        if (this.invokedExplicitly) {
            time = newTime;
        }
        int invocationCount = time;
        if (CompletionServiceImpl.isPhase(CompletionPhase.InsertedSingleItem.class)) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class);
        if (invocationCount > 1 && this.myCompletionType == CompletionType.BASIC) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
        }
        CompletionInitializationContext[] initializationContext = new CompletionInitializationContext[]{null};
        Runnable initCmd = () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$invokeCompletion$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$invokeCompletion$1"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$invokeCompletion$1"));
            }
            Runnable runnable2 = () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$null$0"));
                }
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$null$0"));
                }
                if (caret == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lambda$null$0"));
                }
                EditorUtil.fillVirtualSpaceUntilCaret(editor);
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                CompletionAssertions.checkEditorValid(editor);
                PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project2);
                assert (psiFile != null) : "no PSI file: " + FileDocumentManager.getInstance().getFile(editor.getDocument());
                psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
                CompletionAssertions.assertCommitSuccessful(editor, psiFile);
                initializationContext[0] = this.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret);
            };
            ApplicationManager.getApplication().runWriteAction(runnable2);
        };
        if (this.autopopup) {
            CommandProcessor.getInstance().runUndoTransparentAction(initCmd);
            CompletionAssertions.checkEditorValid(editor);
            if (!restarted && CodeCompletionHandlerBase.shouldSkipAutoPopup(editor, initializationContext[0].getFile())) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                return;
            }
        } else {
            CommandProcessor.getInstance().executeCommand(project2, initCmd, null, null);
        }
        this.insertDummyIdentifier(initializationContext[0], hasModifiers, invocationCount);
    }

    private CompletionInitializationContext runContributorsBeforeCompletion(Editor editor, PsiFile psiFile, int invocationCount, @NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "runContributorsBeforeCompletion"));
        }
        final Ref current = Ref.create(null);
        CompletionInitializationContext context = new CompletionInitializationContext(editor, caret, psiFile, this.myCompletionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                if (dummyIdentifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase$1", "setDummyIdentifier"));
                }
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + this.dummyIdentifierChanger);
                }
                this.dummyIdentifierChanger = (CompletionContributor)current.get();
            }
        };
        List contributors = CompletionContributor.forLanguage((Language)context.getPositionLanguage());
        Project project2 = psiFile.getProject();
        List filteredContributors = DumbService.getInstance((Project)project2).filterByDumbAwareness((Collection)contributors);
        for (CompletionContributor contributor : filteredContributors) {
            current.set((Object)contributor);
            contributor.beforeCompletion(context);
            CompletionAssertions.checkEditorValid(editor);
            assert (!PsiDocumentManager.getInstance((Project)project2).isUncommited(editor.getDocument())) : "Contributor " + contributor + " left the document uncommitted";
        }
        return context;
    }

    private static void checkNoWriteAccess() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Completion should not be invoked inside write action");
        }
    }

    private static boolean shouldSkipAutoPopup(Editor editor, PsiFile psiFile) {
        int offset = editor.getCaretModel().getOffset();
        int psiOffset = Math.max(0, offset - 1);
        PsiElement elementAt = InjectedLanguageUtil.findInjectedElementNoCommit(psiFile, psiOffset);
        if (elementAt == null) {
            elementAt = psiFile.findElementAt(psiOffset);
        }
        if (elementAt == null) {
            return true;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)elementAt);
        for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage((Language)language)) {
            ThreeState result2 = confidence.shouldSkipAutopopup(elementAt, psiFile, offset);
            if (result2 == ThreeState.UNSURE) continue;
            LOG.debug(confidence + " has returned shouldSkipAutopopup=" + result2);
            return result2 == ThreeState.YES;
        }
        return false;
    }

    @NotNull
    private LookupImpl obtainLookup(Editor editor, Project project2) {
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl existing = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (existing != null && existing.isCompletion()) {
            existing.markReused();
            if (!this.autopopup) {
                existing.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            }
            LookupImpl lookupImpl = existing;
            if (lookupImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "obtainLookup"));
            }
            return lookupImpl;
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        if (editor.isOneLineMode()) {
            lookup.setCancelOnClickOutside(true);
            lookup.setCancelOnOtherWindowOpen(true);
        }
        lookup.setFocusDegree(this.autopopup ? LookupImpl.FocusDegree.UNFOCUSED : LookupImpl.FocusDegree.FOCUSED);
        LookupImpl lookupImpl = lookup;
        if (lookupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "obtainLookup"));
        }
        return lookupImpl;
    }

    private void doComplete(CompletionInitializationContext initContext, boolean hasModifiers, int invocationCount, OffsetTranslator translator, OffsetsInFile hostOffsets, OffsetsInFile hostCopyOffsets) {
        Editor editor = initContext.getEditor();
        CompletionAssertions.checkEditorValid(editor);
        CompletionContext context = CodeCompletionHandlerBase.createCompletionContext(initContext.getFile(), hostCopyOffsets);
        LookupImpl lookup = this.obtainLookup(editor, initContext.getProject());
        CompletionParameters parameters2 = this.createCompletionParameters(invocationCount, context, editor);
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (phase instanceof CompletionPhase.CommittingDocuments) {
            if (phase.indicator != null) {
                phase.indicator.closeAndFinish(false);
            }
            ((CompletionPhase.CommittingDocuments)phase).replaced = true;
        } else {
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        }
        CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor, initContext.getCaret(), parameters2, this, initContext.getOffsetMap(), hostOffsets, hasModifiers, lookup);
        Disposer.register((Disposable)indicator, (Disposable)hostCopyOffsets.getOffsets());
        Disposer.register((Disposable)indicator, (Disposable)context.getOffsetMap());
        Disposer.register((Disposable)indicator, (Disposable)translator);
        CompletionServiceImpl.setCompletionPhase(this.synchronous ? new CompletionPhase.Synchronous(indicator) : new CompletionPhase.BgCalculation(indicator));
        indicator.startCompletion(initContext);
        if (!this.synchronous) {
            return;
        }
        if (indicator.blockingWaitForFinish(ourAutoInsertItemTimeout)) {
            try {
                indicator.getLookup().refreshUi(true, false);
            }
            catch (Exception e) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                LOG.error((Throwable)e);
                return;
            }
            this.completionFinished(indicator, hasModifiers);
            return;
        }
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
        indicator.showLookup();
    }

    private static void checkNotSync(CompletionProgressIndicator indicator, List<LookupElement> allItems) {
        if (CompletionServiceImpl.isPhase(CompletionPhase.Synchronous.class)) {
            LOG.error("sync phase survived: " + allItems + "; indicator=" + CompletionServiceImpl.getCompletionPhase().indicator + "; myIndicator=" + indicator);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
    }

    private CompletionParameters createCompletionParameters(int invocationCount, CompletionContext newContext, Editor editor) {
        int offset = newContext.getStartOffset();
        PsiFile fileCopy = newContext.file;
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CodeCompletionHandlerBase.findCompletionPositionLeaf(newContext, offset, fileCopy, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)newContext);
        return new CompletionParameters(insertedElement, originalFile, this.myCompletionType, offset, invocationCount, editor);
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(CompletionContext newContext, int offset, PsiFile fileCopy, PsiFile originalFile) {
        PsiElement insertedElement = newContext.file.findElementAt(offset);
        CompletionAssertions.assertCompletionPositionPsiConsistent(newContext, offset, fileCopy, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "findCompletionPositionLeaf"));
        }
        return psiElement;
    }

    private AutoCompletionDecision shouldAutoComplete(CompletionProgressIndicator indicator, List<LookupElement> items) {
        if (!this.invokedExplicitly) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        CompletionParameters parameters2 = indicator.getParameters();
        LookupElement item = items.get(0);
        if (items.size() == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
            if (!indicator.getLookup().itemMatcher(item).isStartMatch(item)) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters2.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(indicator.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.size() == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem((LookupElement)item);
        }
        AutoCompletionContext context = new AutoCompletionContext(parameters2, items.toArray(new LookupElement[items.size()]), indicator.getOffsetMap(), (Lookup)indicator.getLookup());
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters2)) {
            AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(context);
            if (decision == null) continue;
            return decision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element) {
        return element.getAutoCompletionPolicy();
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
        List<LookupElement> items = indicator.getLookup().getItems();
        if (items.isEmpty()) {
            LookupManager.getInstance(indicator.getProject()).hideActiveLookup();
            Caret nextCaret = CodeCompletionHandlerBase.getNextCaretToProcess(indicator.getEditor());
            if (nextCaret != null) {
                this.invokeCompletion(indicator.getProject(), indicator.getEditor(), indicator.getParameters().getInvocationCount(), hasModifiers, false, nextCaret);
            } else {
                indicator.handleEmptyLookup(true);
                CodeCompletionHandlerBase.checkNotSync(indicator, items);
            }
            return;
        }
        LOG.assertTrue(!indicator.isRunning(), (Object)"running");
        LOG.assertTrue(!indicator.isCanceled(), (Object)"canceled");
        try {
            AutoCompletionDecision decision = this.shouldAutoComplete(indicator, items);
            if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(indicator));
                indicator.getLookup().setCalculating(false);
                indicator.showLookup();
            } else if (decision instanceof AutoCompletionDecision.InsertItem) {
                Runnable restorePrefix = CodeCompletionHandlerBase.rememberDocumentState(indicator.getEditor());
                LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
                CommandProcessor.getInstance().executeCommand(indicator.getProject(), () -> {
                    indicator.setMergeCommand();
                    indicator.getLookup().finishLookup('\u0000', item);
                }, "Autocompletion", null);
                if (CompletionService.getCompletionService().getCurrentCompletion() == null && !CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class)) {
                    CompletionServiceImpl.setCompletionPhase(hasModifiers ? new CompletionPhase.InsertedSingleItem(indicator, restorePrefix) : CompletionPhase.NoCompletion);
                }
            } else if (decision == AutoCompletionDecision.CLOSE_LOOKUP) {
                LookupManager.getInstance(indicator.getProject()).hideActiveLookup();
            }
        }
        catch (Throwable e) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            LOG.error(e);
        }
        finally {
            CodeCompletionHandlerBase.checkNotSync(indicator, items);
        }
    }

    private void insertDummyIdentifier(CompletionInitializationContext initContext, boolean hasModifiers, int invocationCount) {
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(initContext.getEditor());
        OffsetsInFile topLevelOffsets = new OffsetsInFile(initContext.getFile(), initContext.getOffsetMap()).toTopLevelFile();
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CodeCompletionHandlerBase.createFileCopy(topLevelOffsets.getFile());
        Document copyDocument = hostCopy.getViewProvider().getDocument();
        assert (copyDocument != null) : "no document";
        OffsetsInFile copyOffsets = topLevelOffsets.toFileCopy(hostCopy);
        OffsetTranslator translator = new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument);
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        String dummyIdentifier = initContext.getDummyIdentifier();
        if (!StringUtil.isEmpty((String)dummyIdentifier)) {
            int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
            int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
            copyDocument.replaceString(startOffset, endOffset, (CharSequence)dummyIdentifier);
        }
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        Project project2 = initContext.getProject();
        if (!this.synchronous) {
            if (CompletionServiceImpl.isPhase(CompletionPhase.NoCompletion.getClass()) || !CompletionServiceImpl.assertPhase(CompletionPhase.CommittingDocuments.class)) {
                Disposer.dispose((Disposable)translator);
                return;
            }
            CompletionPhase.CommittingDocuments phase = (CompletionPhase.CommittingDocuments)CompletionServiceImpl.getCompletionPhase();
            AutoPopupController.runTransactionWithEverythingCommitted(project2, () -> {
                if (phase.checkExpired() || !initContext.getFile().isValid() || !hostCopy.isValid() || !CompletionAssertions.isEditorValid(initContext.getEditor())) {
                    Disposer.dispose((Disposable)translator);
                    return;
                }
                this.doComplete(initContext, hasModifiers, invocationCount, translator, topLevelOffsets, copyOffsets);
            });
        } else {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(copyDocument);
            this.doComplete(initContext, hasModifiers, invocationCount, translator, topLevelOffsets, copyOffsets);
        }
    }

    private static CompletionContext createCompletionContext(PsiFile originalFile, OffsetsInFile hostCopyOffsets) {
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile result2 = hostCopyOffsets;
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (injected instanceof PsiFileImpl) {
                ((PsiFileImpl)injected).setOriginalFile(originalFile);
            }
            DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                result2 = translatedOffsets;
            }
        }
        return new CompletionContext(result2.getFile(), result2.getOffsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
        Runnable runnable2;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "lookupItemSelected"));
        }
        if (indicator.isAutopopupCompletion()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.basic");
        }
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update2 = StatisticsUpdate.collectStatisticChanges(item);
            context = CodeCompletionHandlerBase.insertItemHonorBlockSelection(indicator, item, completionChar, items, update2);
            update2.trackStatistics(context);
            runnable2 = context == null ? null : context.getLaterRunnable();
        }
        catch (Throwable throwable) {
            CodeCompletionHandlerBase.afterItemInsertion(indicator, context == null ? null : context.getLaterRunnable());
            throw throwable;
        }
        CodeCompletionHandlerBase.afterItemInsertion(indicator, runnable2);
    }

    private static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(final CompletionProgressIndicator indicator, final LookupElement item, final char completionChar, final List<LookupElement> items, final StatisticsUpdate update2) {
        CompletionAssertions.WatchingInsertionContext context;
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = indicator.getOffsetMap().containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? indicator.getIdentifierEndOffset() : CompletionInitializationContext.calcDefaultIdentifierEnd((Editor)editor, (int)caretOffset);
        final int idEndOffsetDelta = idEndOffset - caretOffset;
        if (editor.getCaretModel().supportsMultipleCarets()) {
            final ArrayList contexts = new ArrayList();
            final Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
            final OffsetsInFile topLevelOffsets = indicator.getHostOffsets();
            hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    PsiDocumentManager.getInstance((Project)indicator.getProject()).commitDocument(hostEditor.getDocument());
                    OffsetsInFile targetOffsets = topLevelOffsets.toInjectedIfAny(caret.getOffset());
                    PsiFile targetFile = targetOffsets.getFile();
                    Editor targetEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, targetFile);
                    int targetCaretOffset = targetEditor.getCaretModel().getOffset();
                    int idEnd = targetCaretOffset + idEndOffsetDelta;
                    if (idEnd > targetEditor.getDocument().getTextLength()) {
                        idEnd = targetCaretOffset;
                    }
                    CompletionAssertions.WatchingInsertionContext currentContext = CodeCompletionHandlerBase.insertItem(indicator, item, completionChar, items, update2, targetEditor, targetFile, targetCaretOffset, idEnd, targetOffsets.getOffsets());
                    contexts.add(currentContext);
                }
            });
            context = (CompletionAssertions.WatchingInsertionContext)((Object)contexts.get(contexts.size() - 1));
            if (context.shouldAddCompletionChar() && context.getCompletionChar() != '\r') {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
                    EditorActionManager.getInstance().getTypedAction().getHandler().execute(editor, completionChar, dataContext);
                });
            }
            for (CompletionAssertions.WatchingInsertionContext insertionContext : contexts) {
                insertionContext.stopWatching();
            }
        } else {
            context = CodeCompletionHandlerBase.insertItem(indicator, item, completionChar, items, update2, editor, indicator.getParameters().getOriginalFile(), caretOffset, idEndOffset, indicator.getOffsetMap());
        }
        return context;
    }

    public static void afterItemInsertion(CompletionProgressIndicator indicator, Runnable laterRunnable) {
        if (laterRunnable != null) {
            ActionTracker tracker = new ActionTracker(indicator.getEditor(), indicator);
            Runnable wrapper = () -> {
                if (!indicator.getProject().isDisposed() && !tracker.hasAnythingHappened()) {
                    laterRunnable.run();
                }
                indicator.disposeIndicator();
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                wrapper.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)indicator, wrapper);
            }
        } else {
            indicator.disposeIndicator();
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItem(CompletionProgressIndicator indicator, LookupElement item, char completionChar, List<LookupElement> items, StatisticsUpdate update2, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        editor.getCaretModel().moveToOffset(caretOffset);
        int initialStartOffset = caretOffset - item.getLookupString().length();
        assert (initialStartOffset >= 0) : "negative startOffset: " + caretOffset + "; " + item.getLookupString();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, initialStartOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        CompletionAssertions.WatchingInsertionContext context = new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, items, editor);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (caretOffset < idEndOffset && completionChar == '\t') {
                editor.getDocument().deleteString(caretOffset, idEndOffset);
            }
            assert (context.getStartOffset() >= 0) : "stale startOffset: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + context.getFile();
            assert (context.getTailOffset() >= 0) : "stale tail: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + context.getFile();
            Project project2 = indicator.getProject();
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            item.handleInsert((InsertionContext)context);
            PostprocessReformattingAspect.getInstance(project2).doPostponedFormatting();
            if (context.shouldAddCompletionChar()) {
                CodeCompletionHandlerBase.addCompletionChar(project2, context, item, editor, indicator, completionChar);
            }
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                context.stopWatching();
            }
            EditorModificationUtil.scrollToCaret((Editor)editor);
        });
        update2.addSparedChars(indicator, item, context);
        return context;
    }

    private static void addCompletionChar(Project project2, CompletionAssertions.WatchingInsertionContext context, LookupElement item, Editor editor, CompletionProgressIndicator indicator, char completionChar) {
        if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            LOG.info("tailOffset<0 after inserting " + item + " of " + item.getClass() + "; invalidated at: " + context.invalidateTrace + "\n--------");
        } else {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (context.getCompletionChar() == '\r') {
            Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project2);
            if (language != null) {
                SmartEnterProcessor processor2;
                Iterator iterator = SmartEnterProcessors.INSTANCE.forKey((Object)language).iterator();
                while (iterator.hasNext() && !(processor2 = (SmartEnterProcessor)iterator.next()).processAfterCompletion(editor, indicator.getParameters().getOriginalFile())) {
                }
            }
        } else if (!editor.getCaretModel().supportsMultipleCarets()) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            EditorActionManager.getInstance().getTypedAction().getHandler().execute(editor, completionChar, dataContext);
        }
    }

    private static boolean isCopyUpToDate(Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (copyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyFile", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "isCopyUpToDate"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "isCopyUpToDate"));
        }
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current = PsiDocumentManager.getInstance((Project)copyFile.getProject()).getPsiFile(document);
        return current != null && current.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static PsiFile createFileCopy(PsiFile file2) {
        Pair cached;
        boolean mayCacheCopy;
        VirtualFile virtualFile = file2.getVirtualFile();
        boolean bl = mayCacheCopy = file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_COPY_KEY)))) != null && CodeCompletionHandlerBase.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file2)) {
            PsiFile copy = (PsiFile)cached.first;
            Document document = (Document)cached.second;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file2, copy);
            Document originalDocument = file2.getViewProvider().getDocument();
            assert (originalDocument != null);
            assert (originalDocument.getTextLength() == file2.getTextLength()) : originalDocument;
            document.replaceString(0, document.getTextLength(), originalDocument.getImmutableCharSequence());
            return copy;
        }
        PsiFile copy = (PsiFile)file2.copy();
        if (copy.isPhysical() || copy.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + file2.getLanguage() + "; file=" + file2 + " of " + file2.getClass());
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file2, copy);
        if (mayCacheCopy) {
            Document document = copy.getViewProvider().getDocument();
            assert (document != null);
            file2.putUserData(FILE_COPY_KEY, (Object)new SoftReference((Object)Pair.create((Object)copy, (Object)document)));
        }
        return copy;
    }

    private static boolean isAutocompleteOnInvocation(CompletionType type2) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (type2 == CompletionType.SMART) {
            return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }

    private static Runnable rememberDocumentState(Editor _editor) {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor(_editor);
        String documentText = editor.getDocument().getText();
        int caret = editor.getCaretModel().getOffset();
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        int vOffset = editor.getScrollingModel().getVerticalScrollOffset();
        int hOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        return () -> {
            DocumentEx document = (DocumentEx)editor.getDocument();
            document.replaceString(0, document.getTextLength(), documentText);
            editor.getCaretModel().moveToOffset(caret);
            editor.getSelectionModel().setSelection(selStart, selEnd);
            editor.getScrollingModel().scrollHorizontally(hOffset);
            editor.getScrollingModel().scrollVertically(vOffset);
        };
    }

    private static void clearCaretMarkers(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "clearCaretMarkers"));
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            caret.putUserData(CARET_PROCESSED, null);
        }
    }

    private static void markCaretAsProcessed(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "markCaretAsProcessed"));
        }
        caret.putUserData(CARET_PROCESSED, (Object)Boolean.TRUE);
    }

    private static Caret getNextCaretToProcess(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase", "getNextCaretToProcess"));
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.getUserData(CARET_PROCESSED) != null) continue;
            return caret;
        }
        return null;
    }

    public static void setAutoInsertTimeout(int timeout) {
        ourAutoInsertItemTimeout = timeout;
    }
}

