/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public class JavaCharFilter
extends CharFilter {
    private static boolean isWithinLiteral(Lookup lookup) {
        PsiElement psiElement = lookup.getPsiElement();
        return psiElement != null && psiElement.getParent() instanceof PsiLiteralExpression;
    }

    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        if (!lookup.getPsiFile().getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return null;
        }
        LookupElement item = lookup.getCurrentItem();
        if (item == null || !item.isValid()) {
            return null;
        }
        Object o = item.getObject();
        if (c == '!') {
            PsiType type2;
            if (o instanceof PsiVariable && PsiType.BOOLEAN.isAssignableFrom(((PsiVariable)o).getType())) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            if (o instanceof PsiMethod && (type2 = ((PsiMethod)o).getReturnType()) != null && PsiType.BOOLEAN.isAssignableFrom(type2)) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            if (o instanceof PsiKeyword && ((PsiKeyword)o).textMatches((CharSequence)"instanceof")) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            return null;
        }
        if (c == '.' && JavaCharFilter.isWithinLiteral(lookup)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        if (c == ':') {
            PsiStatement statement2;
            PsiFile file2 = lookup.getPsiFile();
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(lookup.getEditor().getDocument());
            PsiElement leaf = file2.findElementAt(lookup.getEditor().getCaretModel().getOffset() - 1);
            if (PsiUtil.getLanguageLevel((PsiElement)file2).isAtLeast(LanguageLevel.JDK_1_8) && ((statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiStatement.class)) == null || statement2.getTextRange().getStartOffset() != leaf.getTextRange().getStartOffset())) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiSwitchLabelStatement.class) != null || PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiConditionalExpression.class) != null) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            return CharFilter.Result.HIDE_LOOKUP;
        }
        if (c == '[' || c == ']' || c == ')' || c == '>') {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        if (c == '<' && o instanceof PsiClass) {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        if (c == '(') {
            if (o instanceof PsiClass) {
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"new"})).accepts((Object)lookup.getPsiElement())) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (o instanceof PsiType) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        if ((c == ',' || c == '=') && o instanceof PsiVariable) {
            int lookupStart = lookup.getLookupStart();
            String name2 = ((PsiVariable)o).getName();
            if (lookupStart >= 0 && name2 != null && name2.equals(lookup.itemPattern(item))) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        if (c == '#' && PsiTreeUtil.getParentOfType((PsiElement)lookup.getPsiElement(), PsiDocComment.class) != null && o instanceof PsiClass) {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        if (c == '(' && "return".equals(item.getLookupString())) {
            return CharFilter.Result.HIDE_LOOKUP;
        }
        return null;
    }
}

