/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CollectConversion;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.ExcludeFilter;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaModuleCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.LabelReferenceCompletion;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.MethodReturnTypeProvider;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.SameSignatureCallParametersProvider;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.classes.AssignableFromContextFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.getters.JavaMembersGetter;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionContributor");
    public static final ElementPattern<PsiElement> ANNOTATION_NAME = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).afterLeaf(new String[]{"@"});
    private static final PsiJavaElementPattern.Capture<PsiElement> UNEXPECTED_REFERENCE_AFTER_DOT = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement());
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotation.class));
    private static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_NAME = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)NAME_VALUE_PAIR), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withParent((ElementPattern)NAME_VALUE_PAIR))});
    private static final ElementPattern SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchStatement.class).with((PatternCondition)new PatternCondition<PsiSwitchStatement>("enumExpressionType"){

        public boolean accepts(@NotNull PsiSwitchStatement psiSwitchStatement, ProcessingContext context) {
            if (psiSwitchStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSwitchStatement", "com/intellij/codeInsight/completion/JavaCompletionContributor$1", "accepts"));
            }
            PsiExpression expression2 = psiSwitchStatement.getExpression();
            if (expression2 == null) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            return aClass != null && aClass.isEnum();
        }
    })));
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.INTEGER_LITERAL})));
    private static final ElementPattern<PsiElement> IMPORT_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiImportStatementBase.class));
    private static final ElementPattern<PsiElement> CATCH_OR_FINALLY = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class).afterLeaf(new String[]{"try"})));
    private static final ElementPattern<PsiElement> INSIDE_CONSTRUCTOR = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true));

    @Nullable
    public static ElementFilter getReferenceFilter(PsiElement position) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiExpressionList.class, PsiVariable.class, PsiAnnotation.class});
        if (containingClass != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "implements", ",", "&"})).accepts((Object)position)) {
            return new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new NotFilter(new AssignableFromContextFilter()));
        }
        if (ANNOTATION_NAME.accepts((Object)position)) {
            return new AnnotationTypeFilter();
        }
        if (((ElementPattern)JavaKeywordCompletion.DECLARATION_START.getValue()).accepts((Object)position) || JavaKeywordCompletion.isInsideParameterList(position) || JavaCompletionContributor.isInsideAnnotationName(position)) {
            return new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"instanceof"})).accepts((Object)position)) {
            return new ElementExtractorFilter(ElementClassFilter.CLASS);
        }
        if (JavaKeywordCompletion.VARIABLE_AFTER_FINAL.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (CATCH_OR_FINALLY.accepts((Object)position) || JavaKeywordCompletion.START_SWITCH.accepts((Object)position) || JavaKeywordCompletion.isInstanceofPlace(position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            return null;
        }
        if (JavaKeywordCompletion.START_FOR.accepts((Object)position)) {
            return new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.VARIABLE);
        }
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)position)) {
            return JavaCompletionContributor.createAnnotationFilter(position);
        }
        PsiVariable var = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)position, PsiVariable.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (var != null && PsiTreeUtil.isAncestor((PsiElement)var.getInitializer(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter(var);
        }
        if (SWITCH_LABEL.accepts((Object)position)) {
            return new ClassFilter(PsiField.class){

                @Override
                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiEnumConstant;
                }
            };
        }
        PsiForeachStatement loop = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiForeachStatement.class);
        if (loop != null && PsiTreeUtil.isAncestor((PsiElement)loop.getIteratedValue(), (PsiElement)position, (boolean)false)) {
            return new ExcludeFilter((PsiVariable)loop.getIterationParameter());
        }
        return TrueFilter.INSTANCE;
    }

    private static boolean isInsideAnnotationName(PsiElement position) {
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        return anno != null && PsiTreeUtil.isAncestor((PsiElement)anno.getNameReferenceElement(), (PsiElement)position, (boolean)true);
    }

    private static ElementFilter createAnnotationFilter(PsiElement position) {
        OrFilter orFilter = new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER, new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiNameValuePair())).accepts((Object)position)) {
            orFilter.addFilter(new ClassFilter(PsiAnnotationMethod.class){

                @Override
                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiAnnotationMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)element));
                }
            });
        }
        return orFilter;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        PsiReference reference;
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "fillCompletionVariants"));
        }
        if (_result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/codeInsight/completion/JavaCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)position) || UNEXPECTED_REFERENCE_AFTER_DOT.accepts((Object)position)) {
            _result.stopHere();
            return;
        }
        CompletionResultSet result2 = JavaCompletionSorting.addJavaSorting(parameters2, _result);
        JavaCompletionSession session2 = new JavaCompletionSession(result2);
        if (ANNOTATION_ATTRIBUTE_NAME.accepts((Object)position) && !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            JavaCompletionContributor.addExpectedTypeMembers(parameters2, (Consumer<LookupElement>)result2);
            JavaKeywordCompletion.addPrimitiveTypes((Consumer<LookupElement>)result2, position, session2);
            JavaCompletionContributor.completeAnnotationAttributeName(result2, position, parameters2);
            result2.stopHere();
            return;
        }
        PrefixMatcher matcher = result2.getPrefixMatcher();
        PsiElement parent = position.getParent();
        if (JavaModuleCompletion.isModuleFile(parameters2.getOriginalFile())) {
            JavaModuleCompletion.addVariants(position, result2);
            result2.stopHere();
            return;
        }
        if (JavaKeywordCompletion.addWildcardExtendsSuper(result2, position)) {
            return;
        }
        if (position instanceof PsiIdentifier) {
            JavaCompletionContributor.addIdentifierVariants(parameters2, position, result2, session2, matcher);
        }
        MultiMap<CompletionResultSet, LookupElement> referenceVariants = JavaCompletionContributor.addReferenceVariants(parameters2, result2, session2);
        Set usedWords = ContainerUtil.map2Set((Collection)referenceVariants.values(), LookupElement::getLookupString);
        for (Map.Entry entry : referenceVariants.entrySet()) {
            session2.registerBatchItems((CompletionResultSet)entry.getKey(), (Collection)entry.getValue());
        }
        session2.flushBatchItems();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiLiteralExpression.class)).accepts((Object)position) && ((reference = position.getContainingFile().findReferenceAt(parameters2.getOffset())) == null || reference.isSoft())) {
            WordCompletionContributor.addWordCompletionVariants(result2, parameters2, usedWords);
        }
        if (position instanceof PsiIdentifier) {
            JavaGenerateMemberCompletionContributor.fillCompletionVariants(parameters2, result2);
        }
        JavaCompletionContributor.addAllClasses(parameters2, result2, session2);
        if (position instanceof PsiIdentifier) {
            FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, false, true, result2.getPrefixMatcher(), (Consumer<LookupElement>)result2);
        }
        if (position instanceof PsiIdentifier && parent instanceof PsiReferenceExpression && !((PsiReferenceExpression)parent).isQualified() && parameters2.isExtendedCompletion() && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            new JavaStaticMemberProcessor(parameters2).processStaticMethodsGlobally(matcher, (Consumer<LookupElement>)result2);
        }
        result2.stopHere();
    }

    private static void addIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, CompletionResultSet result2, JavaCompletionSession session2, PrefixMatcher matcher) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "addIdentifierVariants"));
        }
        session2.registerBatchItems(result2, JavaCompletionContributor.getFastIdentifierVariants(parameters2, position, matcher, position.getParent(), session2));
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            session2.flushBatchItems();
            new JavaInheritorsGetter(ConstructorInsertHandler.BASIC_INSTANCE).generateVariants(parameters2, matcher, (Consumer<LookupElement>)((Consumer)session2::addClassItem));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session2, false, (Consumer<LookupElement>)result2);
    }

    private static void suggestSmartCast(CompletionParameters parameters2, JavaCompletionSession session2, boolean quick, Consumer<LookupElement> result2) {
        if (SmartCastProvider.shouldSuggestCast(parameters2)) {
            session2.flushBatchItems();
            SmartCastProvider.addCastVariants(parameters2, session2.getMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
                JavaCompletionContributor.registerClassFromTypeElement(element, session2);
                result2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0));
            }), quick);
        }
    }

    private static List<LookupElement> getFastIdentifierVariants(@NotNull CompletionParameters parameters2, PsiElement position, PrefixMatcher matcher, PsiElement parent, @NotNull JavaCompletionSession session2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "getFastIdentifierVariants"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/completion/JavaCompletionContributor", "getFastIdentifierVariants"));
        }
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        if (TypeArgumentCompletionProvider.IN_TYPE_ARGS.accepts((Object)position)) {
            new TypeArgumentCompletionProvider(false, session2).addTypeArgumentVariants(parameters2, (Consumer<LookupElement>)((Consumer)items::add), matcher);
        }
        FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, false, false, matcher, (Consumer<LookupElement>)((Consumer)items::add));
        if (MethodReturnTypeProvider.IN_METHOD_RETURN_TYPE.accepts((Object)position)) {
            MethodReturnTypeProvider.addProbableReturnTypes(parameters2, (Consumer<LookupElement>)((Consumer)element -> {
                if (session2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/completion/JavaCompletionContributor", "lambda$getFastIdentifierVariants$1"));
                }
                JavaCompletionContributor.registerClassFromTypeElement(element, session2);
                items.add((LookupElement)element);
            }));
        }
        JavaCompletionContributor.suggestSmartCast(parameters2, session2, true, (Consumer<LookupElement>)((Consumer)items::add));
        if (parent instanceof PsiReferenceExpression) {
            List<ExpectedTypeInfo> expected = Arrays.asList(ExpectedTypesProvider.getExpectedTypes((PsiExpression)parent, true));
            CollectConversion.addCollectConversion((PsiReferenceExpression)parent, expected, (Consumer<LookupElement>)((Consumer)lookupElement -> items.add((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, expected))));
        }
        if (IMPORT_REFERENCE.accepts((Object)position)) {
            items.add((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        items.addAll(new JavaKeywordCompletion(parameters2, session2).getResults());
        JavaCompletionContributor.addExpressionVariants(parameters2, position, (Consumer<LookupElement>)((Consumer)items::add));
        return items;
    }

    private static void registerClassFromTypeElement(LookupElement element, JavaCompletionSession session2) {
        PsiClass aClass;
        PsiType type2 = ((PsiTypeLookupItem)ObjectUtils.assertNotNull((Object)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY))).getType();
        if (type2 instanceof PsiPrimitiveType) {
            session2.registerKeyword(type2.getCanonicalText(false));
            return;
        }
        PsiClass psiClass = aClass = type2 instanceof PsiClassType && ((PsiClassType)type2).getParameterCount() == 0 ? ((PsiClassType)type2).resolve() : null;
        if (aClass != null) {
            session2.registerClass(aClass);
        }
    }

    private static void addExpressionVariants(@NotNull CompletionParameters parameters2, PsiElement position, Consumer<LookupElement> result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "addExpressionVariants"));
        }
        if (JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)position) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)position) && !SmartCastProvider.shouldSuggestCast(parameters2)) {
            JavaCompletionContributor.addExpectedTypeMembers(parameters2, result2);
            if (SameSignatureCallParametersProvider.IN_CALL_ARGUMENT.accepts((Object)position)) {
                new SameSignatureCallParametersProvider().addSignatureItems(parameters2, result2);
            }
        }
    }

    public static boolean isInJavaContext(PsiElement position) {
        return PsiUtilCore.findLanguageFromElement((PsiElement)position).isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public static void addAllClasses(CompletionParameters parameters2, CompletionResultSet result2, JavaCompletionSession session2) {
        if (!JavaCompletionContributor.isClassNamePossible(parameters2) || !JavaCompletionContributor.mayStartClassName(result2)) {
            return;
        }
        if (parameters2.getInvocationCount() >= 2) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, parameters2.getInvocationCount() <= 2, result2.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
                if (!session2.alreadyProcessed((LookupElement)element)) {
                    result2.addElement(JavaCompletionUtil.highlightIfNeeded(null, element, element.getObject(), parameters2.getPosition()));
                }
            }));
        } else {
            JavaCompletionContributor.advertiseSecondCompletion(parameters2.getPosition().getProject(), result2);
        }
    }

    public static void advertiseSecondCompletion(Project project2, CompletionResultSet result2) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.second.basic", project2)) {
            result2.addLookupAdvertisement("Press " + JavaCompletionContributor.getActionShortcut((String)"CodeCompletion") + " to see non-imported classes");
        }
    }

    private static MultiMap<CompletionResultSet, LookupElement> addReferenceVariants(CompletionParameters parameters2, CompletionResultSet result2, JavaCompletionSession session2) {
        MultiMap items = MultiMap.create();
        PsiElement position = parameters2.getPosition();
        boolean first = parameters2.getInvocationCount() <= 1;
        boolean isSwitchLabel = SWITCH_LABEL.accepts((Object)position);
        boolean isAfterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        boolean pkgContext = JavaCompletionUtil.inSomePackage(position);
        PsiType[] expectedTypes = ExpectedTypesGetter.getExpectedTypes(parameters2.getPosition(), true);
        LegacyCompletionContributor.processReferences(parameters2, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, result1) -> {
            if (reference instanceof PsiJavaReference) {
                ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
                if (filter != null) {
                    if (INSIDE_CONSTRUCTOR.accepts((Object)position) && (parameters2.getInvocationCount() <= 1 || CheckInitialized.isInsideConstructorCall(position))) {
                        filter = new AndFilter(filter, (ElementFilter)new CheckInitialized(position));
                    }
                    PsiFile originalFile = parameters2.getOriginalFile();
                    JavaCompletionProcessor.Options options = JavaCompletionProcessor.Options.DEFAULT_OPTIONS.withCheckAccess(first).withFilterStaticAfterInstance(first).withShowInstanceInStaticContext(!first);
                    for (LookupElement element : JavaCompletionUtil.processJavaReference(position, (PsiJavaReference)reference, new ElementExtractorFilter(filter), options, result1.getPrefixMatcher(), parameters2)) {
                        JavaMethodCallElement call;
                        PsiMethod method;
                        if (session2.alreadyProcessed(element)) continue;
                        if (isSwitchLabel) {
                            items.putValue(result1, (Object)new IndentingDecorator((LookupElement)TailTypeDecorator.withTail(element, TailType.createSimpleTailType((char)':'))));
                            continue;
                        }
                        LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
                        if (originalFile instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)originalFile).isClassesAccepted() && item != null) {
                            item.setTailType(TailType.NONE);
                        }
                        if (item instanceof JavaMethodCallElement && (method = (PsiMethod)(call = (JavaMethodCallElement)item).getObject()).getTypeParameters().length > 0) {
                            PsiType matchingExpectation;
                            PsiType returned = TypeConversionUtil.erasure((PsiType)method.getReturnType());
                            PsiType psiType = matchingExpectation = returned == null ? null : (PsiType)ContainerUtil.find((Object[])expectedTypes, type2 -> type2.isAssignableFrom(returned));
                            if (matchingExpectation != null) {
                                call.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, matchingExpectation), position);
                            }
                        }
                        items.putValue(result1, (Object)element);
                    }
                }
                return;
            }
            if (reference instanceof PsiLabelReference) {
                items.putValues(result1, LabelReferenceCompletion.processLabelReference((PsiLabelReference)reference));
                return;
            }
            Object[] variants = reference.getVariants();
            if (variants == null) {
                LOG.error("Reference=" + reference);
            }
            for (Object completion : variants) {
                if (completion == null) {
                    LOG.error("Position=" + position + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(variants));
                }
                if (completion instanceof LookupElement && !session2.alreadyProcessed((LookupElement)completion)) {
                    items.putValue(result1, (Object)((LookupElement)completion));
                    continue;
                }
                if (completion instanceof PsiClass) {
                    Condition condition2 = psiClass -> !session2.alreadyProcessed((PsiClass)psiClass) && JavaCompletionUtil.isSourceLevelAccessible(position, psiClass, pkgContext);
                    items.putValues(result1, JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)completion, isAfterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<PsiClass>)condition2));
                    continue;
                }
                items.putValue(result1, (Object)LookupItemUtil.objectToLookupItem(completion));
            }
        }));
        return items;
    }

    static boolean isClassNamePossible(CompletionParameters parameters2) {
        boolean isSecondCompletion = parameters2.getInvocationCount() >= 2;
        PsiElement position = parameters2.getPosition();
        if (JavaKeywordCompletion.isInstanceofPlace(position) || JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position)) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return isSecondCompletion;
        }
        if (((PsiJavaCodeReferenceElement)parent).getQualifier() != null) {
            return isSecondCompletion;
        }
        if (parent instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)parent).getKind(parent.getContainingFile()) == 2) {
            return false;
        }
        PsiElement grand = parent.getParent();
        if (grand instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiImportStatement.class)).accepts((Object)parent)) {
            return isSecondCompletion;
        }
        if (grand instanceof PsiAnonymousClass) {
            grand = grand.getParent();
        }
        if (grand instanceof PsiNewExpression && ((PsiNewExpression)grand).getQualifier() != null) {
            return false;
        }
        return !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    public static boolean mayStartClassName(CompletionResultSet result2) {
        return StringUtil.isNotEmpty((String)result2.getPrefixMatcher().getPrefix());
    }

    private static void completeAnnotationAttributeName(CompletionResultSet result2, PsiElement insertedElement, CompletionParameters parameters2) {
        PsiElement element;
        PsiNameValuePair pair2 = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)insertedElement, PsiNameValuePair.class);
        PsiAnnotationParameterList parameterList = (PsiAnnotationParameterList)((PsiNameValuePair)ObjectUtils.assertNotNull((Object)pair2)).getParent();
        PsiAnnotation anno = (PsiAnnotation)parameterList.getParent();
        boolean showClasses = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)insertedElement);
        PsiClass annoClass = null;
        PsiJavaCodeReferenceElement referenceElement = anno.getNameReferenceElement();
        if (referenceElement != null && (element = referenceElement.resolve()) instanceof PsiClass && (annoClass = (PsiClass)element).findMethodsByName("value", false).length == 0) {
            showClasses = false;
        }
        if (showClasses && insertedElement.getParent() instanceof PsiReferenceExpression) {
            Set<LookupElement> set2 = JavaCompletionUtil.processJavaReference(insertedElement, (PsiJavaReference)insertedElement.getParent(), new ElementExtractorFilter(JavaCompletionContributor.createAnnotationFilter(insertedElement)), JavaCompletionProcessor.Options.DEFAULT_OPTIONS, result2.getPrefixMatcher(), parameters2);
            for (LookupElement element2 : set2) {
                result2.addElement(element2);
            }
            JavaCompletionContributor.addAllClasses(parameters2, result2, new JavaCompletionSession(result2));
        }
        if (annoClass != null) {
            PsiNameValuePair[] existingPairs = parameterList.getAttributes();
            block1: for (PsiMethod method : annoClass.getMethods()) {
                if (!(method instanceof PsiAnnotationMethod)) continue;
                String attrName = method.getName();
                for (PsiNameValuePair existingAttr : existingPairs) {
                    if (PsiTreeUtil.isAncestor((PsiElement)existingAttr, (PsiElement)insertedElement, (boolean)false)) break;
                    if (Comparing.equal((String)existingAttr.getName(), (String)attrName) || "value".equals(attrName) && existingAttr.getName() == null) continue block1;
                }
                LookupElementBuilder element3 = LookupElementBuilder.createWithIcon((PsiNamedElement)method).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        TailType.EQ.processTail(editor, editor.getCaretModel().getOffset());
                        context.setAddCompletionChar(false);
                        context.commitDocument();
                        PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiAnnotationParameterList.class, (boolean)false);
                        if (paramList != null && paramList.getAttributes().length > 0 && paramList.getAttributes()[0].getName() == null) {
                            int valueOffset = paramList.getAttributes()[0].getTextRange().getStartOffset();
                            context.getDocument().insertString(valueOffset, (CharSequence)"value");
                            TailType.EQ.processTail(editor, valueOffset + "value".length());
                        }
                    }
                });
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
                if (defaultValue != null) {
                    element3 = element3.withTailText(" default " + defaultValue.getText(), true);
                }
                result2.addElement((LookupElement)element3);
            }
        }
    }

    public String advertise(@NotNull CompletionParameters parameters2) {
        PsiType[] psiTypes;
        String shortcut;
        String shortcut2;
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "advertise"));
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() > 0) {
            PsiElement position = parameters2.getPosition();
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass())))).accepts((Object)position) && CompletionUtil.shouldShowFeature(parameters2, "editing.completion.global.member.name") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"CodeCompletion")))) {
                return "Pressing " + shortcut2 + " twice without a class qualifier would show all accessible static methods";
            }
        }
        if (parameters2.getCompletionType() != CompletionType.SMART && JavaCompletionContributor.shouldSuggestSmartCompletion(parameters2.getPosition()) && CompletionUtil.shouldShowFeature(parameters2, "editing.completion.smarttype.general") && StringUtil.isNotEmpty((String)(shortcut = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
            return CompletionBundle.message("completion.smart.hint", shortcut);
        }
        if (parameters2.getCompletionType() == CompletionType.SMART && parameters2.getInvocationCount() == 1 && (psiTypes = ExpectedTypesGetter.getExpectedTypes(parameters2.getPosition(), true)).length > 0) {
            if (CompletionUtil.shouldShowFeature(parameters2, "editing.completion.second.smarttype.toar") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType type2 = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
                    if (type2 == null) continue;
                    return CompletionBundle.message("completion.smart.aslist.hint", shortcut2, type2.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters2, "editing.completion.second.smarttype.aslist") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType componentType;
                    if (!(psiType instanceof PsiArrayType) || (componentType = ((PsiArrayType)psiType).getComponentType()) instanceof PsiPrimitiveType) continue;
                    return CompletionBundle.message("completion.smart.toar.hint", shortcut2, componentType.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters2, "editing.completion.second.smarttype.chain") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                return CompletionBundle.message("completion.smart.chain.hint", shortcut2);
            }
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        String suffix;
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "handleEmptyLookup"));
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        String ad = this.advertise(parameters2);
        String string = suffix = ad == null ? "" : "; " + StringUtil.decapitalize((String)ad);
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            PsiInstanceOfExpression instanceOfExpression;
            PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters2.getPosition(), PsiExpression.class, (boolean)true);
            if (expression2 instanceof PsiLiteralExpression) {
                return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
            }
            if (expression2 instanceof PsiInstanceOfExpression && PsiTreeUtil.isAncestor((PsiElement)(instanceOfExpression = (PsiInstanceOfExpression)expression2).getCheckType(), (PsiElement)parameters2.getPosition(), (boolean)false)) {
                return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
            }
            Set<PsiType> expectedTypes = JavaCompletionUtil.getExpectedTypes(parameters2);
            if (expectedTypes != null) {
                PsiType type2;
                PsiType psiType = type2 = expectedTypes.size() == 1 ? expectedTypes.iterator().next() : null;
                if (type2 != null) {
                    PsiType deepComponentType = type2.getDeepComponentType();
                    String expectedType = type2.getPresentableText();
                    if (expectedType.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) {
                        return null;
                    }
                    if (deepComponentType instanceof PsiClassType) {
                        if (((PsiClassType)deepComponentType).resolve() != null) {
                            return CompletionBundle.message("completion.no.suggestions.of.type", expectedType) + suffix;
                        }
                        return CompletionBundle.message("completion.unknown.type", expectedType) + suffix;
                    }
                    if (!PsiType.NULL.equals((Object)type2)) {
                        return CompletionBundle.message("completion.no.suggestions.of.type", expectedType) + suffix;
                    }
                }
            }
        }
        return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaCompletionContributor", "invokeAutoPopup"));
        }
        return typeChar == ':' && JavaTokenType.COLON == position.getNode().getElementType();
    }

    private static boolean shouldSuggestSmartCompletion(PsiElement element) {
        if (JavaCompletionContributor.shouldSuggestClassNameCompletion(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            return true;
        }
        return ExpectedTypesGetter.getExpectedTypes(element, false).length > 0;
    }

    private static boolean shouldSuggestClassNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiTypeElement || parent.getParent() instanceof PsiExpressionStatement || parent.getParent() instanceof PsiReferenceList;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaCompletionContributor", "beforeCompletion"));
        }
        PsiFile file2 = context.getFile();
        if (file2 instanceof PsiJavaFile) {
            if (context.getInvocationCount() > 0) {
                PsiType type2;
                PsiTypeElement typeElement;
                PsiVariable variable;
                JavaCompletionContributor.autoImport(file2, context.getStartOffset() - 1, context.getEditor());
                PsiElement leaf = file2.findElementAt(context.getStartOffset() - 1);
                if (leaf != null) {
                    leaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
                }
                if ((variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiVariable.class)) != null && (typeElement = variable.getTypeElement()) != null && (type2 = typeElement.getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                    JavaCompletionContributor.autoImportReference(file2, context.getEditor(), typeElement.getInnermostComponentReferenceElement());
                }
            }
            if (context.getCompletionType() == CompletionType.BASIC) {
                if (JavaCompletionContributor.semicolonNeeded(context.getEditor(), file2, context.getStartOffset())) {
                    context.setDummyIdentifier("IntellijIdeaRulezzz ".trim() + ";");
                    return;
                }
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && !(ref instanceof PsiReferenceExpression)) {
                    PsiReferenceParameterList paramList;
                    if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)ref) && (paramList = ref.getParameterList()) != null && paramList.getTextLength() > 0) {
                        context.getOffsetMap().addOffset(ConstructorInsertHandler.PARAM_LIST_START, paramList.getTextRange().getStartOffset());
                        context.getOffsetMap().addOffset(ConstructorInsertHandler.PARAM_LIST_END, paramList.getTextRange().getEndOffset());
                    }
                    return;
                }
                PsiElement element = file2.findElementAt(context.getStartOffset());
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)).accepts((Object)element)) {
                    return;
                }
                context.setDummyIdentifier("IntellijIdeaRulezzz");
            }
        }
    }

    public static boolean semicolonNeeded(Editor editor, PsiFile file2, int startOffset) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)startOffset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (ref != null && !(ref instanceof PsiReferenceExpression) && ref.getParent() instanceof PsiTypeElement) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)PsiJavaPatterns.psiParameter())).accepts((Object)file2.findElementAt(startOffset))) {
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(startOffset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == JavaTokenType.IDENTIFIER) {
            iterator.advance();
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.LPARENTH && PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiExpression.class, PsiClass.class}) == null) {
            return true;
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.COLON && null == PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)startOffset, PsiConditionalExpression.class, (boolean)false)) {
            return true;
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd() || iterator.getTokenType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        iterator.advance();
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        return iterator.getTokenType() == JavaTokenType.EQ;
    }

    private static void autoImport(@NotNull PsiFile file2, int offset, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImport"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImport"));
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        while (offset > 0 && Character.isJavaIdentifierPart(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0 || text2.charAt(offset) != '.') {
            return;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text2.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        JavaCompletionContributor.autoImportReference(file2, editor, JavaCompletionContributor.extractReference(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiExpression.class, (boolean)false)));
    }

    private static void autoImportReference(@NotNull PsiFile file2, @NotNull Editor editor, @Nullable PsiJavaCodeReferenceElement element) {
        PsiJavaCodeReferenceElement qualifier;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImportReference"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImportReference"));
        }
        if (element == null) {
            return;
        }
        while ((qualifier = JavaCompletionContributor.extractReference(element.getQualifier())) != null) {
            element = qualifier;
        }
        if (!(element.getParent() instanceof PsiMethodCallExpression) && element.multiResolve(true).length == 0) {
            new ImportClassFix(element).doFix(editor, false, false);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        }
    }

    @Nullable
    private static PsiJavaCodeReferenceElement extractReference(@Nullable PsiElement expression2) {
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression();
        }
        return null;
    }

    private static void addExpectedTypeMembers(CompletionParameters parameters2, Consumer<LookupElement> result2) {
        if (parameters2.getInvocationCount() <= 1) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                new JavaMembersGetter(info.getDefaultType(), parameters2).addMembers(false, result2);
            }
        }
    }

    static class IndentingDecorator
    extends LookupElementDecorator<LookupElement> {
        public IndentingDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void handleInsert(InsertionContext context) {
            super.handleInsert(context);
            Project project2 = context.getProject();
            Document document = context.getDocument();
            int lineStartOffset = DocumentUtil.getLineStartOffset(context.getStartOffset(), document);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(context.getFile(), lineStartOffset);
        }
    }
}

