/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.java.stubs.index.JavaStaticMemberNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticMemberProcessor {
    private final Set<PsiClass> myStaticImportedClasses = ContainerUtil.newHashSet();
    private final PsiElement myPosition;
    private final Project myProject;
    private final PsiResolveHelper myResolveHelper;
    private boolean myHintShown;
    private final boolean myPackagedContext;

    public StaticMemberProcessor(PsiElement position) {
        this.myPosition = position;
        this.myProject = this.myPosition.getProject();
        this.myResolveHelper = JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper();
        this.myPackagedContext = JavaCompletionUtil.inSomePackage(position);
    }

    public void importMembersOf(@Nullable PsiClass psiClass) {
        ContainerUtil.addIfNotNull(this.myStaticImportedClasses, (Object)psiClass);
    }

    public void processStaticMethodsGlobally(PrefixMatcher matcher, Consumer<LookupElement> consumer) {
        GlobalSearchScope scope = this.myPosition.getResolveScope();
        Collection memberNames = JavaStaticMemberNameIndex.getInstance().getAllKeys(this.myProject);
        for (String memberName : CompletionUtil.sortMatching(matcher, memberNames)) {
            THashSet classes2 = new THashSet();
            for (PsiMember member : JavaStaticMemberNameIndex.getInstance().getStaticMembers(memberName, this.myProject, scope)) {
                if (!this.isStaticallyImportable(member)) continue;
                PsiClass containingClass = member.getContainingClass();
                assert (containingClass != null) : member.getName() + "; " + member + "; " + member.getClass();
                if (!JavaCompletionUtil.isSourceLevelAccessible(this.myPosition, containingClass, this.myPackagedContext) || member instanceof PsiMethod && !classes2.add(containingClass)) continue;
                boolean shouldImport = this.myStaticImportedClasses.contains(containingClass);
                this.showHint(shouldImport);
                LookupElement item = member instanceof PsiMethod ? this.createItemWithOverloads((PsiMethod)member, containingClass, shouldImport) : (member instanceof PsiField ? this.createLookupElement(member, containingClass, shouldImport) : null);
                if (item == null) continue;
                consumer.consume((Object)item);
            }
        }
    }

    @Nullable
    private LookupElement createItemWithOverloads(PsiMethod method, PsiClass containingClass, boolean shouldImport) {
        List overloads = ContainerUtil.findAll((Object[])containingClass.findMethodsByName(method.getName(), true), this::isStaticallyImportable);
        assert (!overloads.isEmpty());
        if (overloads.size() == 1) {
            assert (method == overloads.get(0));
            return this.createLookupElement((PsiMember)method, containingClass, shouldImport);
        }
        if (((PsiMethod)overloads.get(0)).getParameterList().getParametersCount() == 0) {
            overloads.add(0, overloads.remove(1));
        }
        return this.createLookupElement(overloads, containingClass, shouldImport);
    }

    private void showHint(boolean shouldImport) {
        if (!this.myHintShown && !shouldImport) {
            String shortcut = CompletionContributor.getActionShortcut((String)"ShowIntentionActions");
            if (StringUtil.isNotEmpty((String)shortcut)) {
                CompletionService.getCompletionService().setAdvertisementText("To import a method statically, press " + shortcut);
            }
            this.myHintShown = true;
        }
    }

    public List<PsiMember> processMembersOfRegisteredClasses(PrefixMatcher matcher, PairConsumer<PsiMember, PsiClass> consumer) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiClass psiClass : this.myStaticImportedClasses) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                if (!matcher.prefixMatches(psiMethod.getName()) || !this.isStaticallyImportable((PsiMember)psiMethod)) continue;
                consumer.consume((Object)psiMethod, (Object)psiClass);
            }
            for (PsiMethod psiMethod : psiClass.getAllFields()) {
                if (!matcher.prefixMatches(psiMethod.getName()) || !this.isStaticallyImportable((PsiMember)psiMethod)) continue;
                consumer.consume((Object)psiMethod, (Object)psiClass);
            }
        }
        return result2;
    }

    private boolean isStaticallyImportable(PsiMember member) {
        return member.hasModifierProperty("static") && this.isAccessible(member) && !StaticImportMemberFix.isExcluded(member);
    }

    public PsiElement getPosition() {
        return this.myPosition;
    }

    protected boolean isAccessible(PsiMember member) {
        return this.myResolveHelper.isAccessible(member, this.myPosition, null);
    }

    @Nullable
    protected abstract LookupElement createLookupElement(@NotNull PsiMember var1, @NotNull PsiClass var2, boolean var3);

    protected abstract LookupElement createLookupElement(@NotNull List<PsiMethod> var1, @NotNull PsiClass var2, boolean var3);
}

