/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class XmlBasicToClassNameDelegator
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlBasicToClassNameDelegator", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlBasicToClassNameDelegator", "fillCompletionVariants"));
        }
        PsiElement position = parameters2.getPosition();
        PsiFile file2 = position.getContainingFile();
        if (parameters2.getCompletionType() != CompletionType.BASIC || !JavaCompletionContributor.mayStartClassName(result2) || !file2.getLanguage().isKindOf(StdLanguages.XML)) {
            return;
        }
        boolean empty = result2.runRemainingContributors(parameters2, true).isEmpty();
        if (!empty && parameters2.getInvocationCount() == 0) {
            result2.restartCompletionWhenNothingMatches();
        }
        if (empty && JavaClassReferenceCompletionContributor.findJavaClassReference(file2, parameters2.getOffset()) != null || parameters2.isExtendedCompletion()) {
            CompletionService.getCompletionService().getVariantsFromContributors(parameters2.delegateToClassName(), null, completionResult -> {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlBasicToClassNameDelegator", "lambda$fillCompletionVariants$0"));
                }
                LookupElement lookupElement = completionResult.getLookupElement();
                JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)lookupElement.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
                if (classElement != null) {
                    classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                }
                lookupElement.putUserData(XmlCompletionContributor.WORD_COMPLETION_COMPATIBLE, (Object)Boolean.TRUE);
                result2.passResult(completionResult);
            });
        }
    }
}

