/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    @Nullable
    private final CamelHumpMatcher myHumpMatcher;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myHumpMatcher = original instanceof CamelHumpMatcher ? (CamelHumpMatcher)original : null;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    @NotNull
    public BetterPrefixMatcher improve(CompletionResult result2) {
        int degree = RealPrefixMatchingWeigher.getBestMatchingDegree(result2.getLookupElement(), result2.getPrefixMatcher());
        if (degree <= this.myMinMatchingDegree) {
            BetterPrefixMatcher betterPrefixMatcher = this;
            if (betterPrefixMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "improve"));
            }
            return betterPrefixMatcher;
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal, degree);
        if (betterPrefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "improve"));
        }
        return betterPrefixMatcher;
    }

    @NotNull
    protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
        BetterPrefixMatcher betterPrefixMatcher = new BetterPrefixMatcher(original, degree);
        if (betterPrefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "createCopy"));
        }
        return betterPrefixMatcher;
    }

    public boolean prefixMatches(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "prefixMatches"));
        }
        return this.prefixMatchesEx(name2) == MatchingOutcome.BETTER_MATCH;
    }

    protected MatchingOutcome prefixMatchesEx(String name2) {
        return this.myHumpMatcher != null ? this.matchOptimized(name2, this.myHumpMatcher) : this.matchGeneric(name2);
    }

    private MatchingOutcome matchGeneric(String name2) {
        if (!this.myOriginal.prefixMatches(name2)) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!this.myOriginal.isStartMatch(name2)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return this.myOriginal.matchingDegree(name2) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    private MatchingOutcome matchOptimized(String name2, CamelHumpMatcher matcher) {
        FList<TextRange> fragments = matcher.matchingFragments(name2);
        if (fragments == null) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!MinusculeMatcher.isStartMatch(fragments)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return matcher.matchingDegree(name2, fragments) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    public boolean isStartMatch(String name2) {
        return this.myOriginal.isStartMatch(name2);
    }

    public int matchingDegree(String string) {
        return this.myOriginal.matchingDegree(string);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "cloneWithPrefix"));
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
        if (betterPrefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "cloneWithPrefix"));
        }
        return betterPrefixMatcher;
    }

    public static class AutoRestarting
    extends BetterPrefixMatcher {
        private final CompletionResultSet myResult;

        public AutoRestarting(@NotNull CompletionResultSet result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher$AutoRestarting", "<init>"));
            }
            this(result2, result2.getPrefixMatcher(), Integer.MIN_VALUE);
        }

        private AutoRestarting(CompletionResultSet result2, PrefixMatcher original, int minMatchingDegree) {
            super(original, minMatchingDegree);
            this.myResult = result2;
        }

        @Override
        @NotNull
        protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
            AutoRestarting autoRestarting = new AutoRestarting(this.myResult, original, degree);
            if (autoRestarting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher$AutoRestarting", "createCopy"));
            }
            return autoRestarting;
        }

        @Override
        protected MatchingOutcome prefixMatchesEx(String name2) {
            MatchingOutcome outcome = super.prefixMatchesEx(name2);
            if (outcome == MatchingOutcome.WORSE_MATCH) {
                this.myResult.restartCompletionOnAnyPrefixChange();
            }
            return outcome;
        }
    }

    protected static enum MatchingOutcome {
        NON_MATCH,
        WORSE_MATCH,
        BETTER_MATCH;

    }
}

