/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.ThreadLocalAnnotatorMap;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedAnnotators {
    private final ThreadLocalAnnotatorMap<String, Annotator> cachedAnnotators = new ThreadLocalAnnotatorMap<String, Annotator>(){

        @Override
        @NotNull
        public Collection<Annotator> initialValue(@NotNull String languageId) {
            if (languageId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$1", "initialValue"));
            }
            Language language = Language.findLanguageByID((String)languageId);
            List list2 = language == null ? ContainerUtil.emptyList() : LanguageAnnotators.INSTANCE.allForLanguage(language);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$1", "initialValue"));
            }
            return list2;
        }
    };

    public CachedAnnotators(Project project2) {
        ExtensionPointListener<Annotator> listener2 = new ExtensionPointListener<Annotator>(){

            public void extensionAdded(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$2", "extensionAdded"));
                }
                CachedAnnotators.this.cachedAnnotators.clear();
            }

            public void extensionRemoved(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/daemon/impl/CachedAnnotators$2", "extensionRemoved"));
                }
                CachedAnnotators.this.cachedAnnotators.clear();
            }
        };
        LanguageAnnotators.INSTANCE.addListener((ExtensionPointListener)listener2, (Disposable)project2);
    }

    @NotNull
    List<Annotator> get(@NotNull String languageId) {
        if (languageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/codeInsight/daemon/impl/CachedAnnotators", "get"));
        }
        List<Annotator> list2 = this.cachedAnnotators.get(languageId);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CachedAnnotators", "get"));
        }
        return list2;
    }
}

