/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HectorComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.editor.impl.HectorComponent");
    private WeakReference<JBPopup> myHectorRef;
    private final ArrayList<HectorComponentPanel> myAdditionalPanels;
    private final Map<Language, JSlider> mySliders;
    private final PsiFile myFile;
    private final String myTitle;

    public HectorComponent(@NotNull PsiFile file2) {
        boolean addLabel;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/HectorComponent", "<init>"));
        }
        super(new GridBagLayout());
        this.myTitle = EditorBundle.message((String)"hector.highlighting.level.title", (Object[])new Object[0]);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        this.myFile = file2;
        this.mySliders = new HashMap<Language, JSlider>();
        Project project2 = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        VirtualFile virtualFile = this.myFile.getContainingFile().getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        boolean notInLibrary = !fileIndex.isInLibrarySource(virtualFile) && !fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInContent(virtualFile);
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        ArrayList languages = new ArrayList(viewProvider.getLanguages());
        Collections.sort(languages, PsiUtilBase.LANGUAGE_COMPARATOR);
        for (Language language : languages) {
            final Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            sliderLabels.put(1, new JLabel(EditorBundle.message((String)"hector.none.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorOff, 2));
            sliderLabels.put(2, new JLabel(EditorBundle.message((String)"hector.syntax.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorSyntax, 2));
            if (notInLibrary) {
                sliderLabels.put(3, new JLabel(EditorBundle.message((String)"hector.inspections.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorOn, 2));
            }
            final JSlider slider = new JSlider(1, 1, notInLibrary ? 3 : 2, 1);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                slider.putClientProperty("Slider.paintThumbArrowShape", true);
                slider.setUI(new BasicSliderUI(slider));
            }
            slider.setLabelTable(sliderLabels);
            UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value2 = slider.getValue();
                    Enumeration enumeration = sliderLabels.keys();
                    while (enumeration.hasMoreElements()) {
                        Integer key2 = (Integer)enumeration.nextElement();
                        ((JComponent)sliderLabels.get(key2)).setForeground(key2 <= value2 ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
                    }
                }
            });
            PsiFile psiRoot = viewProvider.getPsi(language);
            assert (psiRoot != null) : "No root in " + viewProvider + " for " + language;
            slider.setValue(HectorComponent.getValue(HighlightingLevelManager.getInstance(project2).shouldHighlight((PsiElement)psiRoot), HighlightingLevelManager.getInstance(project2).shouldInspect((PsiElement)psiRoot)));
            this.mySliders.put(language, slider);
        }
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myTitle, (boolean)false));
        boolean bl = addLabel = this.mySliders.size() > 1;
        if (addLabel) {
            this.layoutVertical(panel2);
        } else {
            this.layoutHorizontal(panel2);
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)panel2, gc);
        gc.gridy = -1;
        gc.weighty = 0.0;
        HyperlinkLabel configurator = new HyperlinkLabel("Configure inspections");
        gc.insets.right = 5;
        gc.insets.bottom = 10;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 13;
        this.add((Component)configurator, gc);
        configurator.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                JBPopup hector = HectorComponent.this.getOldHector();
                if (hector != null) {
                    hector.cancel();
                }
                if (!DaemonCodeAnalyzer.getInstance((Project)HectorComponent.this.myFile.getProject()).isHighlightingAvailable(HectorComponent.this.myFile)) {
                    return;
                }
                Project project2 = HectorComponent.this.myFile.getProject();
                ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new ProjectInspectionToolsConfigurable(ProjectInspectionProfileManager.getInstance(HectorComponent.this.myFile.getProject())));
            }
        });
        gc.anchor = 17;
        gc.weightx = 1.0;
        gc.insets.right = 0;
        gc.fill = 2;
        this.myAdditionalPanels = new ArrayList();
        for (HectorComponentPanelsProvider provider : (HectorComponentPanelsProvider[])Extensions.getExtensions((ExtensionPointName)HectorComponentPanelsProvider.EP_NAME, (AreaInstance)project2)) {
            HectorComponentPanel componentPanel = provider.createConfigurable(file2);
            if (componentPanel == null) continue;
            this.myAdditionalPanels.add(componentPanel);
            this.add((Component)componentPanel.createComponent(), gc);
            componentPanel.reset();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        int width = JBUI.scale((int)300);
        if (preferredSize.width < width) {
            preferredSize.width = width;
        }
        return preferredSize;
    }

    private void layoutHorizontal(JPanel panel2) {
        for (JSlider slider : this.mySliders.values()) {
            slider.setOrientation(0);
            slider.setPreferredSize((Dimension)JBUI.size((int)200, (int)40));
            panel2.add((Component)slider, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        }
    }

    private void layoutVertical(JPanel panel2) {
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            JPanel borderPanel = new JPanel(new BorderLayout());
            slider.setPreferredSize((Dimension)JBUI.size((int)100));
            borderPanel.add((Component)new JLabel(language.getID()), "North");
            borderPanel.add((Component)slider, "Center");
            panel2.add((Component)borderPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 5, 0, 5), 0, 0));
        }
    }

    public void showComponent(RelativePoint point) {
        final JBPopup hector = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setRequestFocus(true).setMovable(true).setCancelCallback(() -> {
            for (HectorComponentPanel additionalPanel : this.myAdditionalPanels) {
                if (additionalPanel.canClose()) continue;
                return Boolean.FALSE;
            }
            this.onClose();
            return Boolean.TRUE;
        }).createPopup();
        Disposer.register((Disposable)this.myFile.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                JBPopup oldHector = HectorComponent.this.getOldHector();
                if (oldHector != null && !oldHector.isDisposed()) {
                    Disposer.dispose((Disposable)oldHector);
                }
                Disposer.dispose((Disposable)hector);
            }
        });
        JBPopup oldHector = this.getOldHector();
        if (oldHector != null) {
            oldHector.cancel();
        } else {
            this.myHectorRef = new WeakReference<JBPopup>(hector);
            hector.show(point);
        }
    }

    @Nullable
    private JBPopup getOldHector() {
        if (this.myHectorRef == null) {
            return null;
        }
        JBPopup hector = (JBPopup)this.myHectorRef.get();
        if (hector == null || !hector.isVisible()) {
            this.myHectorRef = null;
            return null;
        }
        return hector;
    }

    private void onClose() {
        if (this.isModified()) {
            for (HectorComponentPanel panel2 : this.myAdditionalPanels) {
                try {
                    panel2.apply();
                }
                catch (ConfigurationException configurationException) {}
            }
            this.forceDaemonRestart();
            DaemonListeners.getInstance(this.myFile.getProject()).updateStatusBar();
        }
    }

    private void forceDaemonRestart() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            assert (root != null) : "No root in " + viewProvider + " for " + language;
            int value2 = slider.getValue();
            if (value2 == 1) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_HIGHLIGHTING);
                continue;
            }
            if (value2 == 2) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_INSPECTION);
                continue;
            }
            HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.FORCE_HIGHLIGHTING);
        }
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)this.myFile.getProject());
        analyzer.restart();
    }

    private boolean isModified() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myFile.getProject());
            if (root == null || HectorComponent.getValue(highlightingLevelManager.shouldHighlight((PsiElement)root), highlightingLevelManager.shouldInspect((PsiElement)root)) == slider.getValue()) continue;
            return true;
        }
        for (HectorComponentPanel panel2 : this.myAdditionalPanels) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return false;
    }

    private static int getValue(boolean isSyntaxHighlightingEnabled, boolean isInspectionsHighlightingEnabled) {
        if (!isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 1;
        }
        if (isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 2;
        }
        return 3;
    }
}

