/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementListNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PsiElementListNavigator");

    private PsiElementListNavigator() {
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets, title, findUsagesTitle, listRenderer, null);
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask((Disposable)popup, () -> popup.show(new RelativePoint(e)), listUpdaterTask);
            } else {
                popup.show(new RelativePoint(e));
            }
        }
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets, title, findUsagesTitle, listRenderer, null);
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask((Disposable)popup, () -> popup.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Disposable popup, @NotNull Runnable action, @NotNull ListBackgroundUpdaterTask listUpdaterTask) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "runActionAndListUpdaterTask"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "runActionAndListUpdaterTask"));
        }
        if (listUpdaterTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listUpdaterTask", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "runActionAndListUpdaterTask"));
        }
        Alarm alarm = new Alarm(popup);
        alarm.addRequest(action, 300);
        ProgressManager.getInstance().run((Task)listUpdaterTask);
    }

    @Nullable
    private static JBPopup navigateOrCreatePopup(NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        return PsiElementListNavigator.navigateOrCreatePopup(targets, title, findUsagesTitle, listRenderer, listUpdaterTask, (Consumer<Object[]>)((Consumer)selectedElements -> {
            for (Object element : selectedElements) {
                PsiElement selected = (PsiElement)element;
                LOG.assertTrue(selected.isValid());
                ((NavigatablePsiElement)selected).navigate(true);
            }
        }));
    }

    @Nullable
    public static JBPopup navigateOrCreatePopup(@NotNull NavigatablePsiElement[] targets, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<Object[]> consumer) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "navigateOrCreatePopup"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "navigateOrCreatePopup"));
        }
        if (targets.length == 0) {
            return null;
        }
        if (targets.length == 1 && (listUpdaterTask == null || listUpdaterTask.isFinished())) {
            consumer.consume((Object)targets);
            return null;
        }
        CollectionListModel model = new CollectionListModel((Object[])targets);
        final JBList list2 = new JBList((ListModel)model);
        HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)list2);
        list2.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                Object[] selectedValues = list2.getSelectedValues();
                PsiElement[] copy = new PsiElement[selectedValues.length];
                for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                    copy[i2] = (PsiElement)selectedValues[i2];
                }
                return new PsiCopyPasteManager.MyTransferable(copy);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        list2.setCellRenderer(listRenderer);
        list2.setFont(EditorUtil.getEditorFont());
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
        if (listRenderer instanceof PsiElementListCellRenderer) {
            ((PsiElementListCellRenderer)listRenderer).installSpeedSearch(builder);
        }
        PopupChooserBuilder popupChooserBuilder = builder.setTitle(title).setMovable(true).setResizable(true).setItemChoosenCallback(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "lambda$navigateOrCreatePopup$3"));
            }
            int[] ids = list2.getSelectedIndices();
            if (ids == null || ids.length == 0) {
                return;
            }
            Object[] selectedElements = list2.getSelectedValues();
            consumer.consume((Object)selectedElements);
        }).setCancelCallback(() -> {
            HintUpdateSupply.hideHint((JComponent)list2);
            if (listUpdaterTask != null) {
                listUpdaterTask.cancelTask();
            }
            return true;
        });
        Ref usageView = new Ref();
        if (findUsagesTitle != null) {
            popupChooserBuilder = popupChooserBuilder.setCouldPin(popup -> {
                if (targets == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator", "lambda$navigateOrCreatePopup$5"));
                }
                List items = model.getItems();
                usageView.set((Object)FindUtil.showInUsageView(null, items.toArray(new PsiElement[items.size()]), findUsagesTitle, targets[0].getProject()));
                popup.cancel();
                return false;
            });
        }
        JBPopup popup2 = popupChooserBuilder.createPopup();
        builder.getScrollPane().setBorder(null);
        builder.getScrollPane().setViewportBorder(null);
        if (listUpdaterTask != null) {
            listUpdaterTask.init((AbstractPopup)popup2, list2, (Ref<UsageView>)usageView);
        }
        return popup2;
    }
}

