/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final Map<PsiFile, Boolean> myFileToolsCache = ContainerUtil.createConcurrentWeakMap();
    private final ProjectInspectionProfileManager myProfileManager;
    private final Map<PsiFile, Long> myPsiModificationCount = ContainerUtil.createConcurrentWeakMap();

    public WholeFileLocalInspectionsPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar, ProjectInspectionProfileManager profileManager) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
        this.myProfileManager = profileManager;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WholeFileLocalInspectionsPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "getComponentName"));
        }
        return "WholeFileLocalInspectionsPassFactory";
    }

    public void projectOpened() {
        this.myProfileManager.addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.clear();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.clear();
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this.myFileToolsCache::clear);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        Long appliedModificationCount = this.myPsiModificationCount.get(file2);
        if (appliedModificationCount != null && appliedModificationCount.longValue() == PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount()) {
            return null;
        }
        if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
            return null;
        }
        if (this.myFileToolsCache.containsKey(file2) && !this.myFileToolsCache.get(file2).booleanValue()) {
            return null;
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), (TextRange)visibleRange, true, new DefaultHighlightInfoProcessor()){

            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
                if (profile2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "getInspectionTools"));
                }
                List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile2);
                List<LocalInspectionToolWrapper> result2 = tools.stream().filter(LocalInspectionToolWrapper::runForWholeFile).collect(Collectors.toList());
                WholeFileLocalInspectionsPassFactory.this.myFileToolsCache.put(file2, !result2.isEmpty());
                List<LocalInspectionToolWrapper> list2 = result2;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "getInspectionTools"));
                }
                return list2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            @Override
            void inspectInjectedPsi(@NotNull List<PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (iManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
                if (wrappers == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2", "inspectInjectedPsi"));
                }
            }

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount.put(file2, PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount());
            }
        };
    }
}

