/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "<init>"));
        }
        this(key2.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key2);
    }

    public SuppressFix(@NotNull String ID2) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "<init>"));
        }
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        String myText = super.getText();
        String string = StringUtil.isEmpty((String)myText) ? InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]) : myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getText"));
        }
        return string;
    }

    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement context) {
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiJavaDocumentedElement) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class)) != null) continue;
            return null;
        }
        return container instanceof SyntheticElement ? null : (PsiJavaDocumentedElement)container;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
        boolean isValid;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "isAvailable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "isAvailable"));
        }
        PsiJavaDocumentedElement container = this.getContainer(context);
        boolean bl = isValid = container != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        if (container instanceof PsiJavaModule) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.module", (Object[])new Object[0]));
        } else if (container instanceof PsiClass) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.class", (Object[])new Object[0]));
        } else if (container instanceof PsiMethod) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.method", (Object[])new Object[0]));
        } else {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.field", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "invoke"));
        }
        if (this.doSuppress(project2, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getFamilyName"));
        }
        return string;
    }

    private boolean doSuppress(@NotNull Project project2, PsiJavaDocumentedElement container) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "doSuppress"));
        }
        assert (container != null);
        if (container instanceof PsiModifierListOwner && this.use15Suppressions(container)) {
            PsiModifierListOwner modifierOwner = (PsiModifierListOwner)container;
            PsiModifierList modifierList = modifierOwner.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project2, (PsiElement)container, modifierOwner, this.getID((PsiElement)container));
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project2, null, null, () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "lambda$doSuppress$0"));
                }
                this.suppressByDocComment(project2, container);
            }, (PsiFile[])new PsiFile[]{container.getContainingFile()});
        }
        return false;
    }

    private void suppressByDocComment(@NotNull Project project2, PsiJavaDocumentedElement container) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "suppressByDocComment"));
        }
        PsiDocComment docComment = container.getDocComment();
        PsiManager manager = PsiManager.getInstance((Project)project2);
        if (docComment == null) {
            String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
            docComment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocCommentFromText(commentText);
            PsiElement firstChild = container.getFirstChild();
            container.addBefore((PsiElement)docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID((PsiElement)container);
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID((PsiElement)container);
                docComment.add((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "use15Suppressions"));
        }
        return JavaSuppressionUtil.canHave15Suppressions((PsiElement)container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container);
    }

    private String getID(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getID"));
        }
        String id = SuppressFix.getID(place, this.myAlternativeID);
        return id != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module2;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getID"));
        }
        if (alternativeID != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) != null && ClassPathStorageUtil.isClasspathStorage(module2)) {
            return alternativeID;
        }
        return null;
    }
}

