/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    @Nullable
    static HighlightInfo checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkAbstractInstantiation"));
        }
        PsiElement parent = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent instanceof PsiAnonymousClass && parent.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild((PsiElement)parent.getParent())) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods((PsiClass)aClass, ref.getTextRange());
        }
        return highlightInfo;
    }

    @Nullable
    private static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass, TextRange range) {
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, (PsiElement)aClass, range);
    }

    @Nullable
    static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass, PsiElement implementsFixElement, TextRange range) {
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
        if (abstractMethod == null) {
            return null;
        }
        PsiClass superClass = abstractMethod.getContainingClass();
        if (superClass == null) {
            return null;
        }
        String baseClassName = HighlightUtil.formatClass(aClass, false);
        String methodName = JavaHighlightUtil.formatMethod(abstractMethod);
        String message2 = JavaErrorMessages.message(aClass instanceof PsiEnumConstantInitializer || implementsFixElement instanceof PsiEnumConstant ? "enum.constant.should.implement.method" : "class.must.be.abstract", baseClassName, methodName, HighlightUtil.formatClass(superClass, false));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        PsiMethod anyMethodToImplement = ClassUtil.getAnyMethodToImplement((PsiClass)aClass);
        if (anyMethodToImplement != null) {
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(implementsFixElement));
            } else {
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)anyMethodToImplement, "protected", true, true));
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)anyMethodToImplement, "public", true, true));
            }
        }
        if (!(aClass instanceof PsiAnonymousClass) && HighlightUtil.getIncompatibleModifier("abstract", aClass.getModifierList()) == null) {
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassMustBeAbstract(PsiClass aClass, TextRange textRange) {
        if (aClass.hasModifierProperty("abstract") || aClass.getRBrace() == null || aClass.isEnum() && HighlightClassUtil.hasEnumConstants(aClass)) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, textRange);
    }

    @Nullable
    static HighlightInfo checkInstantiationOfAbstractClass(PsiClass aClass, @NotNull PsiElement highlightElement) {
        if (highlightElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkInstantiationOfAbstractClass"));
        }
        HighlightInfo errorResult = null;
        if (!(aClass == null || !aClass.hasModifierProperty("abstract") || highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getType() instanceof PsiArrayType)) {
            String baseClassName = aClass.getName();
            String message2 = JavaErrorMessages.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(highlightElement).descriptionAndTooltip(message2).create();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
            if (!aClass.isInterface() && anyAbstractMethod == null) {
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", false, false));
            }
            if (anyAbstractMethod != null && highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getClassReference() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementAbstractClassMethodsFix(highlightElement));
            }
        }
        return errorResult;
    }

    private static boolean hasEnumConstants(PsiClass aClass) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkDuplicateTopLevelClass(PsiClass aClass) {
        if (!(aClass.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass.getManager();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module2 == null) {
            return null;
        }
        PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClasses(qualifiedName, GlobalSearchScope.moduleScope((Module)module2).intersectWith(aClass.getResolveScope()));
        if (classes2.length < numOfClassesToFind) {
            return null;
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module2).getFileIndex();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (virtualFile == null) {
            return null;
        }
        boolean isTestSourceRoot = fileIndex.isInTestSourceContent(virtualFile);
        String dupFileName = null;
        for (PsiClass dupClass : classes2) {
            VirtualFile file2;
            if (dupClass == aClass || (file2 = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject((PsiElement)dupClass) || fileIndex.isInTestSourceContent(file2) != isTestSourceRoot) continue;
            dupFileName = FileUtil.toSystemDependentName((String)file2.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message2 = JavaErrorMessages.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
    }

    @Nullable
    static HighlightInfo checkDuplicateNestedClass(PsiClass aClass) {
        String name2;
        if (aClass == null) {
            return null;
        }
        PsiClass parent = aClass;
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            parent = aClass.getParent();
        }
        if ((name2 = aClass.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType((PsiElement)element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name2.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message2 = JavaErrorMessages.message("duplicate.class", name2);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPublicClassInRightFile(PsiClass aClass) {
        PsiFile containingFile = aClass.getContainingFile();
        if (aClass.getParent() != containingFile || !aClass.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile file2 = (PsiJavaFile)containingFile;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || virtualFile.getNameWithoutExtension().equals(aClass.getName())) {
            return null;
        }
        String message2 = JavaErrorMessages.message("public.class.should.be.named.after.file", aClass.getName());
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)aClass, range.getStartOffset(), range.getEndOffset()).descriptionAndTooltip(message2).create();
        PsiModifierList psiModifierList = aClass.getModifierList();
        QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(psiModifierList, "public", false, false));
        PsiClass[] classes2 = file2.getClasses();
        if (classes2.length > 1) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMoveClassToSeparateFileFix(aClass));
        }
        for (PsiClass otherClass : classes2) {
            if (otherClass.getManager().areElementsEquivalent((PsiElement)otherClass, (PsiElement)aClass) || !otherClass.hasModifierProperty("public") || !virtualFile.getNameWithoutExtension().equals(otherClass.getName())) continue;
            return errorResult;
        }
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameFileFix(aClass.getName() + ".java"));
        QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)aClass));
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassAndPackageConflict(@NotNull PsiClass aClass) {
        String simpleName;
        PsiDirectory subDirectory;
        PsiElement directory;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassAndPackageConflict"));
        }
        String name2 = aClass.getQualifiedName();
        if ("java.lang".equals(name2)) {
            String message2 = JavaErrorMessages.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        }
        PsiElement file2 = aClass.getParent();
        if (file2 instanceof PsiJavaFile && !((PsiJavaFile)file2).getPackageName().isEmpty() && (directory = file2.getParent()) instanceof PsiDirectory && (subDirectory = ((PsiDirectory)directory).findSubdirectory(simpleName = aClass.getName())) != null && simpleName.equals(subDirectory.getName()) && PsiTreeUtil.findChildOfType((PsiElement)subDirectory, PsiJavaFile.class) != null) {
            String message3 = JavaErrorMessages.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkStaticFieldDeclarationInInnerClass"));
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)field) || PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction(result2, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, field.getContainingClass());
        return result2;
    }

    private static void registerMakeInnerClassStatic(HighlightInfo result2, PsiClass aClass) {
        if (aClass != null && aClass.getContainingClass() != null) {
            QuickFixAction.registerQuickFixAction(result2, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
        }
    }

    @Nullable
    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction(result2, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, (PsiClass)keyword.getParent().getParent().getParent());
        return result2;
    }

    @Nullable
    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)initializer)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction(result2, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)initializer, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(result2, (PsiClass)keyword.getParent().getParent().getParent());
        return result2;
    }

    private static PsiElement getEnclosingStaticClass(@NotNull PsiKeyword keyword, @NotNull Class<?> parentClass) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "getEnclosingStaticClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "getEnclosingStaticClass"));
        }
        return new PsiMatcherImpl((PsiElement)keyword).dot(PsiMatchers.hasText("static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement();
    }

    @Nullable
    private static HighlightInfo checkStaticClassDeclarationInInnerClass(PsiKeyword keyword) {
        if (new PsiMatcherImpl((PsiElement)keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)aClass)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null) {
            for (PsiElement element : modifierList.getChildren()) {
                if (!Comparing.equal((String)element.getText(), (String)"static")) continue;
                context = element;
                break;
            }
        }
        TextRange range = context != null ? context.getTextRange() : HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        if (context != keyword) {
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false));
        }
        PsiClass containingClass = aClass.getContainingClass();
        HighlightClassUtil.registerMakeInnerClassStatic(info, containingClass);
        return info;
    }

    @Nullable
    static HighlightInfo checkStaticDeclarationInInnerClass(PsiKeyword keyword) {
        HighlightInfo errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsAllowed(PsiReferenceList list2) {
        boolean isExtends;
        PsiClass aClass;
        if (list2.getParent() instanceof PsiClass && (aClass = (PsiClass)list2.getParent()).isEnum() && (isExtends = list2.equals(aClass.getExtendsList()))) {
            String description = JavaErrorMessages.message("extends.after.enum", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkImplementsAllowed(PsiReferenceList list2) {
        boolean isImplements;
        PsiClass aClass;
        if (list2.getParent() instanceof PsiClass && (aClass = (PsiClass)list2.getParent()).isInterface() && (isImplements = list2.equals(aClass.getImplementsList()))) {
            String description = JavaErrorMessages.message("implements.after.interface", new Object[0]);
            HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list2).descriptionAndTooltip(description).create();
            PsiClassType[] referencedTypes = list2.getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickFixAction.registerQuickFixAction(result2, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, referencedTypes[0]));
            }
            return result2;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsClassAndImplementsInterface(PsiReferenceList referenceList, JavaResolveResult resolveResult, PsiJavaCodeReferenceElement ref) {
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            String message2 = JavaErrorMessages.message(mustBeInterface ? "interface.expected" : "no.interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            PsiClassType type2 = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(ref);
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, type2));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkCannotInheritFromFinal(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message2 = JavaErrorMessages.message("inheritance.from.final.class", superClass.getQualifiedName());
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superClass, "final", false, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAnonymousInheritFinal(PsiNewExpression expression2) {
        PsiAnonymousClass aClass = (PsiAnonymousClass)PsiTreeUtil.getChildOfType((PsiElement)expression2, PsiAnonymousClass.class);
        if (aClass == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, (PsiElement)aClass.getBaseClassReference());
    }

    @Nullable
    private static String checkDefaultConstructorThrowsException(PsiMethod constructor, @NotNull PsiClassType[] handledExceptions) {
        if (handledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledExceptions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkDefaultConstructorThrowsException"));
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(@NotNull PsiClass aClass, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassDoesNotCallSuperConstructorOrHandleExceptions"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassDoesNotCallSuperConstructorOrHandleExceptions"));
        }
        if (aClass.isEnum()) {
            return null;
        }
        if (aClass.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    static HighlightInfo checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper, @NotNull TextRange range, @NotNull PsiClassType[] handledExceptions) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (handledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledExceptions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)aClass, aClass.getProject(), baseClass);
        List constructorCandidates = (resolved != null ? Collections.singletonList((PsiMethod)resolved) : Arrays.asList(constructors)).stream().filter(constructor -> {
            if (resolveHelper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "lambda$checkBaseClassDefaultConstructorProblem$0"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "lambda$checkBaseClassDefaultConstructorProblem$0"));
            }
            PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
            return (parameters2.length == 0 || parameters2.length == 1 && parameters2[0].isVarArgs()) && resolveHelper.isAccessible((PsiMember)constructor, (PsiElement)aClass, null);
        }).limit(2L).collect(Collectors.toList());
        if (constructorCandidates.size() >= 2) {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(0)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(1)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(JavaErrorMessages.message("ambiguous.method.call", m1, m2)).create();
        }
        if (!constructorCandidates.isEmpty()) {
            PsiMethod constructor2 = (PsiMethod)constructorCandidates.get(0);
            String description = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor2, handledExceptions);
            if (description != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
                return info;
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced((PsiNamedElement)constructor2);
            }
            return null;
        }
        String description = JavaErrorMessages.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
        return info;
    }

    @Nullable
    static HighlightInfo checkInterfaceCannotBeLocal(PsiClass aClass) {
        if (PsiUtil.isLocalClass((PsiClass)aClass)) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            String description = JavaErrorMessages.message("interface.cannot.be.local", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicInheritance(PsiClass aClass) {
        PsiClass circularClass = HighlightClassUtil.getCircularClass(aClass, new HashSet<PsiClass>());
        if (circularClass != null) {
            String description = JavaErrorMessages.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiClass getCircularClass(PsiClass aClass, Collection<PsiClass> usedClasses) {
        if (usedClasses.contains(aClass)) {
            return aClass;
        }
        try {
            PsiClass[] superTypes;
            usedClasses.add(aClass);
            for (PsiClass superType : superTypes = aClass.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = HighlightClassUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsDuplicate(PsiJavaCodeReferenceElement element, PsiElement resolved, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkExtendsDuplicate"));
        }
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list2 = (PsiReferenceList)element.getParent();
        if (!(list2.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list2.getReferencedTypes();
        int dupCount = 0;
        PsiManager manager = containingFile.getManager();
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !manager.areElementsEquivalent((PsiElement)resolvedElement, (PsiElement)aClass)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description = JavaErrorMessages.message("duplicate.class", HighlightUtil.formatClass(aClass));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAlreadyImported(PsiClass aClass, PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file2 = aClass.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        if (aClass.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass) || !Comparing.equal((String)aClass.getName(), (String)((PsiClass)resolved).getName(), (boolean)true)) continue;
            String description = JavaErrorMessages.message("class.already.imported", HighlightUtil.formatClass(aClass, false));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassExtendsOnlyOneClass(PsiReferenceList list2) {
        PsiClassType[] referencedTypes = list2.getReferencedTypes();
        PsiElement parent = list2.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list2) {
            String description = JavaErrorMessages.message("class.cannot.extend.multiple.classes", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThingNotAllowedInInterface(PsiElement element, PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return null;
        }
        String description = JavaErrorMessages.message("not.allowed.in.interface", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkQualifiedNew(PsiNewExpression expression2, PsiType type2, PsiClass aClass) {
        PsiExpression qualifier = expression2.getQualifier();
        if (qualifier == null) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            String description = JavaErrorMessages.message("invalid.qualified.new", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, null));
            return info;
        }
        HighlightInfo info = null;
        if (aClass != null) {
            PsiClass baseClass;
            if (aClass.hasModifierProperty("static")) {
                String description = JavaErrorMessages.message("qualified.new.of.static.class", new Object[0]);
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
                if (!aClass.isEnum()) {
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false));
                }
            } else if (aClass instanceof PsiAnonymousClass && (baseClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType())) != null && baseClass.isInterface()) {
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip("Anonymous class implements interface; cannot have qualifier for new").create();
            }
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, aClass));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkClassExtendsForeignInnerClass(final PsiJavaCodeReferenceElement extendRef, final PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent = extendRef.getParent();
        if (!(parent instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        final PsiClass aClass = (PsiClass)grand;
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner2 = ((PsiTypeParameter)aClass).getOwner();
            if (!(owner2 instanceof PsiClass)) {
                return null;
            }
            containerClass = (PsiClass)owner2;
        } else {
            containerClass = aClass;
        }
        if (aClass.getExtendsList() != parent && aClass.getImplementsList() != parent) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
        }
        final HighlightInfo[] infos = new HighlightInfo[1];
        extendRef.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (infos[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve2;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass) {
                        String description = JavaErrorMessages.message("private.symbol", HighlightUtil.formatClass(base), HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                        return;
                    }
                    if (!PsiUtil.isInnerClass((PsiClass)base)) {
                        return;
                    }
                    if (!(resolve2 != resolved || baseClass == null || PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)extendRef, (boolean)true) && !aClass.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)baseClass, (PsiElement)extendRef, psiClass -> psiClass != aClass, (boolean)true) || HighlightClassUtil.qualifiedNewCalledInConstructors(aClass))) {
                        String description = JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                    }
                }
            }
        });
        return infos[0];
    }

    private static boolean qualifiedNewCalledInConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression2;
            PsiCodeBlock body2 = constructor.getBody();
            if (body2 == null) {
                return false;
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length == 0) {
                return false;
            }
            PsiStatement firstStatement = statements[0];
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)expression2)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            if ("this".equals(methodCallExpression.getMethodExpression().getReferenceName()) || (qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)(referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiNewExpression expression2, PsiType type2, PsiClass aClass) {
        if (type2 == null || type2 instanceof PsiArrayType || type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (aClass == null) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifier();
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)expression2, qualifier, aClass);
    }

    @Nullable
    public static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, @Nullable PsiExpression qualifier, PsiClass aClass) {
        PsiElement placeToSearchEnclosingFrom;
        if (qualifier != null) {
            PsiType qType = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType((PsiType)qType);
        } else {
            placeToSearchEnclosingFrom = element;
        }
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext(element, placeToSearchEnclosingFrom, aClass);
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, PsiElement placeToSearchEnclosingFrom, PsiClass aClass) {
        if (aClass == null || !PsiUtil.isInnerClass((PsiClass)aClass)) {
            return null;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            return null;
        }
        if (outerClass instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)placeToSearchEnclosingFrom, (boolean)true, (boolean)false)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass, outerClass, element);
    }

    @Nullable
    static HighlightInfo checkSuperQualifierType(@NotNull Project project2, @NotNull PsiMethodCallExpression superCall) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkSuperQualifierType"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkSuperQualifierType"));
        }
        if (!RefactoringChangeUtil.isSuperMethodCall((PsiElement)superCall)) {
            return null;
        }
        PsiMethod ctr = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (ctr == null) {
            return null;
        }
        PsiClass aClass = ctr.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiClass targetClass = aClass.getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (PsiUtil.isInnerClass((PsiClass)targetClass)) {
                PsiClass outerClass = targetClass.getContainingClass();
                if (outerClass != null) {
                    PsiClassType outerType = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createType(outerClass);
                    return HighlightUtil.checkAssignability((PsiType)outerType, null, qualifier, (PsiElement)qualifier);
                }
            } else {
                String description = "'" + HighlightUtil.formatClass(targetClass) + "' is not an inner class";
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, @Nullable PsiClass aClass, PsiClass outerClass, PsiElement elementToHighlight) {
        if (outerClass != null && !PsiTreeUtil.isContextAncestor((PsiElement)outerClass, (PsiElement)place, (boolean)false)) {
            String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            HighlightClassUtil.registerMakeInnerClassStatic(highlightInfo, aClass);
            return highlightInfo;
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, (PsiClass)outerClass);
        if (staticParent != null) {
            String element = outerClass == null ? "" : HighlightUtil.formatClass(outerClass) + "." + (place instanceof PsiSuperExpression ? "super" : "this");
            String description = JavaErrorMessages.message("cannot.be.referenced.from.static.context", element);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
            if (aClass != null && HighlightUtil.getIncompatibleModifier("static", aClass.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
            }
            return highlightInfo;
        }
        return null;
    }
}

