/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapArrayToArraysAsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapLongWithMathToIntExactFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapStringWithFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final String MISMATCH_COLOR = UIUtil.isUnderDarcula() ? "ff6464" : "red";
    private static final Logger LOG = Logger.getInstance(HighlightMethodUtil.class);

    private HighlightMethodUtil() {
    }

    static String createClashMethodMessage(PsiMethod method1, PsiMethod method2, boolean showContainingClasses) {
        String pattern = showContainingClasses ? "clash.methods.message.show.classes" : "clash.methods.message";
        return JavaErrorMessages.message(pattern, JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(method1.getContainingClass()), HighlightUtil.formatClass(method2.getContainingClass()));
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        PsiMethod method = methodSignature.getMethod();
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)containingFile.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(PsiMethod method, PsiModifierList modifierList, String accessModifier, int accessLevel, PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList());
        if (accessLevel < superAccessLevel) {
            PsiElement keyword;
            String description = JavaErrorMessages.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), VisibilityUtil.toPresentableText((String)accessModifier), PsiUtil.getAccessModifier((int)superAccessLevel));
            TextRange textRange = includeRealPositionInfo ? ((keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)accessModifier)) == null ? method.getNameIdentifier().getTextRange() : keyword.getTextRange()) : TextRange.EMPTY_RANGE;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, PsiUtil.getAccessModifier((int)superAccessLevel), true, false));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange toHighlight;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            TextRange textRange2 = textRange != null ? textRange : (toHighlight = includeRealPositionInfo ? method.getReturnTypeElement().getTextRange() : TextRange.EMPTY_RANGE);
            HighlightInfo highlightInfo = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorMessages.message("incompatible.return.type", new Object[0]), toHighlight, PsiUtil.getLanguageLevel((PsiElement)aClass));
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (detailMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailMessage", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (superReturnType == null) {
            return null;
        }
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (superContainingClass != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure((PsiType)superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && ((Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])methodSignature.getTypeParameters(), (PsiSubstitutor)methodSignature.getSubstitutor(), () -> {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "lambda$checkSuperMethodSignature$0"));
            }
            return TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType);
        })).booleanValue()) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (substitutedSuperReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedSuperReturnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (detailMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailMessage", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        String description = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
        if (returnClass != null && substitutedSuperReturnType instanceof PsiClassType) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createChangeParameterClassFix(returnClass, (PsiClassType)substitutedSuperReturnType));
        }
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(PsiMethod method, PsiMethod superMethod) {
        if (superMethod.hasModifierProperty("final")) {
            String description = JavaErrorMessages.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "final", false, true));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method = methodSignature.getMethod();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (psiClassType == null) {
                LOG.error("throws: " + method.getThrowsList().getText() + "; method: " + method);
            }
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum((MethodSignature)methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String description = JavaErrorMessages.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType((PsiType)exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(MethodSignature methodSignature, MethodSignatureBackedByPsiMethod superSignature, List<PsiClassType> checkedExceptions, PsiSubstitutor substitutorForDerivedClass) {
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)checkedEx) : TypeConversionUtil.erasure((PsiType)checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)thrownException1) : TypeConversionUtil.erasure((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion, @NotNull PsiFile file2) {
        HighlightInfo highlightInfo;
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        PsiExpressionList list2 = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list2, referenceToMethod);
        if (isDummy) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            String errorMessage;
            String message2;
            PsiReferenceExpression methodRef;
            PsiElement element;
            PsiClass containingClass;
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions((PsiElement)methodCall, fixRange);
            if (highlightInfo == null && ((PsiMethod)resolved).hasModifierProperty("static") && (containingClass = ((PsiMethod)resolved).getContainingClass()) != null && containingClass.isInterface() && (highlightInfo = HighlightUtil.checkFeature(element = (PsiElement)ObjectUtils.notNull((Object)(methodRef = methodCall.getMethodExpression()).getReferenceNameElement(), (Object)methodRef), HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file2)) == null && (message2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(methodRef, resolveResult.getCurrentFileResolveScope(), containingClass)) != null) {
                highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(fixRange).create();
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor, fixRange);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
            }
            if (highlightInfo == null && (errorMessage = ((MethodCandidateInfo)resolveResult).getInferenceErrorMessage()) != null && (highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(errorMessage).range(fixRange).create()) != null) {
                HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list2, resolveHelper);
                HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, (MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
                HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, (MethodCandidateInfo)resolveResult, (PsiMethod)resolved, highlightInfo);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    PsiElement element;
                    String toolTip;
                    String methodName = HighlightMessageUtil.getSymbolName(resolved, substitutor);
                    PsiElement parent = resolved.getParent();
                    String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName(parent, substitutor);
                    String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                    String description = JavaErrorMessages.message("wrong.method.arguments", methodName, containerName, argTypes);
                    Ref elementToHighlight = new Ref((Object)list2);
                    if (parent instanceof PsiClass) {
                        toolTip = HighlightMethodUtil.buildOneLineMismatchDescription(list2, candidateInfo, (Ref<PsiElement>)elementToHighlight);
                        if (toolTip == null) {
                            toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list2);
                        }
                    } else {
                        toolTip = description;
                    }
                    int navigationShift = (element = (PsiElement)elementToHighlight.get()) instanceof PsiExpressionList ? 1 : 0;
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list2, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, (PsiCall)methodCall);
                        HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, candidateInfo, resolvedMethod, highlightInfo);
                    }
                } else {
                    PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments((PsiTypeParameterListOwner)resolvedMethod, (PsiElement)methodCall, applicabilitySubstitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)methodExpression, applicabilitySubstitutor, javaSdkVersion);
                }
            } else {
                String description = JavaErrorMessages.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(description).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    PsiMethod method;
                    TextRange range = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
                    if (resolved instanceof PsiVariable && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiVariable)resolved).getType())) != null) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, substitutor, javaSdkVersion);
        }
        return highlightInfo;
    }

    private static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull PsiMethodCallExpression methodCall, MethodCandidateInfo resolveResult, PsiMethod resolved, HighlightInfo highlightInfo) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiElement resolve2;
        PsiExpression lExpression;
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerTargetTypeFixesBasedOnApplicabilityInference"));
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable variable = null;
        if (parent instanceof PsiVariable) {
            variable = (PsiVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable = (PsiVariable)resolve2;
        }
        if (variable != null && (rType = methodCall.getType()) != null && !variable.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !expectedTypeByApplicabilityConstraints.equals(rType)) {
            HighlightUtil.registerChangeVariableTypeFixes(variable, expectedTypeByApplicabilityConstraints, (PsiExpression)methodCall, highlightInfo);
        }
    }

    @Nullable
    private static String checkStaticInterfaceMethodCallQualifier(PsiReferenceExpression ref, PsiElement scope, PsiClass containingClass) {
        PsiExpression qualifierExpression2 = ref.getQualifierExpression();
        if (qualifierExpression2 == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
            return null;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve2 == containingClass) {
                return null;
            }
            if (resolve2 instanceof PsiTypeParameter) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                    PsiClass aClass = type2.resolve();
                    if (aClass == null) continue;
                    classes2.add(aClass);
                }
                if (classes2.size() == 1 && classes2.contains(containingClass)) {
                    return null;
                }
            }
        }
        return JavaErrorMessages.message("static.interface.method.call.qualifier", new Object[0]);
    }

    private static void registerMethodReturnFixAction(HighlightInfo highlightInfo, MethodCandidateInfo candidate, PsiCall methodCall) {
        PsiMethod containerMethod;
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)methodCall), (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    private static String buildOneLineMismatchDescription(@NotNull PsiExpressionList list2, @NotNull MethodCandidateInfo candidateInfo, @NotNull Ref<PsiElement> elementToHighlight) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        if (candidateInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateInfo", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        PsiExpression[] expressions2 = list2.getExpressions();
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
        if (expressions2.length == parameters2.length && parameters2.length > 1) {
            PsiExpression wrongArg;
            PsiType argType;
            int idx = -1;
            for (int i = 0; i < expressions2.length; ++i) {
                JavaResolveResult result2;
                PsiExpression expression2 = expressions2[i];
                if (expression2 instanceof PsiMethodCallExpression && (result2 = ((PsiCallExpression)expression2).resolveMethodGenerics()) instanceof MethodCandidateInfo && PsiUtil.isLanguageLevel8OrHigher((PsiElement)list2) && ((MethodCandidateInfo)result2).isToInferApplicability() && ((MethodCandidateInfo)result2).getInferenceErrorMessage() == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)substitutor.substitute(parameters2[i].getType()), (PsiExpression)expression2)) continue;
                if (idx != -1) {
                    idx = -1;
                    break;
                }
                idx = i;
            }
            if (idx > -1 && (argType = (wrongArg = expressions2[idx]).getType()) != null) {
                elementToHighlight.set((Object)wrongArg);
                String message2 = JavaErrorMessages.message("incompatible.call.types", idx + 1, substitutor.substitute(parameters2[idx].getType()).getCanonicalText(), argType.getCanonicalText());
                return XmlStringUtil.wrapInHtml((CharSequence)("<body>" + XmlStringUtil.escapeString((String)message2) + " <a href=\"#assignment/" + XmlStringUtil.escapeString((String)HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list2)) + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a></body>"));
            }
        }
        return null;
    }

    static boolean isDummyConstructorCall(PsiMethodCallExpression methodCall, PsiResolveHelper resolveHelper, PsiExpressionList list2, PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates;
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list2.getExpressions().length == 0 && (candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list2, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file2) {
        HighlightInfo info;
        String description;
        if (referenceToMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result2 : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result2 instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result2).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            return null;
        }
        PsiElement elementToHighlight = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod);
        if (element != null && !resolveResult.isAccessible()) {
            description = HighlightUtil.buildProblemWithAccessDescription((PsiElement)referenceToMethod, resolveResult);
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("static") && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface()) {
                info = HighlightUtil.checkFeature(elementToHighlight, HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file2);
                if (info != null) {
                    return info;
                }
                String description2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass);
                if (description2 != null) {
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description2).escapedToolTip(XmlStringUtil.escapeString((String)description2)).create();
                    QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAccessStaticViaInstanceFix(referenceToMethod, resolveResult));
                    return highlightInfo;
                }
            }
            description = HighlightUtil.buildProblemWithStaticDescription(element);
        } else {
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list2);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                highlightInfoType = HighlightInfoType.WRONG_REF;
            } else {
                return null;
            }
        }
        String toolTip = XmlStringUtil.escapeString((String)description);
        info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list2, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapLongWithMathToIntExactFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapLongWithMathToIntExactFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list2.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list2, info);
        return info;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list2, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description;
        if (referenceToMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result2 : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result2 instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result2).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)element1, (PsiSubstitutor)methodCandidate1.getSubstitutor(false), (int)4353, (int)2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)element2, (PsiSubstitutor)methodCandidate2.getSubstitutor(false), (int)4353, (int)2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)element1);
            if (!Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2)))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description = JavaErrorMessages.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list2);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString((String)description);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list2, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightUtil.registerAccessQuickFixAction((PsiMember)element, (PsiJavaCodeReferenceElement)referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapLongWithMathToIntExactFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapStringWithFileFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list2.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list2, info);
        return info;
    }

    @NotNull
    private static MethodCandidateInfo[] toMethodCandidates(@NotNull JavaResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "toMethodCandidates"));
        }
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result2 : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result2 instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result2).isAccessible()) continue;
            candidateList.add(candidate);
        }
        MethodCandidateInfo[] methodCandidateInfoArray = candidateList.toArray(new MethodCandidateInfo[candidateList.size()]);
        if (methodCandidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "toMethodCandidates"));
        }
        return methodCandidateInfoArray;
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, PsiMethodCallExpression methodCall, PsiExpressionList list2, PsiResolveHelper resolveHelper) {
        TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve2 instanceof PsiClass && ((PsiClass)resolve2).getContainingClass() != null && !((PsiClass)resolve2).hasModifierProperty("static")) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiClass)resolve2), "static", true, false));
            }
        } else if (qualifierExpression2 instanceof PsiSuperExpression && ((PsiSuperExpression)qualifierExpression2).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifierExpression2, highlightInfo);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromSuperFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromThisFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateGetterSetterPropertyFromUsageFix(methodCall));
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, methodCandidates, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapLongWithMathToIntExactFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapStringWithFileFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions(methodCandidates, methodCall, list2, highlightInfo);
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions((JavaResolveResult[])methodCandidates, list2, highlightInfo, fixRange);
        RemoveRedundantArgumentsFix.registerIntentions((JavaResolveResult[])methodCandidates, list2, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions((JavaResolveResult[])methodCandidates, list2, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list2.getExpressions(), highlightInfo);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list2, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list2)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, action);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo[] methodCandidates, PsiMethodCallExpression methodCall, PsiExpressionList exprList, HighlightInfo highlightInfo) {
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightUtil.registerAccessQuickFixAction((PsiMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo[] methodCandidates) {
        String string = JavaErrorMessages.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createAmbiguousMethodHtmlTooltip"));
        }
        return string;
    }

    private static String getContainingClassName(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiClass containingClass = method.getContainingClass();
        return containingClass == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
    }

    @Language(value="HTML")
    private static String createAmbiguousMethodHtmlTooltipMethodRow(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        String ms = "<td><b>" + method.getName() + "</b></td>";
        for (int j = 0; j < parameters2.length; ++j) {
            PsiParameter parameter = parameters2[j];
            PsiType type2 = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b>" + (j == 0 ? "(" : "") + XmlStringUtil.escapeString((String)type2.getPresentableText()) + (j == parameters2.length - 1 ? ")" : ",") + "</b></td>";
        }
        if (parameters2.length == 0) {
            ms = ms + "<td><b>()</b></td>";
        }
        return ms;
    }

    private static String createMismatchedArgumentsHtmlTooltip(MethodCandidateInfo info, PsiExpressionList list2) {
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiClass aClass = method.getContainingClass();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        String methodName = method.getName();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor, aClass);
    }

    private static String createShortMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, @Nullable MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        PsiExpression[] expressions2 = list2.getExpressions();
        int cols = Math.max(parameters2.length, expressions2.length);
        String parensizedName = methodName + (parameters2.length == 0 ? "(&nbsp;)&nbsp;" : "");
        String errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        return JavaErrorMessages.message("argument.mismatch.html.tooltip", cols - parameters2.length + 1, parensizedName, HighlightUtil.formatClass(aClass, false), HighlightMethodUtil.createMismatchedArgsHtmlTooltipParamsRow(parameters2, substitutor, expressions2), HighlightMethodUtil.createMismatchedArgsHtmlTooltipArgumentsRow(expressions2, parameters2, substitutor, cols), errorMessage != null ? "<br/>reason: " + XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>") : "");
    }

    private static String esctrim(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "esctrim"));
        }
        return XmlStringUtil.escapeString((String)HighlightMethodUtil.trimNicely(s));
    }

    private static String trimNicely(String s) {
        if (s.length() <= 40) {
            return s;
        }
        List wordIndices = StringUtil.getWordIndicesIn((String)s);
        if (wordIndices.size() > 2) {
            int firstWordEnd = ((TextRange)wordIndices.get(0)).getEndOffset();
            for (int i = 1; i < wordIndices.size(); ++i) {
                int stringLength = firstWordEnd + s.length() - ((TextRange)wordIndices.get(i)).getStartOffset();
                if (stringLength > 40) continue;
                return s.substring(0, firstWordEnd) + "..." + s.substring(((TextRange)wordIndices.get(i)).getStartOffset());
            }
        }
        if (!wordIndices.isEmpty() && s.length() - ((TextRange)wordIndices.get(wordIndices.size() - 1)).getStartOffset() <= 40) {
            return "..." + s.substring(((TextRange)wordIndices.get(wordIndices.size() - 1)).getStartOffset());
        }
        return StringUtil.last((CharSequence)s, (int)40, (boolean)true).toString();
    }

    private static String createMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        return Math.max(parameters2.length, list2.getExpressions().length) <= 2 ? HighlightMethodUtil.createShortMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor, aClass) : HighlightMethodUtil.createLongMismatchedArgumentsHtmlTooltip(list2, info, parameters2, methodName, substitutor, aClass);
    }

    @Language(value="HTML")
    private static String createLongMismatchedArgumentsHtmlTooltip(PsiExpressionList list2, @Nullable MethodCandidateInfo info, PsiParameter[] parameters2, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        String errorMessage;
        PsiExpression[] expressions2 = list2.getExpressions();
        String s = "<html><body><table border=0><tr><td colspan=3><nobr><b>" + methodName + "()</b> in <b>" + HighlightUtil.formatClass(aClass, false) + "</b> cannot be applied to:</nobr></td></tr><tr><td colspan=2 align=left>Expected<br>Parameters:</td><td align=left>Actual<br>Arguments:</td></tr><tr><td colspan=3><hr></td></tr>";
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            PsiType type2;
            String name2;
            PsiParameter parameter = i < parameters2.length ? parameters2[i] : null;
            PsiExpression expression2 = i < expressions2.length ? expressions2[i] : null;
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor);
            String mismatchColor = showShort ? null : (UIUtil.isUnderDarcula() ? "FF6B68" : "red");
            s = s + "<tr" + (i % 2 == 0 ? " style='background-color: #" + (UIUtil.isUnderDarcula() ? ColorUtil.toHex((Color)ColorUtil.shift((Color)UIUtil.getToolTipBackground(), (double)1.1)) : "eeeeee") + "'" : "") + ">";
            s = s + "<td><b><nobr>";
            if (parameter != null && (name2 = parameter.getName()) != null) {
                s = s + HighlightMethodUtil.esctrim(name2) + ":";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (parameter != null) {
                type2 = substitutor.substitute(parameter.getType());
                s = s + "<font " + (mismatchColor == null ? "" : "color=" + mismatchColor) + ">" + HighlightMethodUtil.esctrim(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2)) + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (expression2 != null) {
                type2 = expression2.getType();
                s = s + "<font " + (mismatchColor == null ? "" : "color='" + mismatchColor + "'") + ">" + HighlightMethodUtil.esctrim(expression2.getText()) + "&nbsp;&nbsp;" + (mismatchColor == null || type2 == null || type2 == PsiType.NULL ? "" : "(" + HighlightMethodUtil.esctrim(JavaHighlightUtil.formatType(type2)) + ")") + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "</tr>";
        }
        s = s + "</table>";
        String string = errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        if (errorMessage != null) {
            s = s + "reason: ";
            s = s + XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>");
        }
        s = s + "</body></html>";
        return s;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipArgumentsRow(PsiExpression[] expressions2, PsiParameter[] parameters2, PsiSubstitutor substitutor, int cols) {
        int i;
        String ms = "";
        for (i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiType type2 = expression2.getType();
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor);
            String mismatchColor = showShort ? null : MISMATCH_COLOR;
            ms = ms + "<td> <b><nobr>" + (i == 0 ? "(" : "") + "<font " + (showShort ? "" : "color=" + mismatchColor) + ">" + XmlStringUtil.escapeString((String)(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2))) + "</font>" + (i == expressions2.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        for (i = expressions2.length; i < cols + 1; ++i) {
            ms = ms + "<td>" + (i == 0 ? "<b>()</b>" : "") + "&nbsp;</td>";
        }
        return ms;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipParamsRow(PsiParameter[] parameters2, PsiSubstitutor substitutor, PsiExpression[] expressions2) {
        String ms = "";
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter = parameters2[i];
            PsiType type2 = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b><nobr>" + (i == 0 ? "(" : "") + XmlStringUtil.escapeString((String)(HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor) ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2))) + (i == parameters2.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        return ms;
    }

    private static boolean showShortType(int i, PsiParameter[] parameters2, PsiExpression[] expressions2, PsiSubstitutor substitutor) {
        PsiExpression expression2;
        PsiExpression psiExpression = expression2 = i < expressions2.length ? expressions2[i] : null;
        if (expression2 == null) {
            return true;
        }
        PsiType paramType = i < parameters2.length && parameters2[i] != null ? substitutor.substitute(parameters2[i].getType()) : null;
        PsiType expressionType = expression2.getType();
        return paramType != null && expressionType != null && TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)expressionType);
    }

    static HighlightInfo checkMethodMustHaveBody(PsiMethod method, PsiClass aClass) {
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild((PsiElement)method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null && !(aClass instanceof PsiAnonymousClass)) {
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", true, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(PsiMethod method, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            String description = JavaErrorMessages.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(PsiMethod method) {
        String methodName = method.getName();
        PsiClass aClass = method.getContainingClass();
        HighlightInfo errorResult = null;
        if (aClass != null) {
            String className;
            String string = className = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (className == null || !Comparing.strEqual((String)methodName, (String)className)) {
                PsiIdentifier element = method.getNameIdentifier();
                String description = JavaErrorMessages.message("missing.return.type", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
                if (className != null) {
                    QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)method, className));
                }
            }
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkDuplicateMethod(PsiClass aClass, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkDuplicateMethod"));
        }
        if (duplicateMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicateMethods", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkDuplicateMethod"));
        }
        if (aClass == null || method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods = (List)duplicateMethods.get((Object)methodSignature);
        if (methods.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description = JavaErrorMessages.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCanHaveBody"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCanHaveBody"));
        }
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<Object> additionalFixes = new ArrayList<Object>();
        String description = null;
        if (hasNoBody) {
            if (isExtension) {
                description = JavaErrorMessages.message("extension.method.should.have.a.body", new Object[0]);
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            } else if (isInterface) {
                if (isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    description = "Static methods in interfaces should have a body";
                } else if (isPrivate && languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                    description = "Private methods in interfaces should have a body";
                }
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description = JavaErrorMessages.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", true, false));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description = JavaErrorMessages.message("extension.method.in.class", new Object[0]);
        } else if (method.hasModifierProperty("abstract")) {
            description = JavaErrorMessages.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description = JavaErrorMessages.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        if (!hasNoBody) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction(info, intentionAction);
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkConstructorCallMustBeFirstStatement(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCallMustBeFirstStatement"));
        }
        if (!RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && codeBlock.getParent() instanceof PsiMethod && ((PsiMethod)codeBlock.getParent()).isConstructor()) {
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression2 = methodCall.getMethodExpression();
        String message2 = JavaErrorMessages.message("constructor.call.must.be.first.statement", expression2.getText() + "()");
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message2).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperAbstractMethodDirectCall"));
        }
        PsiReferenceExpression expression2 = methodCallExpression.getMethodExpression();
        if (!(expression2.getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message2 = JavaErrorMessages.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)methodCallExpression).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(PsiMethod constructor, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return null;
        }
        PsiElement element = new PsiMatcherImpl((PsiElement)body2).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).getElement();
        if (element != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createInsertThisFix(constructor));
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createAddDefaultConstructorFix(aClass.getSuperClass()));
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(PsiClass aClass, PsiMethod method, boolean isMethodStatic, PsiClass superClass, PsiMethod superMethod, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (superMethod == null) {
            return null;
        }
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description = JavaErrorMessages.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject((PsiElement)superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "static", isMethodStatic, true));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(@NotNull List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, @NotNull LanguageLevel languageLevel) {
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkInterfaceInheritedMethodsReturnTypes"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkInterfaceInheritedMethodsReturnTypes"));
        }
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable[0], (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            HighlightInfo info = (HighlightInfo)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])otherSuperMethod.getTypeParameters(), (PsiSubstitutor)otherSubstitutor, () -> {
                if (languageLevel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "lambda$checkInterfaceInheritedMethodsReturnTypes$1"));
                }
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric((PsiType)otherReturnType, (PsiType)curType)) {
                        return null;
                    }
                }
                return HighlightMethodUtil.createIncompatibleReturnTypeMessage(otherSuperMethod, currentMethod, curType, otherReturnType, JavaErrorMessages.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
            });
            if (info == null) continue;
            return info;
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(PsiClass aClass, PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkOverrideEquivalentInheritedMethods"));
        }
        String description = null;
        boolean appendImplementMethodFix = true;
        Collection visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, (List<HierarchicalMethodSignature>)superSignatures, false);
            }
            if (highlightInfo != null) {
                description = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    description = JavaErrorMessages.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
                    appendImplementMethodFix = false;
                    break block0;
                }
                continue;
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, aClass)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, containingFile)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null) continue;
            break;
        }
        if (description != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (appendImplementMethodFix) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(PsiMethod method) {
        PsiStatement[] statements;
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body2 = method.getBody();
        PsiStatement[] psiStatementArray = statements = body2 == null ? null : body2.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkRecursiveConstructorInvocation"));
        }
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description = JavaErrorMessages.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof PsiJavaToken && ((PsiJavaToken)nextSibling).getTokenType() == JavaTokenType.SEMICOLON) {
            TextRange textRange = new TextRange(start, end + 1);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
        }
        return textRange;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression2, PsiType type2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, (PsiConstructorCall)expression2, type2, classReference2, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type2, PsiJavaCodeReferenceElement classReference2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        if (typeResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (constructorCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        PsiExpressionList list2 = constructorCall.getArgumentList();
        if (list2 == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference2 != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            String description = HighlightUtil.buildProblemWithAccessDescription((PsiElement)classReference2, (JavaResolveResult)typeResolveResult);
            PsiElement element = classReference2.getReferenceNameElement();
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            HighlightUtil.registerAccessQuickFixAction((PsiMember)aClass, classReference2, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (list2.getExpressions().length != 0) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                String description = JavaErrorMessages.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list2, null, PsiParameter.EMPTY_ARRAY, constructorName, PsiSubstitutor.EMPTY, aClass);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list2).description(description).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
                if (classReference2 != null) {
                    ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list2));
                }
                holder.add(info);
                return;
            }
            if (classReference2 != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (JavaResolveResult)typeResolveResult, (PsiMember)aClass));
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeArgumentList).descriptionAndTooltip("Anonymous class implements interface; cannot have type arguments").create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiExpressionList infoElement;
            PsiAnonymousClass anonymousClass;
            PsiExpressionList place = list2;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list2, (PsiElement)place);
            MethodCandidateInfo result2 = null;
            if (results.length == 1) {
                result2 = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result2 == null ? null : result2.getElement();
            boolean applicable = true;
            try {
                JavaResolveResult staticFactory;
                PsiDiamondType diamondType = constructorCall instanceof PsiNewExpression ? PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)constructorCall)) : null;
                JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
                applicable = staticFactory instanceof MethodCandidateInfo ? ((MethodCandidateInfo)staticFactory).isApplicable() : result2 != null && result2.isApplicable();
            }
            catch (IndexNotReadyException diamondType) {
                // empty catch block
            }
            Object object = infoElement = list2.getTextLength() > 0 ? list2 : constructorCall;
            if (constructor == null) {
                String name2 = aClass.getName();
                name2 = name2 + HighlightMethodUtil.buildArgTypesList(list2);
                String description = JavaErrorMessages.message("cannot.resolve.constructor", name2);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list2).descriptionAndTooltip(description).navigationShift(1).create();
                if (info2 != null) {
                    WrapExpressionFix.registerWrapAction(results, list2.getExpressions(), info2);
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list2, aClass, constructors, results, (PsiElement)infoElement, info2);
                    holder.add(info2);
                }
            } else if (classReference2 != null && (!result2.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (JavaResolveResult)result2, (PsiMember)constructor));
            } else if (!applicable) {
                String constructorName = HighlightMessageUtil.getSymbolName((PsiElement)constructor, result2.getSubstitutor());
                String containerName = HighlightMessageUtil.getSymbolName((PsiElement)constructor.getContainingClass(), result2.getSubstitutor());
                String argTypes = HighlightMethodUtil.buildArgTypesList(list2);
                String description = JavaErrorMessages.message("wrong.method.arguments", constructorName, containerName, argTypes);
                String toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(result2, list2);
                HighlightInfo info3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)infoElement).description(description).escapedToolTip(toolTip).navigationShift(1).create();
                if (info3 != null) {
                    JavaResolveResult[] methodCandidates = results;
                    if (constructorCall instanceof PsiNewExpression) {
                        methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)constructorCall, true);
                    }
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list2, aClass, constructors, methodCandidates, (PsiElement)infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result2, (PsiCall)constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result2.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result2 != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result2, (PsiCall)constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(MethodCandidateInfo info, PsiCall place) {
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)place)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters2[parameters2.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure((PsiType)info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible((PsiMember)targetClass, (PsiElement)place, null)) {
                PsiExpressionList argumentList = place.getArgumentList();
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Formal varargs element type " + PsiFormatUtil.formatClass((PsiClass)targetClass, (int)2048) + " is inaccessible here").range((PsiElement)(argumentList != null ? argumentList : place)).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(PsiConstructorCall constructorCall, PsiJavaCodeReferenceElement classReference2, PsiExpressionList list2, PsiClass aClass, PsiMethod[] constructors, JavaResolveResult[] results, PsiElement infoElement, @NotNull HighlightInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerFixesOnInvalidConstructorCall"));
        }
        QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
        if (classReference2 != null) {
            ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list2, info, aClass);
            ConvertDoubleToFloatFix.registerIntentions(results, list2, info, null);
        }
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list2, info, null);
        PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list2));
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)constructorCall, list2, info);
        QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange((PsiElement)list2), QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement classReference2, JavaResolveResult result2, PsiMember elementToFix) {
        if (classReference2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildAccessProblem"));
        }
        String description = HighlightUtil.buildProblemWithAccessDescription((PsiElement)classReference2, result2);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)classReference2).descriptionAndTooltip(description).navigationShift(1).create();
        if (result2.isStaticsScopeCorrect()) {
            HighlightUtil.registerAccessQuickFixAction(elementToFix, classReference2, info, result2.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(PsiConstructorCall place, PsiClass constructorClass) {
        PsiClass aClass;
        if (constructorClass == null) {
            return false;
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    private static String buildArgTypesList(PsiExpressionList list2) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list2.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list2, HighlightInfo highlightInfo) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeParameterClassFix"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeParameterClassFix"));
        }
        JavaResolveResult result2 = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result2.getElement();
        PsiSubstitutor substitutor = result2.getSubstitutor();
        PsiExpression[] expressions2 = list2.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions2.length) {
            return;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiParameter parameter = parameters2[i];
            PsiType expressionType = expression2.getType();
            PsiType parameterType = substitutor.substitute(parameter.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list2, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntentions"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntentions"));
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list2.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list2);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(@NotNull PsiExpression[] expressions2, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            IntentionAction fix = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, fix);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, f2);
        }
    }
}

