/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class XmlDefaultAttributeValueInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                PsiElement parent = value2.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                if (parent.getParent() instanceof HtmlTag) {
                    return;
                }
                XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
                if (descriptor == null) {
                    return;
                }
                String defaultValue = descriptor.getDefaultValue();
                if (defaultValue != null && defaultValue.equals(value2.getValue())) {
                    holder.registerProblem((PsiElement)value2, "Redundant default attribute value assignment", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new LocalQuickFix(){

                        @Nls
                        @NotNull
                        public String getFamilyName() {
                            String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "getFamilyName"));
                            }
                            return string;
                        }

                        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                            if (project2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "applyFix"));
                            }
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "applyFix"));
                            }
                            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class);
                            if (attribute != null) {
                                attribute.delete();
                            }
                        }
                    }});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

