/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRequiredModuleFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myRequiredName;

    public AddRequiredModuleFix(PsiJavaModule module2, String requiredName) {
        super((PsiElement)module2);
        this.myRequiredName = requiredName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("module.info.add.requires.name", this.myRequiredName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("module.info.add.requires.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel9OrHigher((PsiElement)file2) && startElement instanceof PsiJavaModule && startElement.getManager().isInProject(startElement) && AddRequiredModuleFix.getLBrace((PsiJavaModule)startElement) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        PsiJavaModule module2 = (PsiJavaModule)startElement;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)project2).getParserFacade();
        PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + module2.getName() + " { requires " + this.myRequiredName + "; }");
        Iterable tempModuleRequires = tempModule.getRequires();
        PsiRequiresStatement requiresStatement = (PsiRequiresStatement)tempModuleRequires.iterator().next();
        PsiElement addingPlace = AddRequiredModuleFix.findAddingPlace(module2);
        if (addingPlace != null) {
            addingPlace.getParent().addAfter((PsiElement)requiresStatement, addingPlace);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement findAddingPlace(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "findAddingPlace"));
        }
        PsiElement addingPlace = (PsiElement)ContainerUtil.iterateAndGetLastItem((Iterable)module2.getRequires());
        return addingPlace != null ? addingPlace : AddRequiredModuleFix.getLBrace(module2);
    }

    @Nullable
    private static PsiElement getLBrace(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getLBrace"));
        }
        PsiJavaModuleReferenceElement nameElement = module2.getNameIdentifier();
        for (PsiElement element = nameElement.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.LBRACE)) continue;
            return element;
        }
        return null;
    }
}

