/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix");
    public static ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(PsiExpressionList list2, int i2, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list2, i2, toType, factory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix", "getText"));
        }
        return string;
    }

    @Nullable
    public static PsiExpression addTypeArguments(PsiExpression expression2, PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
            return null;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceParameterList list2 = methodCall.getMethodExpression().getParameterList();
            if (list2 == null || list2.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0) {
                    PsiType[] mappings = PsiType.createArray((int)typeParameters.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression2);
                    for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                        PsiType substitution;
                        PsiTypeParameter typeParameter = typeParameters[i2];
                        PsiType psiType = substitution = toType == null ? resolveResult.getSubstitutor().substitute(typeParameter) : helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        if (substitution == null || PsiType.NULL.equals((Object)substitution)) {
                            return null;
                        }
                        mappings[i2] = GenericsUtil.eliminateWildcards((PsiType)substitution, (boolean)false);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression2.getProject()).getElementFactory();
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression2.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiType mapping : mappings) {
                        parameterList.add((PsiElement)factory.createTypeElement(mapping));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        LOG.assertTrue(containingClass != null);
                        Object qualifierExpression2 = method.hasModifierProperty("static") ? factory.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression(method.getManager(), null);
                        methodExpression.setQualifierExpression((PsiExpression)qualifierExpression2);
                    }
                    return (PsiExpression)JavaCodeStyleManager.getInstance((Project)copy.getProject()).shortenClassReferences((PsiElement)copy);
                }
            }
        }
        return null;
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public AddTypeArgumentsFix createFix(PsiExpressionList list2, int i2, PsiType toType) {
            return new AddTypeArgumentsFix(list2, i2, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return AddTypeArgumentsFix.addTypeArguments(expression2, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType) || TypeConversionUtil.boxingConversionApplicable((PsiType)exprType, (PsiType)parameterType);
        }
    }
}

