/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentFixerActionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory");

    @Nullable
    protected abstract PsiExpression getModifiedArgument(PsiExpression var1, PsiType var2) throws IncorrectOperationException;

    public void registerCastActions(@NotNull CandidateInfo[] candidates, @NotNull PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        PsiType parameterType;
        int i2;
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory", "registerCastActions"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory", "registerCastActions"));
        }
        if (candidates.length == 0) {
            return;
        }
        ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
        PsiExpressionList list2 = call.getArgumentList();
        if (list2 == null) {
            return;
        }
        PsiExpression[] expressions2 = list2.getExpressions();
        if (expressions2.length == 0) {
            return;
        }
        block2: for (i2 = methodCandidates.size() - 1; i2 >= 0; --i2) {
            CandidateInfo candidate = (CandidateInfo)methodCandidates.get(i2);
            PsiMethod method = (PsiMethod)candidate.getElement();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (expressions2.length != parameters2.length && !method.isVarArgs()) {
                methodCandidates.remove(i2);
                continue;
            }
            for (int j = 0; j < Math.min(parameters2.length, expressions2.length); ++j) {
                PsiParameter parameter = parameters2[j];
                PsiExpression expression2 = expressions2[j];
                PsiType exprType = expression2.getType();
                parameterType = substitutor.substitute(parameter.getType());
                if (exprType != null && parameterType != null && this.areTypesConvertible(exprType, parameterType, (PsiElement)call)) continue;
                methodCandidates.remove(i2);
                continue block2;
            }
        }
        if (methodCandidates.isEmpty()) {
            return;
        }
        try {
            for (i2 = 0; i2 < expressions2.length; ++i2) {
                PsiExpression expression3 = expressions2[i2];
                PsiType exprType = expression3.getType();
                THashSet suggestedCasts = new THashSet();
                for (CandidateInfo candidate : methodCandidates) {
                    PsiExpressionList argumentList;
                    PsiPrimitiveType unboxedParameterType;
                    PsiType originalParameterType;
                    PsiMethod method = (PsiMethod)candidate.getElement();
                    PsiSubstitutor substitutor = candidate.getSubstitutor();
                    parameterType = substitutor.substitute(originalParameterType = PsiTypesUtil.getParameterType((PsiParameter[])method.getParameterList().getParameters(), (int)i2, (boolean)true));
                    if (parameterType instanceof PsiWildcardType || !GenericsUtil.isFromExternalTypeLanguage((PsiType)parameterType) || suggestedCasts.contains(parameterType.getCanonicalText())) continue;
                    if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType && (unboxedParameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) != null) {
                        parameterType = unboxedParameterType;
                    }
                    if (Comparing.equal((Object)exprType, (Object)parameterType)) continue;
                    PsiCall newCall = (PsiCall)call.copy();
                    PsiExpression modifiedExpression = this.getModifiedArgument(expression3, parameterType);
                    if (modifiedExpression == null || (argumentList = newCall.getArgumentList()) == null) continue;
                    argumentList.getExpressions()[i2].replace((PsiElement)modifiedExpression);
                    JavaResolveResult resolveResult = newCall.resolveMethodGenerics();
                    if (resolveResult.getElement() == null || !resolveResult.isValidResult()) continue;
                    suggestedCasts.add(parameterType.getCanonicalText());
                    QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, this.createFix(list2, i2, parameterType));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public abstract boolean areTypesConvertible(@NotNull PsiType var1, @NotNull PsiType var2, @NotNull PsiElement var3);

    public abstract MethodArgumentFix createFix(PsiExpressionList var1, int var2, PsiType var3);
}

