/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeStringLiteralToCharInMethodCallFix
implements IntentionAction {
    private final PsiLiteralExpression myLiteral;
    private final PsiCall myCall;

    public ChangeStringLiteralToCharInMethodCallFix(PsiLiteralExpression literal, PsiCall methodCall) {
        this.myLiteral = literal;
        this.myCall = methodCall;
    }

    @NotNull
    public String getText() {
        String convertedValue = this.convertedValue();
        boolean isString = ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType());
        String string = QuickFixBundle.message("fix.single.character.string.to.char.literal.text", this.myLiteral.getText(), ChangeStringLiteralToCharInMethodCallFix.quote(convertedValue, !isString), isString ? PsiType.CHAR.getCanonicalText() : "String");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.single.character.string.to.char.literal.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "isAvailable"));
        }
        return this.myCall.isValid() && this.myLiteral.isValid() && this.myCall.getManager().isInProject((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "invoke"));
        }
        Object value2 = this.myLiteral.getValue();
        if (value2 != null && value2.toString().length() == 1) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression newExpression = factory.createExpressionFromText(ChangeStringLiteralToCharInMethodCallFix.quote(this.convertedValue(), !ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType())), this.myLiteral.getParent());
            this.myLiteral.replace((PsiElement)newExpression);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static String quote(String value2, boolean doubleQuotes) {
        char quote = doubleQuotes ? (char)'\"' : '\'';
        return quote + value2 + quote;
    }

    private String convertedValue() {
        String value2 = String.valueOf(this.myLiteral.getValue());
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters((int)value2.length(), (String)value2, (String)"\"'", (StringBuilder)builder);
        return builder.toString();
    }

    public static void registerFixes(@NotNull PsiMethod[] candidates, @NotNull PsiConstructorCall call, @NotNull HighlightInfo out) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "registerFixes"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "registerFixes"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "registerFixes"));
        }
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        if (call.getArgumentList() == null) {
            return;
        }
        boolean exactMatch = false;
        for (PsiMethod method : candidates) {
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(call.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)call, out);
        }
    }

    public static void registerFixes(@NotNull CandidateInfo[] candidates, @NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo info) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "registerFixes"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "registerFixes"));
        }
        if (info == null) {
            return;
        }
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        boolean exactMatch = false;
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)candidate).getElement();
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(methodCall.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)methodCall, info);
        }
    }

    private static void processLiterals(@NotNull Set<PsiLiteralExpression> literals, @NotNull PsiCall call, @NotNull HighlightInfo info) {
        if (literals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literals", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "processLiterals"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "processLiterals"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix", "processLiterals"));
        }
        for (PsiLiteralExpression literal : literals) {
            ChangeStringLiteralToCharInMethodCallFix fix = new ChangeStringLiteralToCharInMethodCallFix(literal, call);
            QuickFixAction.registerQuickFixAction(info, fix);
        }
    }

    private static boolean findMatchingExpressions(PsiExpression[] arguments, PsiMethod existingMethod, Set<PsiLiteralExpression> result2) {
        PsiParameterList parameterList = existingMethod.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (arguments.length != parameters2.length) {
            return false;
        }
        boolean typeMatch = true;
        for (int i2 = 0; i2 < parameters2.length && i2 < arguments.length; ++i2) {
            String value2;
            PsiParameter parameter = parameters2[i2];
            PsiType parameterType = parameter.getType();
            PsiType argumentType = arguments[i2].getType();
            typeMatch &= Comparing.equal((Object)parameterType, (Object)argumentType);
            if (!(arguments[i2] instanceof PsiLiteralExpression) || result2.contains(arguments[i2]) || !ChangeStringLiteralToCharInMethodCallFix.charToString(parameterType, argumentType) && !ChangeStringLiteralToCharInMethodCallFix.charToString(argumentType, parameterType) || (value2 = String.valueOf(((PsiLiteralExpression)arguments[i2]).getValue())) == null || value2.length() != 1) continue;
            result2.add((PsiLiteralExpression)arguments[i2]);
        }
        return typeMatch;
    }

    private static boolean charToString(PsiType firstType, PsiType secondType) {
        return Comparing.equal((Object)PsiType.CHAR, (Object)firstType) && ChangeStringLiteralToCharInMethodCallFix.isString(secondType);
    }

    private static boolean isString(PsiType type2) {
        return type2 != null && type2.equalsToText("java.lang.String");
    }
}

