/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateStaticMethodQuickFix
implements LocalQuickFix {
    @NotNull
    private final PsiClass targetClass;
    @NotNull
    private final String methodName;
    @NotNull
    private final List<String> types;

    public CreateStaticMethodQuickFix(@NotNull PsiClass aClass, @NotNull String name2, @NotNull List<String> types) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "<init>"));
        }
        this.targetClass = aClass;
        this.methodName = name2;
        this.types = types;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiMethod method;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "applyFix"));
        }
        boolean java8Interface = false;
        if (this.targetClass.isInterface()) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.targetClass)) {
                java8Interface = true;
            } else {
                return;
            }
        }
        if ((method = CreateMethodFromUsageFix.createMethod(this.targetClass, null, null, this.methodName)) == null) {
            return;
        }
        if (!java8Interface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        List args = ContainerUtil.map(this.types, s -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix", "lambda$applyFix$0"));
            }
            return new Pair(null, (Object)PsiType.getTypeByName((String)s, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2)));
        });
        CreateMethodFromUsageFix.doCreate(this.targetClass, method, false, args, PsiSubstitutor.UNKNOWN, ExpectedTypeInfo.EMPTY_ARRAY, null);
    }
}

