/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImportClassFix
extends ImportClassFixBase<PsiJavaCodeReferenceElement, PsiJavaCodeReferenceElement> {
    public ImportClassFix(@NotNull PsiJavaCodeReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "<init>"));
        }
        super(element, element);
    }

    @Override
    protected String getReferenceName(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "getReferenceName"));
        }
        return reference.getReferenceName();
    }

    @Override
    protected PsiElement getReferenceNameElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "getReferenceNameElement"));
        }
        return reference.getReferenceNameElement();
    }

    @Override
    protected void bindReference(PsiReference ref, PsiClass targetClass) {
        if (ref instanceof PsiImportStaticReferenceElement) {
            ((PsiImportStaticReferenceElement)ref).bindToTargetClass(targetClass);
        } else {
            super.bindReference(ref, targetClass);
        }
    }

    @Override
    protected boolean hasTypeParameters(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "hasTypeParameters"));
        }
        PsiReferenceParameterList refParameters = reference.getParameterList();
        return refParameters != null && refParameters.getTypeParameterElements().length > 0;
    }

    @Override
    protected String getQualifiedName(PsiJavaCodeReferenceElement reference) {
        return reference.getQualifiedName();
    }

    @Override
    protected boolean isQualified(PsiJavaCodeReferenceElement reference) {
        return reference.isQualified();
    }

    @Override
    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name2) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiImportStatement[] importStatements;
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiImportList importList = ((PsiJavaFile)psiFile).getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
            String className;
            if (importStatement.resolve() != null) continue;
            if (importStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStatement.getQualifiedName();
            String string = className = qualifiedName == null ? null : ClassUtil.extractClassName((String)qualifiedName);
            if (!Comparing.strEqual((String)className, (String)name2)) continue;
            return true;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            if (importStaticStatement.resolve() != null) continue;
            if (importStaticStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStaticStatement.getReferenceName();
            if (qualifiedName == null || !StringUtil.split((String)qualifiedName, (String)".").contains(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getRequiredMemberName(PsiJavaCodeReferenceElement reference) {
        PsiElement parent = reference.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement) {
            return ((PsiJavaCodeReferenceElement)parent).getReferenceName();
        }
        return super.getRequiredMemberName(reference);
    }

    @Override
    protected boolean canReferenceClass(PsiJavaCodeReferenceElement ref) {
        if (ref instanceof PsiReferenceExpression) {
            PsiElement parent = ref.getParent();
            return parent instanceof PsiReferenceExpression || parent instanceof PsiExpressionStatement;
        }
        return true;
    }

    @Override
    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull PsiJavaCodeReferenceElement ref) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
        }
        if (ref instanceof PsiReferenceExpression) {
            List<PsiClass> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
            }
            return list2;
        }
        PsiElement typeElement = ref.getParent();
        if (typeElement instanceof PsiTypeElement) {
            PsiExpression initializer;
            PsiElement var = typeElement.getParent();
            if (var instanceof PsiVariable && (initializer = ((PsiVariable)var).getInitializer()) != null) {
                List<PsiClass> list3 = ImportClassFix.filterAssignableFrom(initializer.getType(), candidates);
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
                }
                return list3;
            }
            if (var instanceof PsiParameter) {
                List<PsiClass> list4 = ImportClassFix.filterBySuperMethods((PsiParameter)var, candidates);
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
                }
                return list4;
            }
        }
        List<PsiClass> list5 = super.filterByContext(candidates, ref);
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix", "filterByContext"));
        }
        return list5;
    }

    @Override
    protected boolean isAccessible(PsiMember member, PsiJavaCodeReferenceElement reference) {
        return PsiUtil.isAccessible((PsiMember)member, (PsiElement)reference, null);
    }
}

