/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.InsertConstructorCallFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class InsertThisFix
extends InsertConstructorCallFix {
    public InsertThisFix(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InsertThisFix", "<init>"));
        }
        super(constructor, "this();");
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InsertThisFix", "isAvailable"));
        }
        return super.isAvailable(project2, editor, file2) && this.hasConstructorToDelegate();
    }

    private boolean hasConstructorToDelegate() {
        PsiClass containingClass = this.myConstructor.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return Arrays.stream(containingClass.getConstructors()).anyMatch(constructor -> constructor != this.myConstructor);
    }
}

