/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveRedundantArgumentsFix
implements IntentionAction {
    private final PsiMethod myTargetMethod;
    private final PsiExpression[] myArguments;
    private final PsiSubstitutor mySubstitutor;

    private RemoveRedundantArgumentsFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor substitutor) {
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "<init>"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "<init>"));
        }
        this.myTargetMethod = targetMethod;
        this.myArguments = arguments;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.redundant.arguments.text", JavaHighlightUtil.formatMethod(this.myTargetMethod));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.redundant.arguments.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "isAvailable"));
        }
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return false;
        }
        for (PsiExpression expression2 : this.myArguments) {
            if (expression2.isValid()) continue;
            return false;
        }
        if (!this.mySubstitutor.isValid()) {
            return false;
        }
        return RemoveRedundantArgumentsFix.findRedundantArgument(this.myArguments, this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor) != null;
    }

    @Nullable
    private static PsiExpression[] findRedundantArgument(@NotNull PsiExpression[] arguments, @NotNull PsiParameter[] parameters2, @NotNull PsiSubstitutor substitutor) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "findRedundantArgument"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "findRedundantArgument"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "findRedundantArgument"));
        }
        if (arguments.length <= parameters2.length) {
            return null;
        }
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiExpression argument = arguments[i2];
            PsiParameter parameter = parameters2[i2];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return null;
            }
            PsiType parameterType = substitutor.substitute(parameter.getType());
            if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argumentType)) continue;
            return null;
        }
        return Arrays.copyOfRange(arguments, parameters2.length, arguments.length);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "invoke"));
        }
        PsiExpression[] redundantArguments = RemoveRedundantArgumentsFix.findRedundantArgument(this.myArguments, this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor);
        if (redundantArguments != null) {
            for (PsiExpression argument : redundantArguments) {
                argument.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList arguments, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "registerIntentions"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "registerIntentions"));
        }
        for (JavaResolveResult candidate : candidates) {
            RemoveRedundantArgumentsFix.registerIntention(arguments, highlightInfo, fixRange, candidate, (PsiElement)arguments);
        }
    }

    private static void registerIntention(@NotNull PsiExpressionList arguments, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "registerIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "registerIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix", "registerIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new RemoveRedundantArgumentsFix(method, arguments.getExpressions(), substitutor));
        }
    }
}

