/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportConstantFix
extends StaticImportMemberFix<PsiField> {
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRef;

    public StaticImportConstantFix(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "<init>"));
        }
        this.myRef = SmartPointerManager.getInstance((Project)referenceElement.getProject()).createSmartPsiElementPointer((PsiElement)referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        if ("Import static constant" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "getBaseText"));
        }
        return "Import static constant";
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiField field) {
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "getMemberPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected List<PsiField> getMembersToImport(boolean applicableOnly) {
        String name2;
        Project project2 = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        String string = name2 = element != null ? element.getReferenceName() : null;
        if (name2 == null) {
            List<PsiField> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "getMembersToImport"));
            }
            return list2;
        }
        if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)) || element.getParent() instanceof PsiTypeElement || element.getParent() instanceof PsiAnnotation) {
            List<PsiField> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "getMembersToImport"));
            }
            return list3;
        }
        StaticMembersProcessor<PsiField> processor2 = new StaticMembersProcessor<PsiField>((PsiElement)element){

            @Override
            protected boolean isApplicable(PsiField field, PsiElement place) {
                PsiType expectedType = this.getExpectedType();
                return expectedType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)field.getType());
            }
        };
        cache.processFieldsWithName(name2, (Processor)processor2, element.getResolveScope(), null);
        List<PsiField> list4 = processor2.getMembersToImport(applicableOnly);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "getMembersToImport"));
        }
        return list4;
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(List<PsiField> methodsToImport, @NotNull Project project2, Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "createQuestionAction"));
        }
        StaticImportMethodQuestionAction<PsiField> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiField>(project2, editor, methodsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                String string = QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix$2", "getPopupTitle"));
                }
                return string;
            }
        };
        if (staticImportMethodQuestionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix", "createQuestionAction"));
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        return element != null ? element.getQualifier() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getElement();
        return referenceElement != null ? referenceElement.advancedResolve(true).getElement() : null;
    }
}

