/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.JvmCommonIntentionActionsFactory;
import com.intellij.codeInsight.intention.MethodInsertionInfo;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.PsiNavigateUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/UastCreateMethodFix;", "Lcom/intellij/codeInspection/LocalQuickFixBase;", "containingClass", "Lorg/jetbrains/uast/UClass;", "createMethodAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInsight/intention/IntentionAction;)V", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "reformatAndOpenCreatedMethod", "method", "Lorg/jetbrains/uast/UMethod;", "Companion", "java-impl"})
public final class UastCreateMethodFix
extends LocalQuickFixBase {
    private final SmartPsiElementPointer<UClass> containingClass;
    private final IntentionAction createMethodAction;
    public static final Companion Companion = new Companion(null);

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        UMethod uMethod;
        block10: {
            block9: {
                Object object;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                    PsiFile psiFile = this.containingClass.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    PsiFile file2 = psiFile;
                    UMethod[] uMethodArray = (UMethod[])this.containingClass.getElement();
                    if (uMethodArray == null || (uMethodArray = uMethodArray.getMethods()) == null) {
                        return;
                    }
                    UMethod[] methodsBefore = uMethodArray;
                    this.createMethodAction.invoke(project2, null, file2);
                    uMethod = (UMethod)this.containingClass.getElement();
                    if (uMethod == null || (uMethod = uMethod.getMethods()) == null) break block9;
                    Object[] $receiver$iv = (Object[])uMethod;
                    for (int j = 0; j < $receiver$iv.length; ++j) {
                        boolean bl;
                        Object element$iv;
                        block7: {
                            element$iv = $receiver$iv[j];
                            UMethod method = (UMethod)element$iv;
                            Object[] $receiver$iv2 = methodsBefore;
                            for (int k = 0; k < $receiver$iv2.length; ++k) {
                                Object element$iv2 = $receiver$iv2[k];
                                UMethod it = (UMethod)element$iv2;
                                if (!it.isEquivalentTo((PsiElement)method)) continue;
                                bl = false;
                                break block7;
                            }
                            bl = true;
                        }
                        if (!bl) continue;
                        object = element$iv;
                        break block8;
                    }
                    object = null;
                }
                if ((uMethod = (UMethod)object) != null) break block10;
            }
            return;
        }
        UMethod newMethod = uMethod;
        this.reformatAndOpenCreatedMethod(newMethod);
    }

    private final void reformatAndOpenCreatedMethod(UMethod method) {
        CodeStyleManager.getInstance((Project)this.containingClass.getProject()).reformat((PsiElement)method);
        UExpression uExpression = method.getUastBody();
        if (uExpression == null || (uExpression = uExpression.getPsi()) == null || (uExpression = uExpression.getLastChild()) == null) {
            uExpression = (PsiElement)method;
        }
        PsiNavigateUtil.navigate((PsiElement)uExpression);
    }

    public UastCreateMethodFix(@NotNull UClass containingClass, @NotNull IntentionAction createMethodAction) {
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Intrinsics.checkParameterIsNotNull((Object)createMethodAction, (String)"createMethodAction");
        super(createMethodAction.getText(), createMethodAction.getFamilyName());
        this.createMethodAction = createMethodAction;
        this.containingClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
    }

    @JvmStatic
    @Nullable
    public static final UastCreateMethodFix createVoidMethodIfFixPossible(@NotNull UClass uClass, @NotNull String methodName, @PsiModifier.ModifierConstant @NotNull String modifier) {
        Intrinsics.checkParameterIsNotNull((Object)uClass, (String)"uClass");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        return Companion.createVoidMethodIfFixPossible(uClass, methodName, modifier);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/UastCreateMethodFix$Companion;", "", "()V", "createVoidMethodIfFixPossible", "Lcom/intellij/codeInsight/daemon/impl/quickfix/UastCreateMethodFix;", "uClass", "Lorg/jetbrains/uast/UClass;", "methodName", "", "modifier", "java-impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final UastCreateMethodFix createVoidMethodIfFixPossible(@NotNull UClass uClass, @NotNull String methodName, @PsiModifier.ModifierConstant @NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull((Object)uClass, (String)"uClass");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
            if (!ModuleUtilCore.projectContainsFile((Project)uClass.getProject(), (VirtualFile)uClass.getContainingFile().getVirtualFile(), (boolean)false)) {
                return null;
            }
            Language language = uClass.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"uClass.language");
            JvmCommonIntentionActionsFactory jvmCommonIntentionActionsFactory = JvmCommonIntentionActionsFactory.Companion.forLanguage(language);
            if (jvmCommonIntentionActionsFactory == null) {
                return null;
            }
            JvmCommonIntentionActionsFactory actionsFactory = jvmCommonIntentionActionsFactory;
            PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiPrimitiveType, (String)"PsiType.VOID");
            IntentionAction intentionAction = (IntentionAction)CollectionsKt.firstOrNull((List)actionsFactory.createAddCallableMemberActions((MethodInsertionInfo)MethodInsertionInfo.Companion.simpleMethodInfo(uClass, methodName, modifier, (PsiType)psiPrimitiveType, CollectionsKt.emptyList())));
            if (intentionAction == null) {
                return null;
            }
            IntentionAction action = intentionAction;
            return new UastCreateMethodFix(uClass, action);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

