/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VariableAccessFromInnerClassFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix");
    private final PsiVariable myVariable;
    private final PsiElement myContext;
    private final int myFixType;
    private static final int MAKE_FINAL = 0;
    private static final int MAKE_ARRAY = 1;
    private static final int COPY_TO_FINAL = 2;
    private static final Key<Map<PsiVariable, Boolean>>[] VARS = new Key[]{Key.create((String)"VARS_TO_MAKE_FINAL"), Key.create((String)"VARS_TO_TRANSFORM"), Key.create((String)"???")};

    public VariableAccessFromInnerClassFix(@NotNull PsiVariable variable, @NotNull PsiElement element) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "<init>"));
        }
        this.myVariable = variable;
        this.myContext = element;
        this.myFixType = VariableAccessFromInnerClassFix.getQuickFixType(variable);
        if (this.myFixType == -1) {
            return;
        }
        this.getVariablesToFix().add(variable);
    }

    @NotNull
    public String getText() {
        String message2;
        switch (this.myFixType) {
            case 0: {
                message2 = "make.final.text";
                break;
            }
            case 1: {
                message2 = "make.final.transform.to.one.element.array";
                break;
            }
            case 2: {
                String string = QuickFixBundle.message("make.final.copy.to.temp", this.myVariable.getName(), (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myContext) ? "" : "effectively ") + "final");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getText"));
                }
                return string;
            }
            default: {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getText"));
                }
                return "";
            }
        }
        Collection<PsiVariable> vars = this.getVariablesToFix();
        String varNames = vars.size() == 1 ? "'" + this.myVariable.getName() + "'" : "variables";
        String string = QuickFixBundle.message(message2, varNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.final.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "isAvailable"));
        }
        return this.myContext.isValid() && this.myContext.getManager().isInProject(this.myContext) && this.myVariable.isValid() && this.myFixType != -1 && !this.getVariablesToFix().isEmpty() && !VariableAccessFromInnerClassFix.inOwnInitializer(this.myVariable, this.myContext);
    }

    private static boolean inOwnInitializer(PsiVariable variable, PsiElement context) {
        return PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)context, (boolean)false);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myContext, this.myVariable})) {
            return;
        }
        WriteAction.run(() -> {
            try {
                switch (this.myFixType) {
                    case 0: {
                        this.makeFinal();
                        return;
                    }
                    case 1: {
                        this.makeArray();
                        return;
                    }
                    case 2: {
                        VariableAccessFromInnerClassFix.copyToFinal(this.myVariable, this.myContext);
                        return;
                    }
                }
                return;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return;
            }
            finally {
                this.getVariablesToFix().clear();
            }
        });
    }

    private void makeArray() {
        for (PsiVariable var : this.getVariablesToFix()) {
            VariableAccessFromInnerClassFix.makeArray(var, this.myContext);
        }
    }

    @NotNull
    private Collection<PsiVariable> getVariablesToFix() {
        Map vars = (Map)this.myContext.getUserData(VARS[this.myFixType]);
        if (vars == null) {
            vars = ContainerUtil.createConcurrentWeakMap();
            this.myContext.putUserData(VARS[this.myFixType], (Object)vars);
        }
        final Map finalVars = vars;
        AbstractCollection<PsiVariable> abstractCollection = new AbstractCollection<PsiVariable>(){

            @Override
            public boolean add(PsiVariable psiVariable) {
                return finalVars.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            @NotNull
            public Iterator<PsiVariable> iterator() {
                Iterator<PsiVariable> iterator = finalVars.keySet().iterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix$1", "iterator"));
                }
                return iterator;
            }

            @Override
            public int size() {
                return finalVars.size();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getVariablesToFix"));
        }
        return abstractCollection;
    }

    private void makeFinal() {
        for (PsiVariable var : this.getVariablesToFix()) {
            if (!var.isValid()) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)true);
        }
    }

    private static void makeArray(PsiVariable variable, PsiElement context) throws IncorrectOperationException {
        PsiDeclarationStatement variableDeclarationStatement;
        variable.normalizeDeclaration();
        PsiType type2 = variable.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiArrayType newType = type2.createArrayType();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            String expression2 = "[1]";
            while (type2 instanceof PsiArrayType) {
                expression2 = expression2 + "[1]";
                type2 = ((PsiArrayType)type2).getComponentType();
            }
            PsiExpression init = factory.createExpressionFromText("new " + type2.getCanonicalText() + expression2, (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        } else {
            PsiExpression init = factory.createExpressionFromText("{ " + initializer.getText() + " }", (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        }
        PsiVariable newVariable = (PsiVariable)variableDeclarationStatement.getDeclaredElements()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)true);
        PsiExpression newExpression = factory.createExpressionFromText(variable.getName() + "[0]", (PsiElement)variable);
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        VariableAccessFromInnerClassFix.replaceReferences(outerReferences, (PsiElement)newExpression);
        variable.replace((PsiElement)newVariable);
    }

    private static void copyToFinal(PsiVariable variable, PsiElement context) throws IncorrectOperationException {
        PsiManager psiManager = context.getManager();
        Project project2 = psiManager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(variable.getName(), context);
        String newName = VariableAccessFromInnerClassFix.suggestNewName(project2, variable);
        PsiType type2 = variable.getType();
        PsiDeclarationStatement copyDecl = factory.createVariableDeclarationStatement(newName, type2, initializer);
        PsiVariable newVariable = (PsiVariable)copyDecl.getDeclaredElements()[0];
        boolean mustBeFinal = !PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) || CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_LOCALS;
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)mustBeFinal);
        PsiElement statement2 = VariableAccessFromInnerClassFix.getStatementToInsertBefore(variable, context);
        if (statement2 == null) {
            return;
        }
        PsiExpression newExpression = factory.createExpressionFromText(newName, (PsiElement)variable);
        VariableAccessFromInnerClassFix.replaceReferences(context, variable, (PsiElement)newExpression);
        if (RefactoringUtil.isLoopOrIf(statement2.getParent())) {
            RefactoringUtil.putStatementInLoopBody((PsiStatement)copyDecl, statement2.getParent(), statement2);
        } else {
            statement2.getParent().addBefore((PsiElement)copyDecl, statement2);
        }
    }

    private static PsiElement getStatementToInsertBefore(PsiVariable variable, PsiElement context) {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = variable instanceof PsiParameter ? ((PsiParameter)variable).getDeclarationScope() : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (declarationScope == null) {
            return null;
        }
        PsiElement statement2 = context;
        block0: while (true) {
            if ((statement2 = RefactoringUtil.getParentStatement(statement2, false)) == null || statement2.getParent() == null) {
                return null;
            }
            for (PsiElement element = statement2; element != declarationScope && !(element instanceof PsiFile); element = element.getParent()) {
                if (!(element instanceof PsiClass)) continue;
                statement2 = statement2.getParent();
                continue block0;
            }
            break;
        }
        return statement2;
    }

    private static String suggestNewName(Project project2, PsiVariable variable) {
        String name2 = variable.getName();
        if (name2.length() > 1 && Character.isDigit(name2.charAt(name2.length() - 1))) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        name2 = "final" + StringUtil.capitalize((String)StringUtil.trimStart((String)name2, (String)"final"));
        return JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(name2, (PsiElement)variable, true);
    }

    private static void replaceReferences(PsiElement context, final PsiVariable variable, final PsiElement newExpression) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    try {
                        expression2.replace(newExpression);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    private static void replaceReferences(List<PsiReferenceExpression> references, PsiElement newExpression) throws IncorrectOperationException {
        for (PsiReferenceExpression reference : references) {
            reference.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    private static int getQuickFixType(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "getQuickFixType"));
        }
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return -1;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        int type2 = 0;
        for (PsiReferenceExpression expression2 : outerReferences) {
            PsiElement innerScope = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
            if (innerScope == null) continue;
            int thisType = 0;
            if (VariableAccessFromInnerClassFix.writtenInside(variable, innerScope)) {
                if (variable instanceof PsiParameter) {
                    return -1;
                }
                thisType = 1;
            }
            if (thisType == 0 && !VariableAccessFromInnerClassFix.canBeFinal(variable, outerReferences)) {
                thisType = 2;
            }
            type2 = Math.max(type2, thisType);
        }
        return type2;
    }

    private static boolean canBeFinal(@NotNull PsiVariable variable, @NotNull List<PsiReferenceExpression> references) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "canBeFinal"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "canBeFinal"));
        }
        THashMap uninitializedVarProblems = new THashMap();
        THashMap finalVarProblems = new THashMap();
        for (PsiReferenceExpression expression2 : references) {
            if (ControlFlowUtil.isVariableAssignedInLoop(expression2, (PsiElement)variable)) {
                return false;
            }
            HighlightInfo highlightInfo = HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression2, variable, (Map<PsiElement, Collection<PsiReferenceExpression>>)uninitializedVarProblems, variable.getContainingFile());
            if (highlightInfo != null) {
                return false;
            }
            highlightInfo = HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression2, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)finalVarProblems);
            if (highlightInfo != null) {
                return false;
            }
            if (!(variable instanceof PsiParameter) || !PsiUtil.isAccessedForWriting((PsiExpression)expression2)) continue;
            return false;
        }
        return true;
    }

    private static boolean writtenInside(PsiVariable variable, PsiElement element) {
        PsiElement[] children2;
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == variable) {
                return true;
            }
        } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            PsiExpression operand2;
            PsiExpression psiExpression = operand2 = element instanceof PsiPostfixExpression ? ((PsiPostfixExpression)element).getOperand() : ((PsiPrefixExpression)element).getOperand();
            if (operand2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand2).resolve() == variable) {
                return true;
            }
        }
        for (PsiElement child : children2 = element.getChildren()) {
            if (!VariableAccessFromInnerClassFix.writtenInside(variable, child)) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void fixAccess(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "fixAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix", "fixAccess"));
        }
        int type2 = VariableAccessFromInnerClassFix.getQuickFixType(variable);
        if (type2 == -1) {
            return;
        }
        switch (type2) {
            case 0: {
                PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
                break;
            }
            case 1: {
                VariableAccessFromInnerClassFix.makeArray(variable, context);
                break;
            }
            case 2: {
                VariableAccessFromInnerClassFix.copyToFinal(variable, context);
            }
        }
    }
}

