/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.ReferenceTransferableData;
import com.intellij.codeInsight.editorActions.RestoreReferencesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CopyPasteReferenceProcessor<TRef extends PsiElement>
extends CopyPastePostProcessor<ReferenceTransferableData> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor");

    @Override
    @NotNull
    public List<ReferenceTransferableData> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 2) {
            List<ReferenceTransferableData> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "collectTransferableData"));
            }
            return list2;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            List<ReferenceTransferableData> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "collectTransferableData"));
            }
            return list3;
        }
        ArrayList<ReferenceData> array = new ArrayList<ReferenceData>();
        int refOffset = 0;
        for (int j = 0; j < startOffsets.length; ++j) {
            refOffset += startOffsets[j];
            for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file2, startOffsets[j], endOffsets[j])) {
                this.addReferenceData(file2, refOffset, element, array);
            }
            refOffset -= endOffsets[j] + 1;
        }
        if (array.isEmpty()) {
            List<ReferenceTransferableData> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "collectTransferableData"));
            }
            return list4;
        }
        List<ReferenceTransferableData> list5 = Collections.singletonList(new ReferenceTransferableData(array.toArray(new ReferenceData[array.size()])));
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "collectTransferableData"));
        }
        return list5;
    }

    protected abstract void addReferenceData(PsiFile var1, int var2, PsiElement var3, ArrayList<ReferenceData> var4);

    @Override
    @NotNull
    public List<ReferenceTransferableData> extractTransferableData(Transferable content) {
        ReferenceTransferableData referenceData = null;
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != 2) {
            try {
                DataFlavor flavor = ReferenceData.getDataFlavor();
                if (flavor != null) {
                    referenceData = (ReferenceTransferableData)content.getTransferData(flavor);
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        if (referenceData != null) {
            List<ReferenceTransferableData> list2 = Collections.singletonList(referenceData.clone());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "extractTransferableData"));
            }
            return list2;
        }
        List<ReferenceTransferableData> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "extractTransferableData"));
        }
        return list3;
    }

    @Override
    public void processTransferableData(Project project2, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<ReferenceTransferableData> values) {
        if (DumbService.getInstance((Project)project2).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (!(file2 instanceof PsiClassOwner)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        assert (values.size() == 1);
        ReferenceData[] referenceData = values.get(0).getData();
        PsiElement[] refs = this.findReferencesToRestore(file2, bounds, referenceData);
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3) {
            CopyPasteReferenceProcessor.askReferencesToRestore(project2, refs, referenceData);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> this.restoreReferences(referenceData, refs));
    }

    protected static void addReferenceData(PsiElement element, ArrayList<ReferenceData> array, int startOffset, String qClassName, @Nullable String staticMemberName) {
        TextRange range = element.getTextRange();
        array.add(new ReferenceData(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, qClassName, staticMemberName));
    }

    @NotNull
    protected abstract TRef[] findReferencesToRestore(PsiFile var1, RangeMarker var2, ReferenceData[] var3);

    protected PsiElement resolveReferenceIgnoreOverriding(PsiPolyVariantReference reference) {
        ResolveResult[] results;
        PsiElement referent = reference.resolve();
        if (referent == null && (results = reference.multiResolve(true)).length > 0) {
            referent = results[0].getElement();
        }
        return referent;
    }

    protected abstract void restoreReferences(ReferenceData[] var1, TRef[] var2);

    private static void askReferencesToRestore(Project project2, @NotNull PsiElement[] refs, ReferenceData[] referenceData) {
        Object refObject;
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor", "askReferencesToRestore"));
        }
        PsiManager manager = PsiManager.getInstance((Project)project2);
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        Object[] refObjects = new Object[refs.length];
        for (int i2 = 0; i2 < referenceData.length; ++i2) {
            PsiElement ref = refs[i2];
            if (ref == null) continue;
            LOG.assertTrue(ref.isValid());
            ReferenceData data = referenceData[i2];
            PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(data.qClassName, ref.getResolveScope());
            if (refClass == null) continue;
            refObject = refClass;
            if (data.staticMemberName != null) {
                refObject = refClass.getQualifiedName() + "." + data.staticMemberName;
            }
            refObjects[i2] = refObject;
            if (array.contains(refObject)) continue;
            array.add((PsiClass)refObject);
        }
        if (array.isEmpty()) {
            return;
        }
        Object[] selectedObjects = ArrayUtil.toObjectArray(array);
        Arrays.sort(selectedObjects, (o1, o2) -> CopyPasteReferenceProcessor.getFQName(o1).compareToIgnoreCase(CopyPasteReferenceProcessor.getFQName(o2)));
        RestoreReferencesDialog dialog2 = new RestoreReferencesDialog(project2, selectedObjects);
        dialog2.show();
        selectedObjects = dialog2.getSelectedElements();
        for (int i3 = 0; i3 < referenceData.length; ++i3) {
            PsiElement ref = refs[i3];
            if (ref == null) continue;
            PsiUtilCore.ensureValid((PsiElement)ref);
            refObject = refObjects[i3];
            boolean found = false;
            for (Object selected : selectedObjects) {
                if (!Comparing.equal((Object)refObject, (Object)selected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            refs[i3] = null;
        }
    }

    private static String getFQName(Object element) {
        return element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : (String)element;
    }
}

