/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandler
extends TypedHandlerDelegate {
    static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.LBRACE, JavaTokenType.RBRACE});
    private boolean myJavaLTTyped;

    private static void autoPopupMemberLookup(Project project2, Editor editor) {
        AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, (Condition<PsiFile>)((Condition)file2 -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file2.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
            if (prevSibling == null || ".".equals(prevSibling.getText())) {
                return false;
            }
            PsiElement parent = prevSibling;
            while ((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement || parent instanceof PsiTypeElement) {
            }
            if (parent instanceof PsiParameterList || parent instanceof PsiParameter) {
                return false;
            }
            if (!".".equals(lastElement.getText()) && !"#".equals(lastElement.getText())) {
                return JavaClassReferenceCompletionContributor.findJavaClassReference(file2, offset - 1) != null;
            }
            PsiElement element = file2.findElementAt(offset);
            return element == null || !"#".equals(lastElement.getText()) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) != null;
        }));
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project2, Editor editor, PsiFile file2, FileType fileType) {
        if (!(file2 instanceof PsiJavaFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '@') {
            JavaTypedHandler.autoPopupJavadocLookup(project2, editor);
        } else if (c == '#' || c == '.') {
            JavaTypedHandler.autoPopupMemberLookup(project2, editor);
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && !(file2 instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) && JavaTypedHandler.isAfterClassLikeIdentifierOrDot(offsetBefore, editor);
        if ('>' == c && !(file2 instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) && JavaTypedHandler.handleJavaGT(editor, JavaTokenType.LT, JavaTokenType.GT, INVALID_INSIDE_REFERENCE)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ';' && JavaTypedHandler.handleSemicolon(editor, fileType)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (fileType == StdFileTypes.JAVA && c == '{') {
            PsiElement prevLeaf;
            PsiElement prev;
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project2).commitDocument(doc);
            PsiElement leaf = file2.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiElement st = leaf != null ? leaf.getParent() : null;
            PsiElement psiElement = prev = offset > 1 ? file2.findElementAt(offset - 1) : null;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandler.isRparenth(leaf) && (st instanceof PsiWhileStatement || st instanceof PsiIfStatement) && JavaTypedHandler.shouldInsertStatementBody(st, doc, prev)) {
                CommandProcessor.getInstance().executeCommand(project2, () -> new JavaSmartEnterProcessor().process(project2, editor, file2), "Insert block statement", null);
                return TypedHandlerDelegate.Result.STOP;
            }
            PsiElement psiElement2 = prevLeaf = leaf == null ? null : PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
            if (PsiUtil.isJavaToken((PsiElement)prevLeaf, (IElementType)JavaTokenType.ARROW) || PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace(project2, editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean shouldInsertStatementBody(@NotNull PsiElement statement2, @NotNull Document doc, @Nullable PsiElement prev) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "shouldInsertStatementBody"));
        }
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "shouldInsertStatementBody"));
        }
        PsiStatement block = statement2 instanceof PsiWhileStatement ? ((PsiWhileStatement)statement2).getBody() : ((PsiIfStatement)statement2).getThenBranch();
        PsiExpression condition2 = (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)statement2, PsiExpression.class);
        PsiExpression latestExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (latestExpression instanceof PsiNewExpression && ((PsiNewExpression)latestExpression).getAnonymousClass() == null) {
            return false;
        }
        return !(block instanceof PsiBlockStatement) && (block == null || JavaTypedHandler.startLine(doc, (PsiElement)block) != JavaTypedHandler.startLine(doc, statement2) || condition2 == null);
    }

    private static boolean isRparenth(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return false;
        }
        if (leaf.getNode().getElementType() == JavaTokenType.RPARENTH) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        if (next == null) {
            return false;
        }
        return next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "startLine"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "startLine"));
        }
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "charTyped"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "charTyped"));
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            JavaTypedHandler.handleAfterJavaLT(editor, JavaTokenType.LT, JavaTokenType.GT, INVALID_INSIDE_REFERENCE);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ':' ? JavaTypedHandler.autoIndentCase(editor, project2, file2) : c == ',' && JavaTypedHandler.handleAnnotationParameter(project2, editor, file2)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean handleAnnotationParameter(Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "handleAnnotationParameter"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "handleAnnotationParameter"));
        }
        int caret = editor.getCaretModel().getOffset();
        if (JavaTypedHandler.mightBeInsideDefaultAnnotationAttribute(editor, caret - 2)) {
            PsiNameValuePair attr;
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(caret), PsiAnnotation.class, (boolean)false, (Class[])new Class[]{PsiExpression.class, PsiComment.class});
            PsiNameValuePair psiNameValuePair = attr = anno == null ? null : JavaTypedHandler.getTheOnlyDefaultAttribute(anno);
            if (attr != null && JavaTypedHandler.hasDefaultArrayMethod(anno) && !(attr.getValue() instanceof PsiArrayInitializerMemberValue)) {
                editor.getDocument().insertString(caret, (CharSequence)"}");
                editor.getDocument().insertString(attr.getTextRange().getStartOffset(), (CharSequence)"{");
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiNameValuePair getTheOnlyDefaultAttribute(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "getTheOnlyDefaultAttribute"));
        }
        List attributes = ContainerUtil.findAll((Object[])anno.getParameterList().getAttributes(), a -> !a.getTextRange().isEmpty());
        return attributes.size() == 1 && ((PsiNameValuePair)attributes.get(0)).getNameIdentifier() == null ? (PsiNameValuePair)attributes.get(0) : null;
    }

    private static boolean hasDefaultArrayMethod(@NotNull PsiAnnotation anno) {
        PsiElement annoClass;
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "hasDefaultArrayMethod"));
        }
        PsiJavaCodeReferenceElement nameRef = anno.getNameReferenceElement();
        PsiElement psiElement = annoClass = nameRef == null ? null : nameRef.resolve();
        if (annoClass instanceof PsiClass) {
            PsiMethod[] methods = ((PsiClass)annoClass).getMethods();
            return methods.length == 1 && PsiUtil.isAnnotationMethod((PsiElement)methods[0]) && "value".equals(methods[0].getName()) && methods[0].getReturnType() instanceof PsiArrayType;
        }
        return false;
    }

    private static boolean mightBeInsideDefaultAnnotationAttribute(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "mightBeInsideDefaultAnnotationAttribute"));
        }
        if (offset < 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        int parenCount = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.AT) {
                return true;
            }
            if (tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.LBRACE || tokenType == JavaTokenType.EQ || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA) {
                return false;
            }
            if (tokenType == JavaTokenType.LPARENTH && ++parenCount > 1) {
                return false;
            }
            iterator.retreat();
        }
        return false;
    }

    private static boolean handleSemicolon(Editor editor, FileType fileType) {
        if (fileType != StdFileTypes.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JavaTokenType.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    public static boolean handleJavaGT(Editor editor, IElementType lt, IElementType gt, TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.getTokenType() != gt) {
            return false;
        }
        while (!iterator.atEnd() && !invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                --balance;
            } else if (tokenType == gt) {
                ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            iterator.retreat();
        }
        if (balance == 0) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        return false;
    }

    public static void handleAfterJavaLT(Editor editor, IElementType lt, IElementType gt, TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        while (iterator.getStart() > 0 && !invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        if (invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                ++balance;
            } else if (tokenType == gt) {
                --balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            iterator.advance();
        }
        if (balance == 1) {
            editor.getDocument().insertString(offset, (CharSequence)">");
        }
    }

    private static void autoPopupJavadocLookup(Project project2, Editor editor) {
        AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, (Condition<PsiFile>)((Condition)file2 -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file2.findElementAt(offset - 1);
            return lastElement != null && StringUtil.endsWithChar((CharSequence)lastElement.getText(), (char)'@');
        }));
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset, Editor editor) {
        IElementType tokenType;
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        if ((tokenType = iterator.getTokenType()) == JavaTokenType.DOT) {
            return true;
        }
        return JavaTypedHandler.isClassLikeIdentifier(offset, editor, iterator, JavaTokenType.IDENTIFIER);
    }

    public static boolean isClassLikeIdentifier(int offset, Editor editor, HighlighterIterator iterator, IElementType idType) {
        if (iterator.getTokenType() == idType && iterator.getEnd() == offset) {
            CharSequence chars = editor.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word = chars.subSequence(iterator.getStart(), iterator.getEnd());
            if (word.length() == 1) {
                return true;
            }
            for (int i2 = 1; i2 < word.length(); ++i2) {
                if (!Character.isLowerCase(word.charAt(i2))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean autoIndentCase(Editor editor, Project project2, PsiFile file2) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        PsiElement currElement = file2.findElementAt(offset - 1);
        if (currElement != null && (parent = currElement.getParent()) != null && parent instanceof PsiSwitchLabelStatement) {
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, parent.getTextOffset());
            return true;
        }
        return false;
    }
}

