/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class MatchBraceAction
extends EditorAction {
    public MatchBraceAction() {
        super((EditorActionHandler)new MyHandler());
    }

    @NotNull
    private static FileType getFileType(PsiFile file2, int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)offset).getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/MatchBraceAction", "getFileType"));
        }
        return fileType;
    }

    private static void moveCaret(Editor editor, Caret caret, int offset) {
        caret.removeSelection();
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static class MyHandler
    extends EditorActionHandler {
        public MyHandler() {
            super(true);
        }

        public void execute(Editor editor, DataContext dataContext) {
            HighlighterIterator i2;
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (file2 == null) {
                return;
            }
            Caret caret = editor.getCaretModel().getCurrentCaret();
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            CharSequence text2 = editor.getDocument().getCharsSequence();
            int offset = caret.getOffset();
            FileType fileType = MatchBraceAction.getFileType(file2, offset);
            HighlighterIterator iterator = highlighter.createIterator(offset);
            if (iterator.atEnd()) {
                --offset;
            } else if (!BraceMatchingUtil.isLBraceToken(iterator, text2, fileType) && --offset >= 0 && !BraceMatchingUtil.isRBraceToken(i2 = highlighter.createIterator(offset), text2, MatchBraceAction.getFileType(file2, i2.getStart()))) {
                ++offset;
            }
            if (offset < 0) {
                return;
            }
            iterator = highlighter.createIterator(offset);
            fileType = MatchBraceAction.getFileType(file2, iterator.getStart());
            while (!BraceMatchingUtil.isLBraceToken(iterator, text2, fileType) && !BraceMatchingUtil.isRBraceToken(iterator, text2, fileType)) {
                if (iterator.getStart() == 0) {
                    return;
                }
                iterator.retreat();
                offset = iterator.getStart();
            }
            if (BraceMatchingUtil.matchBrace(text2, fileType, iterator, true)) {
                MatchBraceAction.moveCaret(editor, caret, iterator.getEnd());
                return;
            }
            iterator = highlighter.createIterator(offset);
            if (BraceMatchingUtil.matchBrace(text2, fileType, iterator, false)) {
                MatchBraceAction.moveCaret(editor, caret, iterator.getStart());
            }
        }
    }
}

