/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.AbstractIndentingBackspaceHandler;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SmartIndentingBackspaceHandler
extends AbstractIndentingBackspaceHandler {
    private static final Logger LOG = Logger.getInstance(SmartIndentingBackspaceHandler.class);
    private String myReplacement;
    private int myStartOffset;

    public SmartIndentingBackspaceHandler() {
        super(SmartBackspaceMode.AUTOINDENT);
    }

    @Override
    protected void doBeforeCharDeleted(char c, PsiFile file2, Editor editor) {
        Project project2 = file2.getProject();
        Document document = editor.getDocument();
        CharSequence charSequence = document.getImmutableCharSequence();
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        LogicalPosition pos = caretModel.getLogicalPosition();
        int lineStartOffset = document.getLineStartOffset(pos.line);
        int beforeWhitespaceOffset = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(caretOffset - 1), (String)" \t") + 1;
        if (beforeWhitespaceOffset != lineStartOffset) {
            this.myReplacement = null;
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project2);
        this.myReplacement = codeStyleFacade.getLineIndent(document, lineStartOffset);
        if (this.myReplacement == null) {
            return;
        }
        int tabSize = codeStyleFacade.getTabSize(file2.getFileType());
        int targetColumn = SmartIndentingBackspaceHandler.getWidth(this.myReplacement, tabSize);
        int endOffset = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)caretOffset, (String)" \t");
        LogicalPosition logicalPosition = caretOffset < endOffset ? editor.offsetToLogicalPosition(endOffset) : pos;
        int currentColumn = logicalPosition.column;
        if (currentColumn > targetColumn) {
            this.myStartOffset = lineStartOffset;
        } else if (logicalPosition.line == 0) {
            this.myStartOffset = 0;
            this.myReplacement = "";
        } else {
            int prevLineEndOffset = document.getLineEndOffset(logicalPosition.line - 1);
            this.myStartOffset = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(prevLineEndOffset - 1), (String)" \t") + 1;
            if (this.myStartOffset != document.getLineStartOffset(logicalPosition.line - 1)) {
                int spacing = CodeStyleManager.getInstance((Project)project2).getSpacing(file2, endOffset);
                this.myReplacement = StringUtil.repeatSymbol((char)' ', (int)Math.max(0, spacing));
            }
        }
    }

    @Override
    protected boolean doCharDeleted(char c, PsiFile file2, Editor editor) {
        if (this.myReplacement == null) {
            return false;
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int endOffset = CharArrayUtil.shiftForward((CharSequence)document.getImmutableCharSequence(), (int)caretModel.getOffset(), (String)" \t");
        document.replaceString(this.myStartOffset, endOffset, (CharSequence)this.myReplacement);
        caretModel.moveToOffset(this.myStartOffset + this.myReplacement.length());
        return true;
    }

    private static int getWidth(@NotNull String indent, int tabSize) {
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/codeInsight/editorActions/SmartIndentingBackspaceHandler", "getWidth"));
        }
        int width = 0;
        block4: for (int i2 = 0; i2 < indent.length(); ++i2) {
            char c = indent.charAt(i2);
            switch (c) {
                case '\t': {
                    width = tabSize * (width / tabSize + 1);
                    continue block4;
                }
                default: {
                    LOG.error("Unexpected whitespace character: " + c);
                }
                case ' ': {
                    ++width;
                }
            }
        }
        return width;
    }
}

