/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
        StringBuilder buffer = new StringBuilder();
        int givenTextOffset = 0;
        boolean textWasChanged = false;
        int deducedBlockSelectionWidth = StringLiteralCopyPasteProcessor.deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        for (int i2 = 0; i2 < startOffsets.length && givenTextOffset < text2.length(); ++i2, ++givenTextOffset) {
            TextRange escapedRange;
            if (i2 > 0) {
                buffer.append('\n');
            }
            int fileStartOffset = startOffsets[i2];
            int fileEndOffset = endOffsets[i2];
            int givenTextStartOffset = givenTextOffset;
            int givenTextEndOffset = givenTextOffset + (fileEndOffset - fileStartOffset);
            if ((givenTextOffset = givenTextEndOffset) > text2.length()) {
                return null;
            }
            String fragment = text2.substring(givenTextStartOffset, givenTextEndOffset);
            PsiElement element = file2.findElementAt(fileStartOffset);
            TextRange textRange = escapedRange = element == null ? null : this.getEscapedRange(element);
            if (escapedRange == null || escapedRange.getStartOffset() > fileStartOffset || escapedRange.getEndOffset() < fileEndOffset) {
                buffer.append(fragment);
            } else {
                textWasChanged = true;
                buffer.append(this.unescape(fragment, element));
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - (fileEndOffset - fileStartOffset);
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
                ++givenTextOffset;
            }
        }
        return textWasChanged ? buffer.toString() : null;
    }

    private static int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        int fragmentCount = startOffsets.length;
        assert (fragmentCount > 0);
        int totalLength = fragmentCount - 1;
        for (int i2 = 0; i2 < fragmentCount; ++i2) {
            totalLength += endOffsets[i2] - startOffsets[i2];
        }
        if (totalLength < text2.length() && (text2.length() + 1) % fragmentCount == 0) {
            return (text2.length() + 1) / fragmentCount - 1;
        }
        return -1;
    }

    @NotNull
    protected String unescape(String text2, PsiElement token) {
        String string = StringUtil.unescapeStringCharacters((String)text2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "unescape"));
        }
        return string;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor, String text2, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file2, selectionStart, selectionEnd);
        if (token == null) {
            String string = text2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        if (rawText != null && StringLiteralCopyPasteProcessor.wasUnescaped(text2, rawText.rawText)) {
            String string = rawText.rawText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        if (this.isStringLiteral(token)) {
            StringBuilder buffer = new StringBuilder(text2.length());
            String breaker = this.getLineBreaker(token);
            String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false, (boolean)true);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                buffer.append(this.escapeCharCharacters(lines[i2], token));
                if (i2 != lines.length - 1) {
                    buffer.append(breaker);
                    continue;
                }
                if (!text2.endsWith("\n")) continue;
                buffer.append("\\n");
            }
            text2 = buffer.toString();
        } else if (this.isCharLiteral(token)) {
            String string = this.escapeCharCharacters(text2, token);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    private static boolean wasUnescaped(String text2, String originalText) {
        try {
            return new TextBlockTransferable(StringUtil.unescapeStringCharacters((String)originalText), Collections.emptyList(), null).getTransferData(DataFlavor.stringFlavor).equals(text2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "getLineBreaker"));
        }
        CommonCodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)token.getProject()).getCommonSettings(token.getLanguage());
        return codeStyleSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\\n\"\n+ \"" : "\\n\" +\n\"";
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file2, int selectionStart, int selectionEnd) {
        TextRange textRange;
        PsiElement elementAtSelectionStart = file2.findElementAt(selectionStart);
        if (elementAtSelectionStart == null) {
            return null;
        }
        if (!this.isStringLiteral(elementAtSelectionStart) && !this.isCharLiteral(elementAtSelectionStart)) {
            return null;
        }
        if (elementAtSelectionStart.getTextRange().getEndOffset() < selectionEnd) {
            PsiElement elementAtSelectionEnd = file2.findElementAt(selectionEnd);
            if (elementAtSelectionEnd == null) {
                return null;
            }
            if (elementAtSelectionEnd.getNode().getElementType() == elementAtSelectionStart.getNode().getElementType() && elementAtSelectionEnd.getTextRange().getStartOffset() < selectionEnd) {
                return elementAtSelectionStart;
            }
        }
        if (selectionStart <= (textRange = elementAtSelectionStart.getTextRange()).getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return elementAtSelectionStart;
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "isCharLiteral"));
        }
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.CHARACTER_LITERAL;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "isStringLiteral"));
        }
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.STRING_LITERAL;
    }

    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "getEscapedRange"));
        }
        if (this.isCharLiteral(token) || this.isStringLiteral(token)) {
            TextRange tokenRange = token.getTextRange();
            return new TextRange(tokenRange.getStartOffset() + 1, tokenRange.getEndOffset() - 1);
        }
        return null;
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "escapeCharCharacters"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "escapeCharCharacters"));
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)(this.isStringLiteral(token) ? "\"" : "'"), (StringBuilder)buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor", "escapeCharCharacters"));
        }
        return string;
    }
}

