/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project2, Editor editor, PsiFile file2, FileType fileType) {
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, false);
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        return super.beforeCharTyped(c, project2, editor, file2, fileType);
    }

    @Nullable
    private static PsiElement getAttributeCandidate(@NotNull Editor editor, @NotNull PsiFile file2, boolean typed) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getAttributeCandidate"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getAttributeCandidate"));
        }
        int newOffset = editor.getCaretModel().getOffset() - (typed ? 2 : 1);
        if (newOffset < 0) {
            return null;
        }
        PsiElement at = file2.findElementAt(newOffset);
        return at != null ? at.getParent() : null;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file2.getContext();
            String toInsert = XmlEqTypedHandler.tryCompleteQuotes(fileContext);
            boolean showPopup = true;
            if (toInsert == null) {
                String quote = XmlEqTypedHandler.getDefaultQuote(file2);
                XmlExtension.AttributeValuePresentation presentation = XmlEqTypedHandler.getValuePresentation(editor, file2, quote);
                toInsert = presentation.getPrefix() + presentation.getPostfix();
                showPopup = presentation.showAutoPopup();
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + toInsert.length() / 2);
            if (showPopup) {
                AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
            }
            this.needToInsertQuotes = false;
        }
        return super.charTyped(c, project2, editor, file2);
    }

    @Nullable
    private static String tryCompleteQuotes(@Nullable PsiElement fileContext) {
        if (fileContext != null) {
            if (fileContext.getText().startsWith("\"")) {
                return "''";
            }
            if (fileContext.getText().startsWith("'")) {
                return "\"\"";
            }
        }
        return null;
    }

    @NotNull
    private static String getDefaultQuote(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getDefaultQuote"));
        }
        String string = XmlEditUtil.getAttributeQuote(file2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getDefaultQuote"));
        }
        return string;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation getValuePresentation(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull String quote) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getValuePresentation"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getValuePresentation"));
        }
        if (quote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quote", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getValuePresentation"));
        }
        PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, true);
        XmlAttributeDescriptor descriptor = atParent instanceof XmlAttribute ? ((XmlAttribute)atParent).getDescriptor() : null;
        XmlExtension.AttributeValuePresentation attributeValuePresentation = XmlExtension.getExtension(file2).getAttributeValuePresentation(descriptor, quote);
        if (attributeValuePresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "getValuePresentation"));
        }
        return attributeValuePresentation;
    }
}

