/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiForStatement)) {
            return;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiJavaToken lParenth = forStatement.getLParenth();
        PsiJavaToken rParenth = forStatement.getRParenth();
        if (lParenth == null || rParenth == null) {
            TextRange textRange = forStatement.getTextRange();
            editor.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)"for () {\n}");
            processor2.registerUnresolvedError(textRange.getStartOffset() + "for (".length());
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (initialization == null) {
            processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
            return;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (condition2 == null) {
            ForStatementFixer.registerErrorOffset(editor, processor2, (PsiElement)initialization, forStatement);
            return;
        }
        if (forStatement.getUpdate() == null) {
            ForStatementFixer.registerErrorOffset(editor, processor2, (PsiElement)condition2, forStatement);
        }
    }

    private static void registerErrorOffset(@NotNull Editor editor, @NotNull JavaSmartEnterProcessor processor2, @NotNull PsiElement lastValidForPart, @NotNull PsiForStatement forStatement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer", "registerErrorOffset"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer", "registerErrorOffset"));
        }
        if (lastValidForPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastValidForPart", "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer", "registerErrorOffset"));
        }
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer", "registerErrorOffset"));
        }
        Project project2 = editor.getProject();
        int offset = lastValidForPart.getTextRange().getEndOffset();
        if (project2 != null && CodeStyleSettingsManager.getSettings((Project)project2).SPACE_AFTER_COMMA) {
            if (editor.getDocument().getCharsSequence().charAt(lastValidForPart.getTextRange().getEndOffset() - 1) != ';') {
                ++offset;
            }
            for (PsiElement element = lastValidForPart.getNextSibling(); element != null && element != forStatement.getRParenth() && element.getParent() == forStatement; element = element.getNextSibling()) {
                ASTNode node = element.getNode();
                if (node == null || !JavaJspElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType()) || element.getTextLength() <= 0) continue;
                ++offset;
                break;
            }
        }
        processor2.registerUnresolvedError(offset);
    }
}

