/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class MissingForBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        String braces;
        PsiForStatement forStatement = MissingForBodyFixer.getForStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiStatement body2 = forStatement.getBody();
        if (body2 instanceof PsiBlockStatement) {
            return;
        }
        if (body2 != null && MissingForBodyFixer.startLine(doc, (PsiElement)body2) == MissingForBodyFixer.startLine(doc, (PsiElement)forStatement)) {
            return;
        }
        PsiJavaToken eltToInsertAfter = forStatement.getRParenth();
        String text2 = braces = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text2 = ")" + text2;
        }
        int offset = eltToInsertAfter.getTextRange().getEndOffset();
        doc.insertString(offset, (CharSequence)text2);
        editor.getCaretModel().moveToOffset(offset + text2.length() - braces.length());
    }

    @Nullable
    private static PsiForStatement getForStatementParent(PsiElement psiElement) {
        PsiForStatement statement2 = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiForStatement.class);
        if (statement2 == null) {
            return null;
        }
        PsiStatement init = statement2.getInitialization();
        PsiStatement update2 = statement2.getUpdate();
        PsiExpression check = statement2.getCondition();
        return MissingForBodyFixer.isValidChild((PsiElement)init, psiElement) || MissingForBodyFixer.isValidChild((PsiElement)update2, psiElement) || MissingForBodyFixer.isValidChild((PsiElement)check, psiElement) ? statement2 : null;
    }

    private static boolean isValidChild(PsiElement ancestor, PsiElement psiElement) {
        if (ancestor != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)psiElement, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

