/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiExpressionList;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        if (!(e instanceof PsiExpressionList)) {
            return Collections.emptyList();
        }
        PsiExpressionList expressionList = (PsiExpressionList)e;
        PsiParameterList parameterList = VarargsSelectioner.getParameterList(expressionList);
        if (parameterList == null) {
            return Collections.emptyList();
        }
        PsiExpression[] varargArgs = VarargsSelectioner.getVarargArgs(parameterList, expressionList);
        if (varargArgs.length == 0) {
            return Collections.emptyList();
        }
        TextRange firstExpressionRange = varargArgs[0].getTextRange();
        TextRange lastExpressionRange = varargArgs[varargArgs.length - 1].getTextRange();
        return Collections.singletonList(new TextRange(firstExpressionRange.getStartOffset(), lastExpressionRange.getEndOffset()));
    }

    @NotNull
    private static PsiExpression[] getVarargArgs(@NotNull PsiParameterList parameterList, @NotNull PsiExpressionList expressionList) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getVarargArgs"));
        }
        if (expressionList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionList", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getVarargArgs"));
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiExpression[] expressions2 = expressionList.getExpressions();
        if (parameters2.length == 0 || expressions2.length == 0) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getVarargArgs"));
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        int varargIndex = parameters2.length - 1;
        PsiParameter varargParam = parameters2[varargIndex];
        if (!varargParam.isVarArgs() || parameters2.length > expressions2.length) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getVarargArgs"));
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        PsiExpression[] psiExpressionArray = Arrays.copyOfRange(expressions2, varargIndex, expressions2.length);
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getVarargArgs"));
        }
        return psiExpressionArray;
    }

    @Nullable
    private static PsiParameterList getParameterList(@NotNull PsiExpressionList list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner", "getParameterList"));
        }
        if (!(list2.getParent() instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethod method = ((PsiMethodCallExpression)list2.getParent()).resolveMethod();
        return method != null ? method.getParameterList() : null;
    }
}

