/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");

    private static String getPlaceholderText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getPlaceholderText"));
        }
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)((PsiMethod)element).getBody());
        }
        if (element instanceof PsiClassInitializer) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)((PsiClassInitializer)element).getBody());
        }
        if (element instanceof PsiClass || element instanceof PsiJavaModule) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(null);
        }
        if (element instanceof PsiLambdaExpression) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(((PsiLambdaExpression)element).getBody());
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return "<~>";
        }
        if (element instanceof PsiComment) {
            return "//...";
        }
        return "...";
    }

    private static String getCodeBlockPlaceholder(PsiElement codeBlock) {
        return codeBlock instanceof PsiCodeBlock && ((PsiCodeBlock)codeBlock).getStatements().length == 0 ? "{}" : "{...}";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method) {
        PsiExpression expr;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isSimplePropertyAccessor"));
        }
        if (DumbService.isDumb((Project)method.getProject())) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || body2.getLBrace() == null || body2.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            if (statement2 instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement2).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtil.isSimplePropertySetter((PsiMethod)method);
        }
        return false;
    }

    @Nullable
    private static TextRange getRangeToFold(@NotNull PsiElement element) {
        PsiElement body2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getRangeToFold"));
        }
        if (element instanceof SyntheticElement) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiCodeBlock body3 = ((PsiMethod)element).getBody();
            if (body3 == null) {
                return null;
            }
            return body3.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaModule) {
            PsiElement left = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACE));
            PsiElement right = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.RBRACE));
            return left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset() + 1) : null;
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilderBase.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list2 = (PsiImportList)element;
            PsiImportStatementBase[] statements = list2.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            if (!JavaFoldingBuilderBase.hasErrorElementsNearby(element.getContainingFile(), startOffset, endOffset)) {
                return new TextRange(startOffset, endOffset);
            }
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        if (element instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)element).getBody()) instanceof PsiCodeBlock) {
            return body2.getTextRange();
        }
        return null;
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file2, int startOffset, int endOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "hasErrorElementsNearby"));
        }
        endOffset = CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)endOffset, (String)" \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file2, startOffset, endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange getFileHeader(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getFileHeader"));
        }
        PsiElement first = file2.getFirstChild();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element = prevSibling;
        }
        if (element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(@Nullable PsiModifierList modifierList, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document) {
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addAnnotationsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addAnnotationsToFold"));
        }
        if (modifierList == null) {
            return;
        }
        PsiElement[] children2 = modifierList.getChildren();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            PsiElement nextChild;
            int j;
            PsiElement child = children2[i2];
            if (!(child instanceof PsiAnnotation)) continue;
            JavaFoldingBuilderBase.addToFold(foldElements, child, document, false);
            for (j = i2 + 1; j < children2.length && !((nextChild = children2[j]) instanceof PsiModifier); ++j) {
            }
            i2 = j;
        }
    }

    private static void addCommentFolds(@NotNull PsiComment comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> foldElements) {
        ASTNode node;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT || JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)comment)) {
            return;
        }
        processedComments.add((PsiElement)comment);
        PsiElement end = null;
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT && !JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add(current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null) {
            foldElements.add(new FoldingDescriptor((PsiElement)comment, new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())));
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull PsiMethodCallExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiReferenceParameterList list2 = methodExpression.getParameterList();
        if (list2 == null || list2.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression2;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list2, 3, quick);
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "resolvesCorrectly"));
        }
        for (JavaResolveResult result2 : expression2.multiResolve(true)) {
            if (result2.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull PsiNewExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList list2;
        PsiAnonymousClass anonymousClass;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters2 = ((PsiClassType)declType).getParameters();
        if (parameters2.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        if (classReference2 == null && (anonymousClass = expression2.getAnonymousClass()) != null) {
            classReference2 = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), (PsiElement)anonymousClass)) {
                return;
            }
        }
        if (classReference2 != null && (list2 = classReference2.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list2.getText().equals(declList.getText()) : !Arrays.equals(list2.getTypeArguments(), parameters2)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list2, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, @NotNull PsiReferenceParameterList list2, int ifLongerThan, boolean quick) {
        String text2;
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (!quick) {
            for (PsiType type2 : list2.getTypeArguments()) {
                if (!type2.isValid()) {
                    return;
                }
                if (!(type2 instanceof PsiClassType) && !(type2 instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type2) != null) continue;
                return;
            }
        }
        if ((text2 = list2.getText()).startsWith("<") && text2.endsWith(">") && text2.length() > ifLongerThan) {
            TextRange range = list2.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(foldElements, (PsiElement)list2, document, true, range);
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static void addToFold(@NotNull List<FoldingDescriptor> list2, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        if (elementToFold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFold", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = JavaFoldingBuilderBase.getRangeToFold(elementToFold);
        if (range != null) {
            JavaFoldingBuilderBase.addFoldRegion(list2, elementToFold, document, allowOneLiners, range);
        }
    }

    private static void addFoldRegion(@NotNull List<FoldingDescriptor> list2, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (elementToFold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFold", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        TextRange fileRange = elementToFold.getContainingFile().getTextRange();
        if (range.equals((Object)fileRange)) {
            return;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list2.add(new FoldingDescriptor(elementToFold, range));
            }
        } else if (range.getLength() > JavaFoldingBuilderBase.getPlaceholderText(elementToFold).length()) {
            list2.add(new FoldingDescriptor(elementToFold, range));
        }
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        FoldingDescriptor classes2;
        PsiJavaModule module2;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file2 = (PsiJavaFile)root;
        PsiImportList importList = file2.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.getRangeToFold((PsiElement)importList)) != null && rangeToFold.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor((PsiElement)importList, rangeToFold);
            descriptor.setCanBeRemovedWhenCollapsed(true);
            descriptors.add(descriptor);
        }
        if ((module2 = file2.getModuleDeclaration()) != null) {
            JavaFoldingBuilderBase.addElementsToFold(descriptors, module2, document);
        }
        for (PsiClass aClass : classes2 = file2.getClasses()) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addElementsToFold(descriptors, aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilderBase.getFileHeader(file2);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiJavaFile anchorElementToUse = file2;
            PsiElement candidate = file2.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals((Object)range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            descriptors.add(new FoldingDescriptor((PsiElement)anchorElementToUse, range));
        }
    }

    private static void addElementsToFold(@NotNull List<FoldingDescriptor> list2, @NotNull PsiJavaModule module2, @NotNull Document document) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        JavaFoldingBuilderBase.addToFold(list2, (PsiElement)module2, document, true);
        JavaFoldingBuilderBase.addDocCommentToFold(list2, document, (PsiJavaDocumentedElement)module2);
        JavaFoldingBuilderBase.addAnnotationsToFold(module2.getModifierList(), list2, document);
    }

    private void addElementsToFold(@NotNull List<FoldingDescriptor> list2, @NotNull PsiClass aClass, @NotNull Document document, boolean foldJavaDocs, boolean quick) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        PsiElement parent = aClass.getParent();
        if (!(parent instanceof PsiJavaFile) || ((PsiJavaFile)parent).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list2, (PsiElement)aClass, document, true);
        }
        if (foldJavaDocs) {
            JavaFoldingBuilderBase.addDocCommentToFold(list2, document, (PsiJavaDocumentedElement)aClass);
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(aClass.getModifierList(), list2, document);
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child = aClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiCodeBlock body2;
                PsiMethod method = (PsiMethod)child;
                boolean oneLiner = this.addOneLineMethodFolding(list2, method);
                if (!oneLiner) {
                    JavaFoldingBuilderBase.addToFold(list2, (PsiElement)method, document, true);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(method.getModifierList(), list2, document);
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list2, document, (PsiJavaDocumentedElement)method);
                }
                if ((body2 = method.getBody()) == null || oneLiner) continue;
                this.addCodeBlockFolds((PsiElement)body2, list2, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list2, document, (PsiJavaDocumentedElement)field);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(field.getModifierList(), list2, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds((PsiElement)initializer, list2, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds((PsiElement)field, list2, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                JavaFoldingBuilderBase.addToFold(list2, child, document, true);
                this.addCodeBlockFolds(child, list2, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addElementsToFold(list2, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addCommentFolds((PsiComment)child, processedComments, list2);
        }
    }

    private static void addDocCommentToFold(@NotNull List<FoldingDescriptor> list2, @NotNull Document document, @NotNull PsiJavaDocumentedElement element) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        PsiDocComment docComment = element.getDocComment();
        if (docComment != null) {
            JavaFoldingBuilderBase.addToFold(list2, (PsiElement)docComment, document, true);
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<FoldingDescriptor> descriptorList, @NotNull PsiMethod method) {
        if (descriptorList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorList", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addOneLineMethodFolding"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addOneLineMethodFolding"));
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods()) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body2 = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body2 == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body2.getLBrace();
        PsiJavaToken rBrace = body2.getRBrace();
        PsiStatement[] statements = body2.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (statement2.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)lBrace, (PsiElement)statement2, document) || !JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)statement2, (PsiElement)rBrace, document)) {
            return false;
        }
        int leftStart = method.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body2.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement2.getTextRange().getStartOffset();
        int rightStart = statement2.getTextRange().getEndOffset();
        int rightEnd = body2.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin((PsiElement)method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)lBrace, leftStart, leftEnd, group, leftText));
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)rBrace, rightStart, rightEnd, group, rightText));
        return true;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        return JavaFoldingBuilderBase.getPlaceholderText(SourceTreeToPsiMap.treeToPsiNotNull(node));
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isRegionCollapsedByDefault"));
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken && element.getParent() instanceof PsiAnonymousClass) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiJavaToken && element.getParent() instanceof PsiCodeBlock && element.getParent().getParent() instanceof PsiMethod) {
            return settings.isCollapseOneLineMethods();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (element instanceof PsiMethod) {
                if (!settings.isCollapseAccessors() && !settings.isCollapseMethods()) {
                    return false;
                }
                if (JavaFoldingBuilderBase.isSimplePropertyAccessor((PsiMethod)element)) {
                    return settings.isCollapseAccessors();
                }
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiJavaFile) {
                if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                    return false;
                }
                PsiElement firstChild = parent.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        if (element instanceof PsiComment) {
            return settings.isCollapseEndOfLineComments();
        }
        if (element instanceof PsiLambdaExpression) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiJavaModule) {
            return false;
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private void addCodeBlockFolds(@NotNull PsiElement scope, final @NotNull List<FoldingDescriptor> foldElements, final @NotNull Set<PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        final boolean dumb = DumbService.isDumb((Project)scope.getProject());
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, foldElements, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)aClass, document, true);
                    JavaFoldingBuilderBase.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitNewExpression(expression2);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)expression2, document, true);
                }
                super.visitLambdaExpression(expression2);
            }

            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addCommentFolds(comment, processedComments, foldElements);
                super.visitComment(comment);
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<FoldingDescriptor> foldElements, @NotNull Set<PsiElement> processedComments, boolean quick) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<NamedFoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<NamedFoldingDescriptor> list2 = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                foldElements.addAll(descriptors);
                this.addCodeBlockFolds((PsiElement)closureFolding.methodBody, foldElements, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        if ("->" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "rightArrow"));
        }
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "fitsRightMargin"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "fitsRightMargin"));
        }
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getProject(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull Project var1, int var2);

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isCustomFoldingCandidate"));
        }
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isCustomFoldingRoot"));
        }
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }
}

