/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodWithOverridingPercentMember
extends PsiMethodMember {
    private final int myOverridingPercent;
    public static final Comparator<PsiMethodMember> COMPARATOR = (e1, e2) -> {
        if (!(e1 instanceof PsiMethodWithOverridingPercentMember)) {
            if (!(e2 instanceof PsiMethodWithOverridingPercentMember)) {
                return e1.equals(e2) ? 0 : -1;
            }
            return -1;
        }
        if (!(e2 instanceof PsiMethodWithOverridingPercentMember)) {
            return 1;
        }
        int sub = ((PsiMethodWithOverridingPercentMember)e2).myOverridingPercent - ((PsiMethodWithOverridingPercentMember)e1).myOverridingPercent;
        if (sub != 0) {
            return sub;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(e1.getText(), e2.getText());
    };
    private static final Set<String> EXCLUDED_JAVA_LANG_OBJECT_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"hashCode", "finalize", "clone", "equals", "toString"});

    public PsiMethodWithOverridingPercentMember(CandidateInfo info, int overridingPercent) {
        super(info);
        this.myOverridingPercent = overridingPercent;
    }

    public void renderTreeNode(SimpleColoredComponent component, JTree tree) {
        component.append(this.myOverridingPercent + "% ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        super.renderTreeNode(component, tree);
    }

    public int getOverridingPercent() {
        return this.myOverridingPercent;
    }

    @NotNull
    public static PsiMethodWithOverridingPercentMember[] calculateOverridingPercents(@NotNull Collection<CandidateInfo> candidateInfos) {
        if (candidateInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateInfos", "com/intellij/codeInsight/generation/PsiMethodWithOverridingPercentMember", "calculateOverridingPercents"));
        }
        ArrayList<PsiMethodWithOverridingPercentMember> result2 = new ArrayList<PsiMethodWithOverridingPercentMember>(candidateInfos.size());
        HashMap<String, Collection> classShortNames2Inheritors = new HashMap<String, Collection>();
        for (CandidateInfo candidateInfo : candidateInfos) {
            int percent;
            int allInheritorsCount;
            PsiClass containingClass;
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            if (method.hasModifierProperty("final") || method.isConstructor() || method.isDeprecated() || EXCLUDED_JAVA_LANG_OBJECT_METHOD_NAMES.contains(method.getName()) || (containingClass = method.getContainingClass()) == null) continue;
            String classShortName = containingClass.getName();
            Collection allInheritors = (Collection)classShortNames2Inheritors.get(classShortName);
            if (allInheritors == null) {
                allInheritors = ClassInheritorsSearch.search((PsiClass)containingClass).findAll();
                classShortNames2Inheritors.put(classShortName, allInheritors);
            }
            if ((allInheritorsCount = allInheritors.size() - 1) <= 0 || (percent = PsiMethodWithOverridingPercentMember.searchForOverridingCount(method, allInheritors) * 100 / allInheritorsCount) <= 1) continue;
            result2.add(new PsiMethodWithOverridingPercentMember(candidateInfo, percent));
        }
        PsiMethodWithOverridingPercentMember[] psiMethodWithOverridingPercentMemberArray = result2.toArray(new PsiMethodWithOverridingPercentMember[result2.size()]);
        if (psiMethodWithOverridingPercentMemberArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/PsiMethodWithOverridingPercentMember", "calculateOverridingPercents"));
        }
        return psiMethodWithOverridingPercentMemberArray;
    }

    private static int searchForOverridingCount(PsiMethod method, Collection<PsiClass> containingClassInheritors) {
        int counter = 0;
        block0: for (PsiClass inheritor : containingClassInheritors) {
            if (!(inheritor instanceof PsiExtensibleClass)) continue;
            List<PsiMethod> ownMethods = ((PsiExtensibleClass)inheritor).getOwnMethods();
            for (PsiMethod ownMethod : ownMethods) {
                if (!PsiMethodWithOverridingPercentMember.maybeSuper(method, ownMethod)) continue;
                ++counter;
                continue block0;
            }
        }
        return counter;
    }

    private static boolean maybeSuper(@NotNull PsiMethod superMethod, @NotNull PsiMethod method) {
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/generation/PsiMethodWithOverridingPercentMember", "maybeSuper"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/generation/PsiMethodWithOverridingPercentMember", "maybeSuper"));
        }
        if (!superMethod.getName().equals(method.getName())) {
            return false;
        }
        PsiParameterList superMethodParameterList = superMethod.getParameterList();
        PsiParameterList methodParameterList = method.getParameterList();
        if (superMethodParameterList.getParametersCount() != methodParameterList.getParametersCount()) {
            return false;
        }
        PsiParameter[] superMethodParameters = superMethodParameterList.getParameters();
        PsiParameter[] methodParameters = methodParameterList.getParameters();
        for (int i2 = 0; i2 < methodParameters.length; ++i2) {
            if (StringUtil.equals((CharSequence)PsiMethodWithOverridingPercentMember.getTypeShortName(superMethodParameters[i2].getType()), (CharSequence)PsiMethodWithOverridingPercentMember.getTypeShortName(methodParameters[i2].getType()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getTypeShortName(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/generation/PsiMethodWithOverridingPercentMember", "getTypeShortName"));
        }
        if (type2 instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type2).getBoxedTypeName();
        }
        if (type2 instanceof PsiClassType) {
            return ((PsiClassType)type2).getClassName();
        }
        if (type2 instanceof PsiArrayType) {
            return PsiMethodWithOverridingPercentMember.getTypeShortName(((PsiArrayType)type2).getComponentType()) + "[]";
        }
        return null;
    }

    public String toString() {
        return "PsiMethodWithOverridingPercentMember{myOverridingPercent=" + this.myOverridingPercent + ", myElement=" + this.getElement() + '}';
    }
}

