/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.JavaBraceMatcher;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class JavaPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    public JavaPairedBraceMatcher() {
        super(new JavaBraceMatcher(), (Language)JavaLanguage.INSTANCE);
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.isBrace(iterator, fileText, fileType, true);
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.isBrace(iterator, fileText, fileType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBrace(HighlighterIterator iterator, CharSequence fileText, FileType fileType, boolean left) {
        IElementType opposite;
        BracePair pair2 = this.findPair(left, iterator, fileText, fileType);
        if (pair2 == null) {
            return false;
        }
        if ((left ? pair2.getRightBraceType() : pair2.getLeftBraceType()) != (opposite = left ? JavaTokenType.GT : JavaTokenType.LT)) {
            return true;
        }
        if (fileType != JavaFileType.INSTANCE) {
            return false;
        }
        IElementType braceElementType = left ? JavaTokenType.LT : JavaTokenType.GT;
        int count = 0;
        try {
            int paired = 1;
            while (true) {
                ++count;
                if (left) {
                    iterator.advance();
                } else {
                    iterator.retreat();
                }
                if (iterator.atEnd()) break;
                IElementType tokenType = iterator.getTokenType();
                if (tokenType == opposite) {
                    if (--paired != 0) continue;
                    boolean bl = true;
                    return bl;
                }
                if (tokenType == braceElementType) {
                    ++paired;
                    continue;
                }
                if (Holder.TYPE_TOKENS.contains(tokenType)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            while (count-- > 0) {
                if (left) {
                    iterator.retreat();
                    continue;
                }
                iterator.advance();
            }
        }
    }

    private static class Holder {
        private static final TokenSet TYPE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.AT, JavaTokenType.RBRACKET, JavaTokenType.LBRACKET, JavaTokenType.QUEST, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD})});

        private Holder() {
        }
    }
}

