/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        return element instanceof PsiVariable && !(element instanceof ImplicitVariable) || element instanceof PsiClass || element instanceof PsiAnnotationMethod && !(element instanceof PsiCompiledElement);
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        if (element instanceof PsiVariable && ((PsiVariable)element).getInitializer() != null) {
            return true;
        }
        return element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getReferenceAccess"));
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression2) {
        PsiElement actualReferee;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getExpressionAccess"));
        }
        if (!(expression2 instanceof PsiExpression)) {
            if (expression2 instanceof PsiNameValuePair || expression2 instanceof PsiIdentifier) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        PsiExpression expr = (PsiExpression)expression2;
        boolean readAccess = PsiUtil.isAccessedForReading((PsiExpression)expr);
        boolean writeAccess = PsiUtil.isAccessedForWriting((PsiExpression)expr);
        if (!writeAccess && expr instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr).resolve()) instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)actualReferee))) {
            writeAccess = true;
            readAccess = false;
        }
        if (writeAccess && readAccess) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }
}

