/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairedBraceMatcherAdapter
implements NontrivialBraceMatcher,
PairedBraceMatcher {
    private final PairedBraceMatcher myMatcher;
    private final Language myLanguage;

    public PairedBraceMatcherAdapter(PairedBraceMatcher matcher, Language language) {
        this.myMatcher = matcher;
        this.myLanguage = language;
    }

    @NotNull
    public BracePair[] getPairs() {
        BracePair[] bracePairArray = this.myMatcher.getPairs();
        if (bracePairArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "getPairs"));
        }
        return bracePairArray;
    }

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        BracePair[] pairs;
        for (BracePair pair2 : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair2.getLeftBraceType() && tokenType != pair2.getRightBraceType()) continue;
            return this.myLanguage.hashCode();
        }
        return -1;
    }

    @Nullable
    public BracePair findPair(boolean left, HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair2 : pairs = this.myMatcher.getPairs()) {
            if (tokenType != (left ? pair2.getLeftBraceType() : pair2.getRightBraceType())) continue;
            return pair2;
        }
        return null;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(true, iterator, fileText, fileType) != null;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(false, iterator, fileText, fileType) != null;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type2) {
        BracePair[] pairs;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "getOppositeBraceTokenType"));
        }
        for (BracePair pair2 : pairs = this.myMatcher.getPairs()) {
            if (type2 == pair2.getRightBraceType()) {
                return pair2.getLeftBraceType();
            }
            if (type2 != pair2.getLeftBraceType()) continue;
            return pair2.getRightBraceType();
        }
        return null;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        BracePair[] pairs;
        for (BracePair pair2 : pairs = this.myMatcher.getPairs()) {
            if ((tokenType != pair2.getLeftBraceType() || tokenType2 != pair2.getRightBraceType()) && (tokenType != pair2.getRightBraceType() || tokenType2 != pair2.getLeftBraceType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text2, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair2 : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair2.getRightBraceType() && tokenType != pair2.getLeftBraceType()) continue;
            return pair2.isStructural();
        }
        return false;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "isPairedBracesAllowedBeforeType"));
        }
        return this.myMatcher.isPairedBracesAllowedBeforeType(lbraceType, contextType);
    }

    @Override
    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return this.myMatcher.getCodeConstructStart(file2, openingBraceOffset);
    }

    @Override
    @NotNull
    public List<IElementType> getOppositeBraceTokenTypes(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "getOppositeBraceTokenTypes"));
        }
        List<IElementType> result2 = null;
        for (BracePair pair2 : this.myMatcher.getPairs()) {
            IElementType match = null;
            if (type2 == pair2.getRightBraceType()) {
                match = pair2.getLeftBraceType();
            }
            if (type2 == pair2.getLeftBraceType()) {
                match = pair2.getRightBraceType();
            }
            if (match == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<IElementType>(2);
            }
            result2.add(match);
        }
        List<IElementType> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "getOppositeBraceTokenTypes"));
        }
        return list2;
    }

    @Override
    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (braceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "braceType", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "shouldStopMatch"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter", "shouldStopMatch"));
        }
        if (this.myMatcher instanceof BraceMatcherTerminationAspect) {
            return ((BraceMatcherTerminationAspect)this.myMatcher).shouldStopMatch(forward, braceType, iterator);
        }
        return false;
    }
}

